/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.text;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Graphics;
import java.util.ConcurrentModificationException;
import javax.swing.JTextPane;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;

public class JTextPanePlaceholder
extends JTextPane {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final String placeholderText;

    public JTextPanePlaceholder(String placeholder, String value) {
        this(placeholder);
        this.setText(value);
    }

    public JTextPanePlaceholder(String placeholder) {
        this.placeholderText = placeholder;
        UiUtil.initialize(this);
    }

    @Override
    public void paint(Graphics g) {
        try {
            super.paint(g);
            if (StringUtils.isEmpty(Jsoup.parse(this.getText()).text().trim())) {
                UiUtil.drawPlaceholder(this, g, this.placeholderText);
            }
        }
        catch (ClassCastException | IllegalArgumentException | IndexOutOfBoundsException | ConcurrentModificationException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }
}

