/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tree;

import com.jsql.util.LogLevelUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImageOverlap
extends ImageIcon {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final String iconPathOverlap;

    public ImageOverlap(String main, String iconPathOverlap) {
        super(Objects.requireNonNull(ImageOverlap.class.getClassLoader().getResource(main)));
        this.iconPathOverlap = iconPathOverlap;
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        super.paintIcon(c, g, x, y);
        try {
            BufferedImage im2 = ImageIO.read(Objects.requireNonNull(ImageOverlap.class.getClassLoader().getResource(this.iconPathOverlap)));
            g.drawImage(im2, (this.getIconWidth() - im2.getWidth()) / 2, (this.getIconHeight() - im2.getHeight()) / 2, null);
        }
        catch (IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }
}

