/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tree;

import com.jsql.util.LogLevelUtil;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.JProgressBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProgressBarPausable
extends JProgressBar {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private boolean isIconDisplayed = false;

    @Override
    public void paint(Graphics g) {
        try {
            super.paint(g);
        }
        catch (InternalError e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        if (this.isIconDisplayed) {
            try {
                BufferedImage im2 = ImageIO.read(Objects.requireNonNull(ProgressBarPausable.class.getClassLoader().getResource("swing/images/icons/pause.png")));
                g.drawImage(im2, (this.getWidth() - im2.getWidth()) / 2, (this.getHeight() - im2.getHeight()) / 2, null);
            }
            catch (IOException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
        }
    }

    public void pause() {
        this.isIconDisplayed = true;
    }
}

