/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tree.model;

import com.jsql.model.bean.database.AbstractElementDatabase;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import com.jsql.view.swing.menubar.JMenuItemWithMargin;
import com.jsql.view.swing.tree.ActionLoadStop;
import com.jsql.view.swing.tree.ActionPauseUnpause;
import com.jsql.view.swing.tree.ImageObserverAnimated;
import com.jsql.view.swing.tree.ImageOverlap;
import com.jsql.view.swing.tree.PanelNode;
import com.jsql.view.swing.tree.model.JPopupMenuCustomExtract;
import com.jsql.view.swing.tree.model.NodeModelDatabase;
import com.jsql.view.swing.tree.model.NodeModelTable;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiStringUtil;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractNodeModel {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private AbstractElementDatabase elementDatabase;
    private String textEmptyNode;
    private int indexProgress = 0;
    private boolean isSelected = false;
    private boolean isRunning = false;
    private boolean isContainingSelection = false;
    private boolean isLoaded = false;
    private boolean isProgressing = false;
    private boolean isLoading = false;
    private PanelNode panelNode;
    private boolean isEdited;

    protected AbstractNodeModel(AbstractElementDatabase elementDatabase) {
        this.elementDatabase = elementDatabase;
    }

    protected AbstractNodeModel(String emptyObject) {
        this.textEmptyNode = emptyObject;
    }

    protected abstract void buildMenu(JPopupMenuCustomExtract var1, TreePath var2);

    public abstract boolean isPopupDisplayable();

    protected abstract Icon getLeafIcon(boolean var1);

    public abstract void runAction();

    public void showPopup(DefaultMutableTreeNode currentTableNode, TreePath path, MouseEvent e) {
        JPopupMenuCustomExtract popupMenu = new JPopupMenuCustomExtract();
        AbstractSuspendable suspendableTask = MediatorHelper.model().getMediatorUtils().getThreadUtil().get(this.elementDatabase);
        this.initializeItemLoadPause(currentTableNode, popupMenu, suspendableTask);
        this.initializeItemRenameReload(currentTableNode, path, popupMenu);
        this.buildMenu(popupMenu, path);
        this.displayPopupMenu(e, popupMenu);
    }

    private void displayPopupMenu(MouseEvent e, JPopupMenuCustomExtract popupMenu) {
        popupMenu.applyComponentOrientation(ComponentOrientation.getOrientation(I18nUtil.getLocaleDefault()));
        popupMenu.show(MediatorHelper.treeDatabase(), ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getLocaleDefault())) ? e.getX() - popupMenu.getWidth() : e.getX(), e.getY());
        popupMenu.setLocation(ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getLocaleDefault())) ? e.getXOnScreen() - popupMenu.getWidth() : e.getXOnScreen(), e.getYOnScreen());
    }

    private void initializeItemRenameReload(DefaultMutableTreeNode currentTableNode, TreePath path, JPopupMenuCustomExtract popupMenu) {
        String textReload = this instanceof NodeModelDatabase ? I18nViewUtil.valueByKey("RELOAD_TABLES") : (this instanceof NodeModelTable ? I18nViewUtil.valueByKey("RELOAD_COLUMNS") : "?");
        JMenuItemWithMargin menuItemReload = new JMenuItemWithMargin(textReload);
        menuItemReload.setEnabled(!this.isRunning);
        menuItemReload.addActionListener(actionEvent -> this.runAction());
        JMenuItemWithMargin menuItemRename = new JMenuItemWithMargin(I18nViewUtil.valueByKey("RENAME_NODE"));
        menuItemRename.setEnabled(!this.isRunning);
        menuItemRename.addActionListener(actionEvent -> {
            AbstractNodeModel nodeModel = (AbstractNodeModel)currentTableNode.getUserObject();
            nodeModel.setIsEdited(true);
            this.getPanel().getLabel().setVisible(false);
            this.getPanel().getEditable().setVisible(true);
            MediatorHelper.treeDatabase().setSelectionPath(path);
        });
        popupMenu.add(new JSeparator());
        popupMenu.add(menuItemRename);
        popupMenu.add(menuItemReload);
    }

    private void initializeItemLoadPause(DefaultMutableTreeNode currentTableNode, JPopupMenuCustomExtract popupMenu, AbstractSuspendable suspendableTask) {
        JMenuItemWithMargin menuItemLoad = new JMenuItemWithMargin(this.isRunning ? I18nViewUtil.valueByKey("THREAD_STOP") : I18nViewUtil.valueByKey("THREAD_LOAD"), 'o');
        if (!this.isContainingSelection && !this.isRunning) {
            menuItemLoad.setEnabled(false);
        }
        menuItemLoad.addActionListener(new ActionLoadStop(this, currentTableNode));
        JMenuItemWithMargin menuItemPause = new JMenuItemWithMargin(suspendableTask != null && suspendableTask.isPaused() ? I18nViewUtil.valueByKey("THREAD_RESUME") : I18nViewUtil.valueByKey("THREAD_PAUSE"), 's');
        if (!this.isRunning) {
            menuItemPause.setEnabled(false);
        }
        menuItemPause.addActionListener(new ActionPauseUnpause(this));
        popupMenu.add(menuItemLoad);
        popupMenu.add(menuItemPause);
    }

    public Component getComponent(JTree tree, Object nodeRenderer, boolean isSelected, boolean isLeaf, boolean hasFocus) {
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)nodeRenderer;
        this.panelNode = new PanelNode(tree, currentNode);
        this.initializeIcon(isLeaf);
        AbstractNodeModel nodeModel = (AbstractNodeModel)currentNode.getUserObject();
        this.initializeEditable(nodeModel.isEdited);
        this.initializeLabel(isSelected, hasFocus, nodeModel.isEdited);
        this.initializeProgress(currentNode);
        return this.panelNode;
    }

    private void initializeIcon(boolean isLeaf) {
        this.panelNode.showIcon();
        this.panelNode.setIcon(this.getLeafIcon(isLeaf));
    }

    private void initializeProgress(DefaultMutableTreeNode currentNode) {
        if (this.isLoading) {
            this.displayProgress(this.panelNode, currentNode);
            this.panelNode.hideIcon();
        } else if (this.isProgressing) {
            this.panelNode.showLoader();
            this.panelNode.hideIcon();
            AbstractSuspendable suspendableTask = MediatorHelper.model().getMediatorUtils().getThreadUtil().get(this.elementDatabase);
            if (suspendableTask != null && suspendableTask.isPaused()) {
                ImageOverlap animatedGIFPaused = new ImageOverlap("swing/images/icons/progressBar.gif", "swing/images/icons/pause.png");
                animatedGIFPaused.setImageObserver(new ImageObserverAnimated(MediatorHelper.treeDatabase(), currentNode));
                this.panelNode.setLoaderIcon(animatedGIFPaused);
            }
        }
    }

    private void initializeLabel(boolean isSelected, boolean hasFocus, boolean isEdited) {
        try {
            this.panelNode.getLabel().setText(UiStringUtil.detectUtf8Html(this.toString()));
        }
        catch (NullPointerException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        this.panelNode.getLabel().setVisible(!isEdited);
        if (isSelected) {
            if (hasFocus) {
                this.panelNode.getLabel().setBackground(UiUtil.COLOR_FOCUS_GAINED);
                this.panelNode.getLabel().setBorder(UiUtil.BORDER_FOCUS_GAINED);
            } else {
                this.panelNode.getLabel().setBackground(UiUtil.COLOR_FOCUS_LOST);
                this.panelNode.getLabel().setBorder(UiUtil.BORDER_FOCUS_LOST);
            }
        } else {
            this.panelNode.getLabel().setBackground(Color.WHITE);
            this.panelNode.getLabel().setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
    }

    private void initializeEditable(boolean isEdited) {
        if (StringUtil.isUtf8(this.getElementDatabase().toString())) {
            this.panelNode.getEditable().setFont(UiUtil.FONT_MONO_ASIAN);
        } else {
            this.panelNode.getEditable().setFont(UiUtil.FONT_NON_MONO);
        }
        this.panelNode.getEditable().setText(StringUtil.detectUtf8(this.getElementDatabase().toString()));
        this.panelNode.getEditable().setVisible(isEdited);
    }

    protected void displayProgress(PanelNode panelNode, DefaultMutableTreeNode currentNode) {
        int dataCount = this.elementDatabase.getChildCount();
        panelNode.getProgressBar().setMaximum(dataCount);
        panelNode.getProgressBar().setValue(this.indexProgress);
        panelNode.getProgressBar().setVisible(true);
        AbstractSuspendable suspendableTask = MediatorHelper.model().getMediatorUtils().getThreadUtil().get(this.elementDatabase);
        if (suspendableTask != null && suspendableTask.isPaused()) {
            panelNode.getProgressBar().pause();
        }
    }

    public String toString() {
        return this.elementDatabase != null ? this.elementDatabase.getLabelCount() : this.textEmptyNode;
    }

    protected AbstractElementDatabase getParent() {
        return this.elementDatabase.getParent();
    }

    public AbstractElementDatabase getElementDatabase() {
        return this.elementDatabase;
    }

    public int getIndexProgress() {
        return this.indexProgress;
    }

    public void setIndexProgress(int indexProgress) {
        this.indexProgress = indexProgress;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    public boolean isContainingSelection() {
        return this.isContainingSelection;
    }

    public void setContainingSelection(boolean isContainingSelection) {
        this.isContainingSelection = isContainingSelection;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean isLoaded) {
        this.isLoaded = isLoaded;
    }

    public boolean isProgressing() {
        return this.isProgressing;
    }

    public void setProgressing(boolean isProgressing) {
        this.isProgressing = isProgressing;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void setLoading(boolean isLoading) {
        this.isLoading = isLoading;
    }

    public PanelNode getPanel() {
        return this.panelNode;
    }

    public void setIsEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    public void setText(String textI18n) {
        this.textEmptyNode = textI18n;
    }
}

