# Generated by OTF2 Template Engine

import _otf2.GlobalDefWriter
from .definitions import *


class DefinitionWriter(object):
    """
        This class wraps the OTF2_GlobalDefWriter.

        Used internally only.
    """
    def __init__(self, archive):
        assert archive
        self._handle = _otf2.Archive_GetGlobalDefWriter(archive._handle)
        self._archive = archive

    def __enter__(self):
        assert self._handle
        return self

    def __exit__(self, *args):
        self.close()

    def __del__(self):
        """Destructor.  Calls close()."""
        # The try/except block is in case this is called at program
        # exit time, when it's possible that globals have already been
        # deleted, and then the close() call might fail.  Since
        # there's nothing we can do about such failures and they annoy
        # the end users, we suppress the traceback.
        try:
            self.close()
        except:
            pass

    def close(self):
        if self._handle:
            try:
                _otf2.Archive_CloseGlobalDefWriter(self._archive._handle, self._handle)
            finally:
                self._archive = None
                self._handle = None

    @property
    def handle(self):
        """
            Gives access to the underlaying OTF2 global definition writer
        """
        if self._handle is None:
            raise TraceWriterError(
                "Trying to access handle, but GlobalDefWriter is already closed.")
        return self._handle

    @property
    def number_of_definitions(self):
        return _otf2.GlobalDefWriter.GetNumberOfDefinitions(self._handle)

    @property
    def number_of_locations(self):
        return _otf2.GlobalDefWriter.GetNumberOfLocations(self._handle)

    def write(self, definition, *args):
        {
@otf2 for def in defs|global_defs|exclude(ClockProperties):
            @@def.name@@: self.write_@@def.lower@@,
@otf2 endfor
        }[type(definition)](*args)
@otf2 for def in defs|global_defs:
@otf2  if def == IoParadigm:

    def write_io_paradigm(this, self, identification, name, ioParadigmClass, ioParadigmFlags, properties, types, values):
        _otf2.GlobalDefWriter_WriteIoParadigm(this._handle, self, identification, name,
                                              ioParadigmClass, ioParadigmFlags, properties, types, values)
@otf2  elif def == Group:

    def write_group(this, self, name, groupType, paradigm, groupFlags, members):
        _otf2.GlobalDefWriter_WriteGroup(this._handle, self, name, groupType, paradigm, groupFlags, members)
@otf2  elif def == MetricClass:

    def write_metric_class(this, self, metricMembers, metricOccurrence, recorderKind):
        _otf2.GlobalDefWriter_WriteMetricClass(this._handle, self, metricMembers, metricOccurrence, recorderKind)
@otf2  elif def == CartTopology:

    def write_cart_topology(this, self, name, communicator, cartDimensions):
        _otf2.GlobalDefWriter_WriteCartTopology(this._handle, self, name, communicator, cartDimensions)
@otf2  elif def == CartCoordinate:

    def write_cart_coordinate(this, cartTopology, rank, coordinates):
        _otf2.GlobalDefWriter_WriteCartCoordinate(this._handle, cartTopology, rank, coordinates)
@otf2  else:

    def write_@@def.lower@@(this@@def.py_funcargs()@@):
        _otf2.GlobalDefWriter_Write@@def.name@@(this._handle@@def.py_funcargs()@@)
@otf2  endif
@otf2 endfor
