[comment {-*- tcl -*- doctools manpage}]
[manpage_begin tcl::chan::fifo n 1]
[keywords fifo]
[keywords {in-memory channel}]
[keywords {reflected channel}]
[keywords {tip 219}]
[keywords {virtual channel}]
[copyright {2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Reflected/virtual channel support}]
[category  Channels]
[titledesc {In-memory fifo channel}]
[require Tcl 8.5]
[require TclOO]
[require tcl::chan::events [opt 1]]
[require tcl::chan::fifo [opt 1]]
[description]
[para]

The [package tcl::chan::fifo] package provides a command creating
channels which live purely in memory. Access is fifo-like, i.e. things
are read out of the channel in the order they were written to it.

This is equivalent to the fifo channels provided by the package
[package Memchan], except that this is written in pure Tcl, not C. On
the other hand, [package Memchan] is usable with Tcl 8.4 and before,
whereas this package requires Tcl 8.5 or higher, and [package TclOO].

[para] The internal [package TclOO] class implementing the channel
handler is a sub-class of the [package tcl::chan::events] framework.

[section API]

[list_begin definitions]

[call [cmd ::tcl::chan::fifo]]

This command creates a new fifo channel and returns its handle.

[list_end]

[vset CATEGORY virtchannel]
[include ../common-text/feedback.inc]
[manpage_end]
