// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Tetragon

package bpf

import (
	"fmt"
)

/*uapi/linux/bpf.h */
var bpfMapTypeString = map[uint32]string{
	0:  "BPF_MAP_TYPE_UNSPEC",
	1:  "BPF_MAP_TYPE_HASH",
	2:  "BPF_MAP_TYPE_ARRAY",
	3:  "BPF_MAP_TYPE_PROG_ARRAY",
	4:  "BPF_MAP_TYPE_PERF_EVENT_ARRAY",
	5:  "BPF_MAP_TYPE_PERCPU_HASH",
	6:  "BPF_MAP_TYPE_PERCPU_ARRAY",
	7:  "BPF_MAP_TYPE_STACK_TRACE",
	8:  "BPF_MAP_TYPE_CGROUP_ARRAY",
	9:  "BPF_MAP_TYPE_LRU_HASH",
	10: "BPF_MAP_TYPE_LRU_PERCPU_HASH",
	11: "BPF_MAP_TYPE_LPM_TRIE",
	12: "BPF_MAP_TYPE_ARRAY_OF_MAPS",
	13: "BPF_MAP_TYPE_HASH_OF_MAPS",
	14: "BPF_MAP_TYPE_DEVMAP",
	15: "BPF_MAP_TYPE_SOCKMAP",
	16: "BPF_MAP_TYPE_CPUMAP",
	17: "BPF_MAP_TYPE_XSKMAP",
	18: "BPF_MAP_TYPE_SOCKHASH",
	19: "BPF_MAP_TYPE_CGROUP_STORAGE",
	20: "BPF_MAP_TYPE_REUSEPORT_SOCKARRAY",
	21: "BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE",
	22: "BPF_MAP_TYPE_QUEUE",
	23: "BPF_MAP_TYPE_STACK",
	24: "BPF_MAP_TYPE_SK_STORAGE",
	25: "BPF_MAP_TYPE_DEVMAP_HASH",
	26: "BPF_MAP_TYPE_STRUCT_OPS",
	27: "BPF_MAP_TYPE_RINGBUF",
	28: "BPF_MAP_TYPE_INODE_STORAGE",
	29: "BPF_MAP_TYPE_TASK_STORAGE",
	30: "BPF_MAP_TYPE_BLOOM_FILTER",
}

func GetBpfMapType(t uint32) string {
	if t, ok := bpfMapTypeString[t]; ok {
		return t
	}
	return fmt.Sprintf("%d", t)
}
