package testutils

import (
	"io"
	"os"
	"syscall"
)

func CopyFile(toPath, fromPath string, perm os.FileMode) error {
	from, err := os.Open(fromPath)
	if err != nil {
		return err
	}
	defer from.Close()

	to, err := os.OpenFile(toPath, os.O_RDWR|os.O_CREATE|os.O_TRUNC, perm)
	if err != nil {
		return err
	}
	defer to.Close()

	_, err = io.Copy(to, from)
	if err != nil {
		syscall.Unlink(toPath)
	}
	return err
}
