/*
    Copyright (C) 2011 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <stdio.h>

size_t safe_strncat(char *dst, const char *src, size_t n)
{
    char *dp;
    const char *sp;
    size_t len;

    if (!n)
	return strlen(dst)+strlen(src)+1;

    for (dp = dst, len = 0; *dp; dp++, len++);

    for (sp = src; *sp && len < n-1; len++, sp++)
	*dp++ = *sp;

    *dp = 0;

    if (*sp) {
	while (*sp++)
	    len++;
    }

    return len;
}
