/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import spec.jbb.JBButil;
import spec.reporter.JBBReportFilenameFilter;
import spec.reporter.Metrics;
import spec.reporter.ReportProps;
import spec.reporter.TextBlock;
import spec.reporter.TextColumn;
import spec.reporter.TextMetrics;

public class MultiVMTxtReport {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 2000-2005 Hewlett-Packard,All rights reserved,Copyright (c) 1997-2005 Sun Microsystems, Inc.All rights reserved,Licensed Materials - Property of SPEC";
    public String hardware;
    public String metric1;
    public String metric2;
    public String software;
    public String base;
    private TextColumn columnTitle;
    private TextColumn columnValue;
    public String issue;
    public String prefix;
    private String memory;
    public String memoryDescription;
    public TextMetrics[] metrics;
    public String[] metric;
    private static final int pageWidth = 120;
    public ReportProps[] results;
    public boolean SPECInternalUse;
    public boolean validRun = true;
    public String output_directory;
    public int instances = 0;
    public boolean instanceChecksPassed = true;

    public MultiVMTxtReport(String string, String string2, boolean bl) {
        this(string, string2, bl, "SPECjbb.");
    }

    public MultiVMTxtReport(String string, String string2, boolean bl, String string3) {
        int n;
        this.issue = string;
        this.SPECInternalUse = bl;
        this.output_directory = string2;
        this.prefix = string3;
        String string4 = ".raw";
        File file = new File(string2);
        if (!file.exists()) {
            System.out.println("Error: file " + string2 + " doesn't exist.");
            System.exit(1);
        }
        if (!file.isDirectory()) {
            System.out.println("Error: file " + string2 + " is not a directory.");
            System.exit(1);
        }
        JBBReportFilenameFilter jBBReportFilenameFilter = new JBBReportFilenameFilter(string3, string4);
        File[] fileArray = file.listFiles(jBBReportFilenameFilter);
        this.instances = fileArray.length;
        this.results = new ReportProps[fileArray.length];
        this.metrics = new TextMetrics[fileArray.length];
        this.metric = new String[fileArray.length];
        double d = 0.0;
        boolean bl2 = true;
        for (n = 0; n < fileArray.length; ++n) {
            this.results[n] = new ReportProps();
            try {
                this.results[n].load(fileArray[n].getPath());
            }
            catch (IOException iOException) {
                JBButil.getLog().log(Level.WARNING, "Error reading results file " + fileArray[n] + ": " + iOException, iOException);
                System.exit(1);
            }
            this.metrics[n] = new TextMetrics(this.results[n], bl);
            this.metric[n] = this.metrics[n].metric();
            try {
                d += Double.parseDouble(this.metric[n]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                bl2 = false;
                this.metric1 = "n/a";
                this.metric2 = "n/a";
            }
        }
        this.checkInstanceTiming();
        if (bl2) {
            this.metric1 = Metrics.format(d);
            this.metric2 = Metrics.format(d / (double)this.metrics.length);
        }
        this.hardware = this.get("config.hw.vendor") + " " + this.get("config.hw.model");
        for (n = 0; n < this.metrics.length; ++n) {
            if (this.metrics[n].valid) continue;
            this.validRun = false;
        }
        this.software = this.get("config.sw.vendor") + " " + this.get("config.sw.JVM");
        this.memory = this.results[0].get("config.hw.memory");
        this.memoryDescription = this.results[0].get("config.hw.memory_description");
    }

    private String configSection() {
        TextBlock textBlock = new TextBlock(37, "HARDWARE");
        this.columnTitle = new TextColumn(16);
        this.columnValue = new TextColumn(20);
        this.cput("config.hw.vendor", "Vendor");
        this.cput("config.hw.vendor.url", "Vendor URL");
        this.cput("config.hw.model", "Model");
        this.cput("config.hw.processor", "Processor");
        this.cput("config.hw.MHz", "MHz");
        this.cput("config.hw.nchips", "# of Chips");
        this.cput("config.hw.ncores", "# of Cores");
        this.cput("config.hw.ncoresperchip", "# of Cores/Chip");
        this.cput("config.hw.hwThreads", "HW Thresads");
        this.cput("config.sw.procsAvailtoJava", "Procs avail to Java");
        this.cput("config.hw.memory", "Memory (MB)");
        this.cput("config.hw.memory_description", "Memory Details");
        this.cput("config.hw.primaryCache", "L1 Cache");
        this.cput("config.hw.secondaryCache", "L2 Cache");
        this.cput("config.hw.otherCache", "Other Cache");
        this.cput("config.hw.fileSystem", "Filesystem");
        this.cput("config.hw.disk", "Disks");
        this.cput("config.hw.other", "Other H/W");
        textBlock.add(this.columnTitle.join(this.columnValue, " ").merge());
        TextBlock textBlock2 = new TextBlock(37, "SOFTWARE");
        this.columnTitle = new TextColumn(16);
        this.columnValue = new TextColumn(20);
        this.cput("config.sw.vendor", "Vendor");
        this.cput("config.sw.vendor.url", "Vendor URL");
        this.cput("config.sw.JVM", "JVM Version");
        this.cput("config.sw.command_line", "Command Line");
        this.cput("config.sw.JVMheapInitial", "Initial Heap Mem (MB)");
        this.cput("config.sw.JVMheapMax", "Max Heap Mem (MB)");
        this.cput("config.sw.JVMbitness", "JVM addressing bits");
        this.cput("java.class.path", "JVM CLASSPATH");
        this.cput("java.library.path", "JVM BOOTCLASSPATH");
        this.cput("config.sw.OS", "OS Version");
        this.cput("config.sw.other", "Other S/W");
        textBlock2.add(this.columnTitle.join(this.columnValue, " ").merge());
        textBlock2.add("");
        textBlock2.add("AOT Compilation Details");
        if (this.results[0].get("config.sw.aot") != null) {
            textBlock2.add(this.results[0].get("config.sw.aot"));
        }
        textBlock2.add("");
        textBlock2.add("TUNING AND NOTES");
        if (this.results[0].get("config.sw.tuning") != null) {
            textBlock2.add(this.results[0].get("config.sw.tuning"));
        }
        if (this.results[0].get("config.sw.notes") != null) {
            textBlock2.add(this.results[0].get("config.sw.notes"));
        }
        textBlock2.add("");
        TextBlock textBlock3 = textBlock.join(textBlock2);
        textBlock3.add("");
        textBlock2 = new TextBlock(37, "TEST INFORMATION");
        this.columnTitle = new TextColumn(18);
        this.columnValue = new TextColumn(18);
        this.cput("config.test.testedBy", "Tested by");
        this.cput("config.test.specLicense", "SPEC License");
        this.cput("config.test.location", "Test Location");
        this.cput("config.test.date", "Test Date");
        this.cput("config.sw.JVMavailable", "JVM available");
        this.cput("config.hw.available", "H/w available");
        this.cput("config.sw.OSavailable", "OS available");
        this.cput("config.sw.otherAvailable", "Other s/w available");
        textBlock2.add(this.columnTitle.join(this.columnValue, " ").merge());
        textBlock3.add(textBlock2);
        return textBlock3.toString();
    }

    private void cput(String string, String string2) {
        this.columnTitle.add(string2);
        this.columnValue.add(this.get(string));
    }

    private String get(String string) {
        return this.get(string, "MISSING");
    }

    private String get(String string, String string2) {
        String string3 = this.results[0].get(string, string2);
        if (string3.indexOf(60) >= 0) {
            int n = string3.indexOf("<i>");
            if (n >= 0) {
                string3 = string3.substring(0, n) + string3.substring(n + 3);
            }
            if ((n = string3.indexOf("<I>")) >= 0) {
                string3 = string3.substring(0, n) + string3.substring(n + 3);
            }
            if ((n = string3.indexOf("</i>")) >= 0) {
                string3 = string3.substring(0, n) + string3.substring(n + 4);
            }
            if ((n = string3.indexOf("</I>")) >= 0) {
                string3 = string3.substring(0, n) + string3.substring(n + 4);
            }
        }
        return string3;
    }

    public void print(String string) {
        try {
            this.print(new PrintStream(new BufferedOutputStream(new FileOutputStream(string))));
        }
        catch (IOException iOException) {
            JBButil.getLog().log(Level.WARNING, "Error creating output: " + iOException, iOException);
        }
    }

    public void print(PrintStream printStream) {
        String string = "";
        if (!this.instanceChecksPassed) {
            this.validRun = false;
            string = "JVM Instance Timing Checks Failed";
        }
        try {
            int n;
            String string2 = "";
            if (!this.validRun) {
                string2 = "Invalid";
            }
            printStream.println(string2 + " SPECjbb2005                bops = " + this.metric1 + ", bops/JVM = " + this.metric2);
            printStream.println();
            if (string != "") {
                printStream.print("INVALID because " + string);
                printStream.println();
                printStream.println();
            }
            printStream.println(this.hardware);
            printStream.println(this.software);
            this.testBar(printStream);
            printStream.println();
            printStream.println("              Multi JVM Mode");
            printStream.println();
            printStream.println("     JVM run                  JVM Scores");
            for (n = 0; n < this.metrics.length; ++n) {
                printStream.println("        " + (n + 1) + "                        " + this.metric[n]);
            }
            printStream.println("     bops=" + this.metric1 + ", bops/JVM=" + this.metric2);
            printStream.println();
            printStream.println(this.configSection());
            for (n = 0; n < this.metrics.length; ++n) {
                printStream.println();
                printStream.println("                   JVM " + (n + 1) + " Scores");
                printStream.println(this.metrics[n].ratioTable());
                printStream.println();
            }
            printStream.println("\nSPECjbb2005 Version: [" + this.results[0].get("config.benchmark_version", "N/A") + ", " + this.results[0].get("config.benchmark_versionDate", "-") + "]");
            if (this.issue != null && !this.issue.equals("") && this.validRun) {
                printStream.println("Published by SPEC " + this.issue);
            }
            printStream.println("Reporting page (C) Copyright SPEC, 2005. All rights reserved\n");
            printStream.close();
        }
        catch (Exception exception) {
            JBButil.getLog().log(Level.WARNING, "Error: " + exception, exception);
        }
    }

    public void testBar(PrintStream printStream) throws IOException {
        String string = this.results[0].get("config.test.specLicense", "MISSING");
        String string2 = this.results[0].get("config.test.testedBy", "MISSING");
        String string3 = this.results[0].get("config.test.date", "MISSING");
        printStream.println("SPEC license # " + string + ",  " + "Tested by: " + string2 + ",  " + "Test date: " + string3);
    }

    public void checkInstanceTiming() {
        int n;
        int n2 = 0;
        int n3 = 0;
        this.instanceChecksPassed = true;
        long l = 0L;
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MAX_VALUE;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        n2 = this.metrics[0].getWarehousesTested();
        ++n3;
        for (n = 1; n < this.instances && n2 == this.metrics[n].getWarehousesTested(); ++n) {
            ++n3;
        }
        if (n3 != this.instances) {
            System.out.println("INVALID: Instances do not have identical test counts");
            this.instanceChecksPassed = false;
        } else {
            for (n = 1; n <= n2 && this.instanceChecksPassed; ++n) {
                l = 0L;
                l2 = Long.MAX_VALUE;
                l3 = Long.MAX_VALUE;
                l4 = 0L;
                for (int i = 0; i < this.instances; ++i) {
                    l7 = this.metrics[i].start_millis_at_wh(n);
                    if (l7 < l2) {
                        l2 = l7;
                    }
                    if ((l8 = this.metrics[i].rampup_millis_at_wh(n)) > l) {
                        l = l8;
                    }
                    if ((l5 = this.metrics[i].rampdown_millis_at_wh(n)) < l3) {
                        l3 = l5;
                    }
                    if ((l6 = this.metrics[i].end_millis_at_wh(n)) <= l4) continue;
                    l4 = l6;
                }
                this.instanceChecksPassed = l3 > l4 && l2 > l;
            }
        }
    }
}

