/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;
import spec.reporter.ReportProps;

public class Table {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 2000-2005 Hewlett-Packard,All rights reserved,Copyright (c) 1997-2005 Sun Microsystems, Inc.All rights reserved,Licensed Materials - Property of SPEC";
    private static String tablePrefix = "<TABLE WIDTH=\"100%\" BORDER=1 CELLSPACING=2 CELLPADDING=0><TR><TH COLSPAN=2>\n";
    private boolean free;
    private String heading;
    private Vector<String> items;
    private ReportProps props;
    private ReportProps titles;

    Table(String string, BufferedReader bufferedReader, ReportProps reportProps, ReportProps reportProps2, boolean bl) {
        this.heading = string;
        this.props = reportProps;
        this.titles = reportProps2;
        this.free = bl;
        this.items = new Vector();
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null && !string2.equals("")) {
                this.items.addElement(string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String expandN(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        boolean bl = false;
        for (int i = 0; i < cArray.length - 1; ++i) {
            if (cArray[i] == '\\' && cArray[i + 1] == 'n') {
                stringBuffer.append('\n');
                ++i;
                bl = true;
                continue;
            }
            stringBuffer.append(cArray[i]);
            bl = false;
        }
        if (!bl) {
            stringBuffer.append(cArray[cArray.length - 1]);
        }
        return stringBuffer.toString();
    }

    private String insertBreakAfterColons(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        for (int i = 0; i < cArray.length; ++i) {
            stringBuffer.append(cArray[i]);
            if (i <= 1 || cArray[i] != ':' && cArray[i] != ';' || cArray[i - 2] == ':' || cArray[i - 2] == ';') continue;
            stringBuffer.append("<BR>");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(tablePrefix);
        stringBuffer.append(this.heading);
        stringBuffer.append("</TH></TR>\n");
        for (int i = 0; i < this.items.size(); ++i) {
            String string;
            String string2 = this.items.elementAt(i);
            String string3 = this.titles.get(string2);
            if (string3 == null) {
                string3 = string2 + "=null";
            }
            if ((string = this.props.get(string2)) == null || string.equals("")) {
                string = "&nbsp;";
            } else if (string2.endsWith(".path")) {
                string = this.insertBreakAfterColons(string);
            } else if (string.startsWith("http://")) {
                string = "<a href=\"" + string + "\">" + string + "</a>";
            }
            if (this.free) {
                stringBuffer.append("<TR><TD>");
                stringBuffer.append(this.expandN(string));
            } else {
                stringBuffer.append("<TR><TD><B>");
                stringBuffer.append(string3);
                stringBuffer.append("</B></TD>\n<TD>");
                stringBuffer.append(string);
            }
            stringBuffer.append("</TD></TR>\n");
        }
        stringBuffer.append("</TABLE>\n");
        return stringBuffer.toString();
    }
}

