// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UABA_4H_TRACE_AARCH64_H_
#define VIXL_SIM_UABA_4H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_uaba_4H[] = {
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x32b5, 0x2224, 0x2ab8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x54d7, 0x4ccc, 0x2ab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x7f7f, 0x4ccd, 0x2aba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x7f80, 0x4cce, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x3335, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x0080, 0x3334, 0x5563, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0x3333, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x3325, 0x54e8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007c, 0x0070, 0x32b8, 0x54e7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006e, 0x0003, 0x32b7, 0x54e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x32b6, 0x2232, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x32b5, 0x2224, 0x2ab8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x54d7, 0x4ccc, 0x2ab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x7f7f, 0x4ccd, 0x2aba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x7f80, 0x4cce, 0x2abb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x4ccf, 0x2abc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f82, 0x4cd0, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f83, 0x7779, 0x7787, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0xaa2c, 0x999b, 0xaa3b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2c, 0xcc4e, 0xcc4f, 0xaa3c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4e, 0xff02, 0xcc50, 0xaa3d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff02, 0xff03, 0xcc51, 0xaa3e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff02, 0xcc50, 0xaa30, 0x8003, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff03, 0xcc51, 0xaa9d, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff04, 0xccbe, 0xaaaa, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff71, 0xcccb, 0xaaab, 0x8012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7e, 0xcccc, 0xaaac, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7f, 0xcccd, 0x5557, 0x800c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0x3334, 0x5556, 0x800b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x3332, 0x5547, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x3324, 0x54da, 0x7f8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006f, 0x32b7, 0x54d9, 0x7f8e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x32b6, 0x54d8, 0x4cda, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x32b5, 0x2224, 0x2ab8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x2223, 0x2aaa, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x4ccb, 0x2aab, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7e, 0x4ccc, 0x2aac, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x4ccd, 0x2aad, 0x0014, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x4cce, 0x2aae, 0x2abd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x4ccf, 0x5557, 0x4cdf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7778, 0x7779, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2b, 0x999a, 0xaa2d, 0x7f94, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4d, 0xcc4e, 0xaa2e, 0x7f95, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xcc4f, 0xaa2f, 0x7f96, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4e, 0xaa2e, 0x7f88, 0x8002, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4f, 0xaa2f, 0x7ff5, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc50, 0xaa9c, 0x8002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccbd, 0xaaa9, 0x8003, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccca, 0xaaaa, 0x8004, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccb, 0xaaab, 0x7fff, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0x5556, 0x7ffe, 0x800c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3332, 0x5554, 0x7fef, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3331, 0x5546, 0x7f82, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3323, 0x54d9, 0x7f81, 0x7f8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b6, 0x54d8, 0x7f80, 0x4cdb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x54d7, 0x4ccc, 0x2ab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x2223, 0x2aaa, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x2aa9, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cca, 0x2aaa, 0x0004, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x2aab, 0x0005, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0x2aac, 0x0006, 0x2abc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccd, 0x2aad, 0x2aaf, 0x4cde, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cce, 0x5556, 0x4cd1, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7777, 0x7778, 0x7f85, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9999, 0xaa2c, 0x7f86, 0x7f94, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4d, 0xaa2d, 0x7f87, 0x7f95, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2c, 0x7f86, 0x7f87, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2d, 0x7f87, 0x7ff4, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2e, 0x7ff4, 0x8001, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa9b, 0x8001, 0x8002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa8, 0x8002, 0x8003, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa9, 0x8003, 0x8000, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0x7ffe, 0x7fff, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x7ffc, 0x7ff0, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5553, 0x7fee, 0x7f83, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5545, 0x7f81, 0x7f82, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d8, 0x7f80, 0x7f81, 0x4cdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x7f7f, 0x4ccd, 0x2aba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x4ccb, 0x2aab, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x2aa9, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa8, 0x0002, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x0003, 0x0004, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x0004, 0x0005, 0x2abb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x0005, 0x2aae, 0x4cdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aac, 0x2aae, 0x4cd0, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x4cd0, 0x7f84, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7777, 0x7f84, 0x7f85, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2b, 0x7f85, 0x7f86, 0x7f94, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f84, 0x7f85, 0x7f86, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f85, 0x7f86, 0x7ff3, 0x000d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f86, 0x7ff3, 0x8000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff3, 0x8000, 0x8001, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0x8002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8002, 0x8001, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x7fff, 0x8000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x7fff, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7ffd, 0x7ff1, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffb, 0x7fef, 0x7f84, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fed, 0x7f82, 0x7f83, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x7f82, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x7f80, 0x4cce, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7e, 0x4ccc, 0x2aac, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cca, 0x2aaa, 0x0004, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa8, 0x0002, 0x0003, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0003, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0003, 0x0004, 0xaaba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0004, 0x2aad, 0xccdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0004, 0x2aad, 0x4ccf, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aad, 0x4ccf, 0x7f83, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccf, 0x7f83, 0x7f84, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f84, 0x7f85, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f84, 0xff85, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f84, 0x7f85, 0xfff2, 0x000c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f85, 0x7ff2, 0xffff, 0x000d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff2, 0x7fff, 0x0000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x0001, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8000, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x0004, 0x001f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x0012, 0x008c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7ff0, 0x007f, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fee, 0x7f83, 0x0080, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f82, 0x0081, 0x3342, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x3335, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x4ccd, 0x5557, 0x800c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x2aab, 0x7fff, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x0003, 0x8000, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x8001, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x8002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x8003, 0xaab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0003, 0xaaac, 0xccdb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x2aac, 0xccce, 0xff8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aac, 0x4cce, 0xff82, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cce, 0x7f82, 0xff83, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f83, 0xff84, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0xff83, 0xff84, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0xff84, 0xfff1, 0x000b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f84, 0xfff1, 0xfffe, 0x000c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff1, 0xfffe, 0xffff, 0x000d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0xffff, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0000, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0002, 0x0003, 0x001e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x0003, 0x0011, 0x008b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x0011, 0x007e, 0x008c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fef, 0x007e, 0x007f, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x007f, 0x0080, 0x3341, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x0080, 0x3334, 0x5563, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x3334, 0x5556, 0x800b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0x5556, 0x7ffe, 0x800c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x7ffe, 0x7fff, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x7fff, 0x8000, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x8000, 0x8001, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8001, 0x8002, 0xaab8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x8002, 0xaaab, 0xccda, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0xaaab, 0xcccd, 0xff8e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcccd, 0xff81, 0xff8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccd, 0xff81, 0xff82, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0xff82, 0xff83, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xff82, 0xff83, 0xfff0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff83, 0xfff0, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0xfff0, 0xfffd, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0xfffd, 0xfffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xfffe, 0xffff, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0x0004, 0x001f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0002, 0x0003, 0x001e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0010, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0010, 0x007d, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x007d, 0x007e, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x007f, 0x3333, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0x3333, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8000, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x8001, 0xaaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0xaaaa, 0xcccc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0xaaaa, 0xcccc, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0xcccc, 0xff80, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0xff80, 0xff81, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff81, 0xff82, 0xff83, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff81, 0xff75, 0xff83, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xff82, 0xffe2, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xffef, 0xffef, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffef, 0xfffc, 0xfff0, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0xfffd, 0xfff1, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xfffe, 0x0012, 0x008c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x0003, 0x0011, 0x008b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0010, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x000f, 0x006f, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000f, 0x007c, 0x0070, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007c, 0x007d, 0x0071, 0x32c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x3325, 0x54e8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x3332, 0x5547, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3332, 0x5554, 0x7fef, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x7ffc, 0x7ff0, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7ffd, 0x7ff1, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x7ff2, 0x7f94, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x7ff3, 0xaa3d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0xaa9c, 0xcc5f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xaaa9, 0xccbe, 0xff13, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa9, 0xcccb, 0xff72, 0xff14, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccb, 0xff7f, 0xff73, 0xff15, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7f, 0xff80, 0xff74, 0xff16, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7f, 0xff73, 0xff08, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff74, 0xff75, 0xff8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xffe1, 0xff82, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffee, 0xffee, 0xff83, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffef, 0xff84, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0xfff0, 0x007f, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0011, 0x007e, 0x008c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0010, 0x007d, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x000f, 0x006f, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000e, 0x006e, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007b, 0x006f, 0x0004, 0x32c5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007c, 0x0070, 0x32b8, 0x54e7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x3324, 0x54da, 0x7f8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3331, 0x5546, 0x7f82, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5553, 0x7fee, 0x7f83, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffb, 0x7fef, 0x7f84, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7ff0, 0x7f85, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ff1, 0x7f86, 0xaa3c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7ff2, 0xaa2f, 0xcc5e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0xaa9b, 0xcc51, 0xff12, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa8, 0xccbd, 0xff05, 0xff13, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccca, 0xff71, 0xff06, 0xff14, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7e, 0xff72, 0xff07, 0xff15, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff71, 0xff06, 0xff07, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff72, 0xff07, 0xff74, 0xff8e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff73, 0xff74, 0xff81, 0xff8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffe0, 0xff81, 0xff82, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffed, 0xff82, 0xff83, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffee, 0xff83, 0x0080, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffef, 0x007e, 0x007f, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x007d, 0x007e, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000f, 0x007c, 0x0070, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000e, 0x006e, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006d, 0x0002, 0x0003, 0x32c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006e, 0x0003, 0x32b7, 0x54e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006f, 0x32b7, 0x54d9, 0x7f8e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3323, 0x54d9, 0x7f81, 0x7f8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5545, 0x7f81, 0x7f82, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fed, 0x7f82, 0x7f83, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fee, 0x7f83, 0x7f84, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fef, 0x7f84, 0x7f85, 0xaa3b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff0, 0x7f85, 0xaa2e, 0xcc5d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff1, 0xaa2e, 0xcc50, 0xff11, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa9a, 0xcc50, 0xff04, 0xff12, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccbc, 0xff04, 0xff05, 0xff13, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff70, 0xff05, 0xff06, 0xff14, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff04, 0xff05, 0xff06, 0xcccd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff05, 0xff06, 0xff73, 0xccda, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff06, 0xff73, 0xff80, 0xccdb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff73, 0xff80, 0xff81, 0xccdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff81, 0xff82, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xff82, 0x0081, 0x3342, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0x007f, 0x0080, 0x3341, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x007f, 0x3333, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007c, 0x007d, 0x0071, 0x32c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007b, 0x006f, 0x0004, 0x32c5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006d, 0x0002, 0x0003, 0x32c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x32b6, 0x2232, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x32b6, 0x54d8, 0x4cda, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b6, 0x54d8, 0x7f80, 0x4cdb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d8, 0x7f80, 0x7f81, 0x4cdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x7f82, 0x4cdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f82, 0x7f83, 0x4cde, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f83, 0x7f84, 0x7787, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f84, 0xaa2d, 0x99a9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f84, 0xaa2d, 0xcc4f, 0xcc5d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2d, 0xcc4f, 0xff03, 0xcc5e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4f, 0xff03, 0xff04, 0xcc5f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff03, 0xff04, 0xff05, 0xcc60, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff03, 0xff04, 0xcc52, 0xaaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff04, 0xff05, 0xccbf, 0xaab8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff05, 0xff72, 0xcccc, 0xaab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff72, 0xff7f, 0xcccd, 0xaaba, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7f, 0xff80, 0xccce, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff81, 0x3335, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0x0080, 0x3334, 0x5563, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0x3333, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x3325, 0x54e8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007c, 0x0070, 0x32b8, 0x54e7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006e, 0x0003, 0x32b7, 0x54e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x32b6, 0x2232, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x32b5, 0x2224, 0x2ab8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x54d7, 0x4ccc, 0x2ab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x7f7f, 0x4ccd, 0x2aba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x7f80, 0x4cce, 0x2abb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x4ccf, 0x2abc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f82, 0x4cd0, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f83, 0x7779, 0x7787, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0xaa2c, 0x999b, 0xaa3b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2c, 0xcc4e, 0xcc4f, 0xaa3c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4e, 0xff02, 0xcc50, 0xaa3d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff02, 0xff03, 0xcc51, 0xaa3e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff02, 0xcc50, 0xaa30, 0x8003, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff03, 0xcc51, 0xaa9d, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff04, 0xccbe, 0xaaaa, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff71, 0xcccb, 0xaaab, 0x8012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7e, 0xcccc, 0xaaac, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7f, 0xcccd, 0x5557, 0x800c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0x3334, 0x5556, 0x800b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x3332, 0x5547, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x3324, 0x54da, 0x7f8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006f, 0x32b7, 0x54d9, 0x7f8e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x32b6, 0x54d8, 0x4cda, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x32b5, 0x2224, 0x2ab8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x2223, 0x2aaa, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x4ccb, 0x2aab, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7e, 0x4ccc, 0x2aac, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x4ccd, 0x2aad, 0x0014, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x4cce, 0x2aae, 0x2abd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x4ccf, 0x5557, 0x4cdf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7778, 0x7779, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2b, 0x999a, 0xaa2d, 0x7f94, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4d, 0xcc4e, 0xaa2e, 0x7f95, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xcc4f, 0xaa2f, 0x7f96, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4e, 0xaa2e, 0x7f88, 0x8002, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4f, 0xaa2f, 0x7ff5, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc50, 0xaa9c, 0x8002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccbd, 0xaaa9, 0x8003, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccca, 0xaaaa, 0x8004, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccb, 0xaaab, 0x7fff, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0x5556, 0x7ffe, 0x800c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3332, 0x5554, 0x7fef, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3331, 0x5546, 0x7f82, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3323, 0x54d9, 0x7f81, 0x7f8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b6, 0x54d8, 0x7f80, 0x4cdb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x54d7, 0x4ccc, 0x2ab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x2223, 0x2aaa, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x2aa9, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cca, 0x2aaa, 0x0004, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x2aab, 0x0005, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0x2aac, 0x0006, 0x2abc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccd, 0x2aad, 0x2aaf, 0x4cde, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cce, 0x5556, 0x4cd1, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7777, 0x7778, 0x7f85, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9999, 0xaa2c, 0x7f86, 0x7f94, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4d, 0xaa2d, 0x7f87, 0x7f95, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2c, 0x7f86, 0x7f87, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2d, 0x7f87, 0x7ff4, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2e, 0x7ff4, 0x8001, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa9b, 0x8001, 0x8002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa8, 0x8002, 0x8003, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa9, 0x8003, 0x8000, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0x7ffe, 0x7fff, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x7ffc, 0x7ff0, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5553, 0x7fee, 0x7f83, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5545, 0x7f81, 0x7f82, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d8, 0x7f80, 0x7f81, 0x4cdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x7f7f, 0x4ccd, 0x2aba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x4ccb, 0x2aab, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x2aa9, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa8, 0x0002, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x0003, 0x0004, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x0004, 0x0005, 0x2abb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x0005, 0x2aae, 0x4cdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aac, 0x2aae, 0x4cd0, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x4cd0, 0x7f84, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7777, 0x7f84, 0x7f85, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2b, 0x7f85, 0x7f86, 0x7f94, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f84, 0x7f85, 0x7f86, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f85, 0x7f86, 0x7ff3, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f86, 0x7ff3, 0x8000, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff3, 0x8000, 0x8001, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0x8002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8002, 0x8001, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x7fff, 0x8000, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7ffd, 0x7ff1, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffb, 0x7fef, 0x7f84, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fed, 0x7f82, 0x7f83, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x7f82, 0x4cdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x7f80, 0x4cce, 0x2abb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7e, 0x4ccc, 0x2aac, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cca, 0x2aaa, 0x0004, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa8, 0x0002, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0003, 0x0004, 0x2aba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0004, 0x2aad, 0x4cdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0004, 0x2aad, 0x4ccf, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aad, 0x4ccf, 0x7f83, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccf, 0x7f83, 0x7f84, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f84, 0x7f85, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f84, 0x7f85, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f84, 0x7f85, 0x7ff2, 0x800c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f85, 0x7ff2, 0x7fff, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff2, 0x7fff, 0x8000, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x8001, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0x8002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8000, 0x8001, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8000, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x7ff2, 0x7f94, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7ff0, 0x7f85, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fee, 0x7f83, 0x7f84, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f82, 0x7f83, 0x4cde, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x4ccf, 0x2abc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x4ccd, 0x2aad, 0x0014, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x2aab, 0x0005, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x0003, 0x0004, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0003, 0x2ab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0003, 0x2aac, 0x4cdb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x2aac, 0x4cce, 0x7f8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aac, 0x4cce, 0x7f82, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cce, 0x7f82, 0x7f83, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f83, 0x7f84, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f83, 0x7f84, 0x5556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f84, 0x7ff1, 0x5563, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f84, 0x7ff1, 0x7ffe, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff1, 0x7ffe, 0x7fff, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8000, 0xaaba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x8003, 0xaab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0x8002, 0xaab8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x8001, 0xaaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x7ff3, 0xaa3d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ff1, 0x7f86, 0xaa3c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fef, 0x7f84, 0x7f85, 0xaa3b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f83, 0x7f84, 0x7787, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f82, 0x4cd0, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x4cce, 0x2aae, 0x2abd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0x2aac, 0x0006, 0x2abc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x0004, 0x0005, 0x2abb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0003, 0x0004, 0x2aba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0003, 0x2ab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x2aab, 0x2232, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x2aab, 0x4ccd, 0x54e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x4ccd, 0x7f81, 0x54e7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccd, 0x7f81, 0x7f82, 0x54e8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f82, 0x7f83, 0x54e9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f82, 0x54db, 0x3334, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f83, 0x5548, 0x3341, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7ff0, 0x5555, 0x3342, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff0, 0x7ffd, 0x5556, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x5557, 0xccdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0xaaac, 0xccdb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8002, 0xaaab, 0xccda, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0xaaaa, 0xcccc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0xaa9c, 0xcc5f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7ff2, 0xaa2f, 0xcc5e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff0, 0x7f85, 0xaa2e, 0xcc5d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f84, 0xaa2d, 0x99a9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f83, 0x7779, 0x7787, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x4ccf, 0x5557, 0x4cdf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccd, 0x2aad, 0x2aaf, 0x4cde, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x0005, 0x2aae, 0x4cdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0004, 0x2aad, 0x4cdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0003, 0x2aac, 0x4cdb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x2aab, 0x2232, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x2aaa, 0x2224, 0x32c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x4ccc, 0x54d8, 0x32c5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0x7f80, 0x54d9, 0x32c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x54da, 0x32c7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x54d9, 0x32b9, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x54da, 0x3326, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x5547, 0x3333, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fef, 0x5554, 0x3334, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x5555, 0x3335, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x5556, 0xccce, 0xff8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0xaaab, 0xcccd, 0xff8e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0xaaaa, 0xcccc, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xaaa9, 0xccbe, 0xff13, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0xaa9b, 0xcc51, 0xff12, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff1, 0xaa2e, 0xcc50, 0xff11, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f84, 0xaa2d, 0xcc4f, 0xcc5d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0xaa2c, 0x999b, 0xaa3b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7778, 0x7779, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cce, 0x5556, 0x4cd1, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aac, 0x2aae, 0x4cd0, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0004, 0x2aad, 0x4ccf, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x2aac, 0x4cce, 0x7f8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x2aab, 0x4ccd, 0x54e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x2aaa, 0x2224, 0x32c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x2223, 0x32b6, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x54d7, 0x32b7, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x54d8, 0x32b8, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x32b7, 0x0005, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d8, 0x32b8, 0x0072, 0x008c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d9, 0x3325, 0x007f, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5546, 0x3332, 0x0080, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5553, 0x3333, 0x0081, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x3334, 0xff82, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0xcccd, 0xff81, 0xff8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0xcccc, 0xff80, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa9, 0xcccb, 0xff72, 0xff14, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa8, 0xccbd, 0xff05, 0xff13, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa9a, 0xcc50, 0xff04, 0xff12, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2d, 0xcc4f, 0xff03, 0xcc5e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2c, 0xcc4e, 0xcc4f, 0xaa3c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2b, 0x999a, 0xaa2d, 0x7f94, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7777, 0x7778, 0x7f85, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x4cd0, 0x7f84, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aad, 0x4ccf, 0x7f83, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aac, 0x4cce, 0x7f82, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x4ccd, 0x7f81, 0x54e7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x4ccc, 0x54d8, 0x32c5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x2223, 0x32b6, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x32b5, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x32b6, 0x0004, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x0003, 0x0004, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b6, 0x0004, 0x0071, 0x008b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b7, 0x0071, 0x007e, 0x008c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3324, 0x007e, 0x007f, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3331, 0x007f, 0x0080, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3332, 0x0080, 0xff83, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0xff81, 0xff82, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0xff80, 0xff81, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccb, 0xff7f, 0xff73, 0xff15, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccca, 0xff71, 0xff06, 0xff14, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccbc, 0xff04, 0xff05, 0xff13, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4f, 0xff03, 0xff04, 0xcc5f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4e, 0xff02, 0xcc50, 0xaa3d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4d, 0xcc4e, 0xaa2e, 0x7f95, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9999, 0xaa2c, 0x7f86, 0x7f94, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7777, 0x7f84, 0x7f85, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccf, 0x7f83, 0x7f84, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cce, 0x7f82, 0x7f83, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccd, 0x7f81, 0x7f82, 0x54e8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0x7f80, 0x54d9, 0x32c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x54d7, 0x32b7, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x32b5, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x0002, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0003, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0003, 0x0070, 0x008a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0070, 0x007d, 0x008b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0070, 0x007d, 0x007e, 0x008c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x007f, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0xff84, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0xff82, 0xff83, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff81, 0xff82, 0xff83, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7f, 0xff80, 0xff74, 0xff16, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7e, 0xff72, 0xff07, 0xff15, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff70, 0xff05, 0xff06, 0xff14, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff03, 0xff04, 0xff05, 0xcc60, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff02, 0xff03, 0xcc51, 0xaa3e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xcc4f, 0xaa2f, 0x7f96, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4d, 0xaa2d, 0x7f87, 0x7f95, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2b, 0x7f85, 0x7f86, 0x7f94, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f84, 0x7f85, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f83, 0x7f84, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f82, 0x7f83, 0x54e9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x54da, 0x32c7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x54d8, 0x32b8, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x32b6, 0x0004, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x0002, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_uaba_4H = 576;

#endif  // VIXL_SIM_UABA_4H_TRACE_AARCH64_H_
