/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLSocket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.zaproxy.zap.network.HttpRequestBody;
import org.zaproxy.zap.network.HttpResponseBody;

public class HttpInputStream
extends BufferedInputStream {
    private static final Logger LOGGER = LogManager.getLogger(HttpInputStream.class);
    static final int BUFFER_SIZE = 4096;
    private static final String CRLF = "\r\n";
    private static final String CRLF2 = "\r\n\r\n";
    private static final String LF = "\n";
    private static final String LF2 = "\n\n";
    private byte[] mBuffer = new byte[4096];
    private Socket mSocket = null;

    public HttpInputStream(Socket socket) throws IOException {
        super(socket.getInputStream(), 4096);
        this.setSocket(socket);
    }

    public HttpRequestHeader readRequestHeader(boolean isSecure) throws HttpMalformedHeaderException, IOException {
        String msg = "";
        HttpRequestHeader httpRequestHeader = null;
        msg = this.readHeader();
        if (msg.length() == 0) {
            LOGGER.debug("Read 0 bytes from upstream. Could not read header!");
            throw new IOException();
        }
        httpRequestHeader = new HttpRequestHeader(msg, isSecure);
        return httpRequestHeader;
    }

    public synchronized String readHeader() throws IOException {
        String msg = "";
        int oneByte = -1;
        boolean eoh = false;
        StringBuilder sb = new StringBuilder(200);
        do {
            if ((oneByte = super.read()) == -1) {
                eoh = true;
                break;
            }
            sb.append((char)oneByte);
            if ((char)oneByte != '\n' || !HttpInputStream.isHeaderEnd(sb)) continue;
            eoh = true;
            msg = sb.toString();
        } while (!eoh);
        return msg;
    }

    private static final boolean isHeaderEnd(StringBuilder sb) {
        int len = sb.length();
        if (len > 2 && LF2.equals(sb.substring(len - 2))) {
            return true;
        }
        return len > 4 && CRLF2.equals(sb.substring(len - 4));
    }

    public synchronized HttpRequestBody readRequestBody(HttpHeader httpHeader) {
        int contentLength = httpHeader.getContentLength();
        HttpRequestBody body = contentLength > 0 ? new HttpRequestBody(contentLength) : new HttpRequestBody();
        this.readBody(contentLength, body);
        HttpMessage.setContentEncodings(httpHeader, body);
        return body;
    }

    public synchronized HttpResponseBody readResponseBody(HttpHeader httpHeader) {
        int contentLength = httpHeader.getContentLength();
        HttpResponseBody body = contentLength > 0 ? new HttpResponseBody(contentLength) : new HttpResponseBody();
        this.readBody(contentLength, body);
        return body;
    }

    private void readBody(int contentLength, HttpBody body) {
        int readBodyLength = 0;
        int len = 0;
        try {
            while (contentLength == -1 || readBodyLength < contentLength) {
                len = this.readBody(contentLength, readBodyLength, this.mBuffer);
                if (len > 0) {
                    readBodyLength += len;
                } else if (len < 0) break;
                body.append(this.mBuffer, len);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int readBody(int contentLength, int readBodyLength, byte[] buffer) throws IOException {
        int len = 0;
        int remainingLen = 0;
        if (contentLength == -1) {
            len = super.read(buffer);
        } else {
            remainingLen = contentLength - readBodyLength;
            if (remainingLen <= buffer.length && remainingLen > 0) {
                len = super.read(buffer, 0, remainingLen);
            } else if (remainingLen > buffer.length) {
                len = super.read(buffer);
            }
        }
        return len;
    }

    public void setSocket(Socket socket) {
        this.mSocket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int available() throws IOException {
        int avail = 0;
        int timeout = 0;
        avail = super.available();
        if (avail == 0 && this.mSocket != null && this.mSocket instanceof SSLSocket) {
            try {
                timeout = this.mSocket.getSoTimeout();
                this.mSocket.setSoTimeout(1);
                super.mark(256);
                super.read();
                super.reset();
                avail = super.available();
            }
            catch (SocketTimeoutException e) {
                avail = 0;
            }
            finally {
                this.mSocket.setSoTimeout(timeout);
            }
        }
        return avail;
    }

    @Override
    public int read() throws IOException {
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return super.read(b, off, len);
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

