/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.zaproxy.zap.control.AddOnClassnames;
import org.zaproxy.zap.control.AddOnLoader;

public class AddOnClassLoader
extends URLClassLoader {
    private final ParentClassLoader parent;
    private final List<AddOnClassLoader> childClassLoaders;
    private List<AddOnClassLoader> dependencies;
    private AddOnClassnames addOnClassnames;
    private ClassLoadingLockProvider classLoadingLockProvider;

    public AddOnClassLoader(URL addOnFileUrl, ClassLoader parent) {
        this(addOnFileUrl, parent, Collections.emptyList(), AddOnClassnames.ALL_ALLOWED);
    }

    public AddOnClassLoader(URL addOnFileUrl, ClassLoader parent, AddOnClassnames addOnClassnames) {
        this(addOnFileUrl, parent, Collections.emptyList(), addOnClassnames);
    }

    public AddOnClassLoader(URL addOnFileUrl, AddOnLoader parent, AddOnClassnames addOnClassnames) {
        this(addOnFileUrl, (ClassLoader)parent, Collections.emptyList(), addOnClassnames);
        this.classLoadingLockProvider = parent::getClassLoadingLock;
    }

    public AddOnClassLoader(URL addOnFileUrl, ClassLoader parent, List<AddOnClassLoader> dependencies) {
        this(addOnFileUrl, parent, dependencies, AddOnClassnames.ALL_ALLOWED);
    }

    public AddOnClassLoader(URL addOnFileUrl, ClassLoader parent, List<AddOnClassLoader> dependencies, AddOnClassnames addOnClassnames) {
        super(new URL[]{addOnFileUrl}, (ClassLoader)null);
        if (addOnFileUrl == null) {
            throw new IllegalArgumentException("Parameter addOnFileUrl must not be null.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Parameter parent must not be null.");
        }
        if (dependencies == null) {
            throw new IllegalArgumentException("Parameter dependencies must not be null.");
        }
        this.parent = new ParentClassLoader(parent);
        this.dependencies = dependencies.isEmpty() ? Collections.emptyList() : new ArrayList<AddOnClassLoader>(dependencies);
        this.childClassLoaders = new ArrayList<AddOnClassLoader>(2);
        this.addOnClassnames = addOnClassnames;
    }

    public AddOnClassLoader(URL addOnFileUrl, AddOnLoader parent, List<AddOnClassLoader> dependencies, AddOnClassnames addOnClassnames) {
        this(addOnFileUrl, (ClassLoader)parent, dependencies, addOnClassnames);
        this.classLoadingLockProvider = parent::getClassLoadingLock;
    }

    public AddOnClassLoader(AddOnClassLoader parent, List<AddOnClassLoader> dependencies) {
        super(parent.getURLs(), (ClassLoader)null);
        if (dependencies == null) {
            throw new IllegalArgumentException("Parameter dependencies must not be null.");
        }
        parent.childClassLoaders.add(this);
        this.parent = new ParentClassLoader((ClassLoader)parent);
        this.dependencies = dependencies.isEmpty() ? Collections.emptyList() : new ArrayList<AddOnClassLoader>(dependencies);
        this.childClassLoaders = Collections.emptyList();
        this.addOnClassnames = AddOnClassnames.ALL_ALLOWED;
        this.classLoadingLockProvider = parent::getClassLoadingLock;
    }

    public AddOnClassLoader(AddOnClassLoader parent, List<AddOnClassLoader> dependencies, AddOnClassnames addOnClassnames) {
        super(parent.getURLs(), (ClassLoader)null);
        if (dependencies == null) {
            throw new IllegalArgumentException("Parameter dependencies must not be null.");
        }
        if (addOnClassnames == null) {
            throw new IllegalArgumentException("Parameter addOnClassnames must not be null.");
        }
        parent.childClassLoaders.add(this);
        this.parent = new ParentClassLoader((ClassLoader)parent);
        this.dependencies = dependencies.isEmpty() ? Collections.emptyList() : new ArrayList<AddOnClassLoader>(dependencies);
        this.childClassLoaders = Collections.emptyList();
        this.addOnClassnames = addOnClassnames;
        this.classLoadingLockProvider = parent::getClassLoadingLock;
    }

    void addUrls(List<URL> urls) {
        Objects.requireNonNull(urls);
        urls.forEach(this::addURL);
    }

    public void removeChildClassLoader(AddOnClassLoader child) {
        this.childClassLoaders.remove(child);
    }

    List<AddOnClassLoader> getChildClassLoaders() {
        return Collections.unmodifiableList(this.childClassLoaders);
    }

    @Override
    public void close() throws IOException {
        for (AddOnClassLoader childClassLoader : this.childClassLoaders) {
            childClassLoader.close();
        }
        super.close();
    }

    @Override
    protected Object getClassLoadingLock(String className) {
        if (this.classLoadingLockProvider != null) {
            return this.classLoadingLockProvider.getLock(className);
        }
        return super.getClassLoadingLock(className);
    }

    public void clearDependencies() {
        this.dependencies = Collections.emptyList();
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.addOnClassnames.isAllowed(name)) {
            try {
                return this.findClassInAddOn(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            return this.parent.loadClass(name, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> clazz = this.findClassInDependencies(name);
            if (clazz == null) {
                throw new ClassNotFoundException();
            }
            return clazz;
        }
    }

    private Class<?> findClassInAddOn(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    private Class<?> findClassInDependencies(String name) {
        if (this.dependencies.isEmpty()) {
            return null;
        }
        for (AddOnClassLoader addOnClassLoader : this.dependencies) {
            try {
                return addOnClassLoader.loadClass(name, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    @Override
    public URL findResource(String name) {
        URL url = this.findResourceInAddOn(name);
        if (url == null) {
            url = this.parent.getResource(name);
        }
        if (url == null) {
            url = this.findResourceInDependencies(name);
        }
        return url;
    }

    public URL findResourceInAddOn(String name) {
        return super.findResource(name);
    }

    private URL findResourceInDependencies(String name) {
        if (this.dependencies.isEmpty()) {
            return null;
        }
        for (AddOnClassLoader addOnClassLoader : this.dependencies) {
            URL url = addOnClassLoader.findResourceInAddOn(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    @FunctionalInterface
    private static interface ClassLoadingLockProvider {
        public Object getLock(String var1);
    }

    private class ParentClassLoader
    extends ClassLoader {
        private final boolean noAddOnsLoading;

        public ParentClassLoader(ClassLoader classLoader) {
            super(classLoader);
            this.noAddOnsLoading = classLoader instanceof AddOnLoader;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.noAddOnsLoading) {
                return ((AddOnLoader)this.getParent()).loadClassNoAddOns(name, resolve);
            }
            return super.loadClass(name, resolve);
        }

        @Override
        protected Object getClassLoadingLock(String className) {
            if (AddOnClassLoader.this.classLoadingLockProvider != null) {
                return AddOnClassLoader.this.classLoadingLockProvider.getLock(className);
            }
            return super.getClassLoadingLock(className);
        }
    }
}

