/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.extension.alert.ExampleAlertProvider;
import org.zaproxy.zap.extension.pscan.PassiveScanData;
import org.zaproxy.zap.extension.pscan.PassiveScanTaskHelper;
import org.zaproxy.zap.extension.pscan.PassiveScanThread;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.utils.Enableable;
import org.zaproxy.zap.utils.Stats;

public abstract class PluginPassiveScanner
extends Enableable
implements PassiveScanner,
ExampleAlertProvider {
    private static final String PSCANS_KEY = "pscans.pscanner";
    private static final String ID_KEY = "id";
    private static final String CLASSNAME_KEY = "classname";
    private static final String LEVEL_KEY = "level";
    private static final String ALERT_THRESHOLD_KEY = "alertthreshold";
    private static final String ENABLED_KEY = "enabled";
    private static final Integer[] DEFAULT_HISTORY_TYPES = new Integer[]{1, 15, 2, 10};
    private static final Set<Integer> DEFAULT_HISTORY_TYPES_SET = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(DEFAULT_HISTORY_TYPES)));
    private Plugin.AlertThreshold alertThreshold = Plugin.AlertThreshold.DEFAULT;
    private Plugin.AlertThreshold defaultAlertThreshold = Plugin.AlertThreshold.MEDIUM;
    private Configuration config = null;
    private AddOn.Status status = AddOn.Status.unknown;
    private PassiveScanData passiveScanData;
    private PassiveScanTaskHelper taskHelper;

    public PluginPassiveScanner() {
        super(true);
    }

    public void setHelper(PassiveScanData passiveScanData) {
        this.passiveScanData = passiveScanData;
    }

    @Override
    public void setParent(PassiveScanThread parent) {
    }

    public void setConfig(Configuration config) {
        if (config == null) {
            throw new IllegalArgumentException("Parameter config must not be null.");
        }
        this.config = config;
        this.loadFrom(config);
    }

    public void loadFrom(Configuration conf) {
        List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(PSCANS_KEY);
        for (HierarchicalConfiguration sub : fields) {
            if (!this.isPluginConfiguration((Configuration)sub)) continue;
            String alertThresholdName = sub.getString(LEVEL_KEY, null);
            if (alertThresholdName == null) {
                alertThresholdName = sub.getString(ALERT_THRESHOLD_KEY, Plugin.AlertThreshold.DEFAULT.name());
            }
            this.setAlertThreshold(Plugin.AlertThreshold.valueOf(alertThresholdName));
            this.setEnabled(sub.getBoolean(ENABLED_KEY, true));
            break;
        }
    }

    private boolean isPluginConfiguration(Configuration configuration) {
        return configuration.containsKey(ID_KEY) && this.getPluginId() == configuration.getInt(ID_KEY) || this.getClass().getCanonicalName().equals(configuration.getString(CLASSNAME_KEY, ""));
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void save() {
        Configuration conf = this.getConfig();
        if (conf == null) {
            throw new IllegalStateException("No configuration has been set.");
        }
        this.saveTo(conf);
    }

    public void saveTo(Configuration conf) {
        boolean removed = false;
        List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(PSCANS_KEY);
        for (HierarchicalConfiguration sub : fields) {
            if (!this.isPluginConfiguration((Configuration)sub)) continue;
            sub.getRootNode().getParentNode().removeChild(sub.getRootNode());
            removed = true;
            break;
        }
        boolean persistId = false;
        String entryKey = "pscans.pscanner(" + (removed ? fields.size() - 1 : fields.size()) + ").";
        if (this.getAlertThreshold() != Plugin.AlertThreshold.MEDIUM) {
            conf.setProperty(entryKey + ALERT_THRESHOLD_KEY, (Object)this.getAlertThreshold().name());
            conf.setProperty(entryKey + LEVEL_KEY, (Object)this.getAlertThreshold().name());
            persistId = true;
        }
        if (!this.isEnabled()) {
            conf.setProperty(entryKey + ENABLED_KEY, (Object)Boolean.FALSE);
            persistId = true;
        }
        if (persistId) {
            conf.setProperty(entryKey + ID_KEY, (Object)this.getPluginId());
        }
    }

    @Override
    @Deprecated
    public Plugin.AlertThreshold getLevel() {
        return this.getAlertThreshold();
    }

    @Deprecated
    public Plugin.AlertThreshold getLevel(boolean incDefault) {
        return this.getAlertThreshold(incDefault);
    }

    public Plugin.AlertThreshold getAlertThreshold() {
        if (Plugin.AlertThreshold.DEFAULT.equals((Object)this.alertThreshold)) {
            return this.defaultAlertThreshold;
        }
        return this.alertThreshold;
    }

    public Plugin.AlertThreshold getAlertThreshold(boolean incDefault) {
        if (!incDefault && this.alertThreshold == Plugin.AlertThreshold.DEFAULT) {
            return this.defaultAlertThreshold;
        }
        return this.alertThreshold;
    }

    @Override
    @Deprecated
    public void setLevel(Plugin.AlertThreshold level) {
        this.setAlertThreshold(level);
    }

    public void setAlertThreshold(Plugin.AlertThreshold alertThreshold) {
        if (alertThreshold == null) {
            throw new IllegalArgumentException("Parameter alertThreshold must not be null.");
        }
        this.alertThreshold = alertThreshold;
    }

    @Deprecated
    public void setDefaultLevel(Plugin.AlertThreshold level) {
        this.setDefaultAlertThreshold(level);
    }

    public void setDefaultAlertThreshold(Plugin.AlertThreshold alertThreshold) {
        if (alertThreshold == null || alertThreshold == Plugin.AlertThreshold.DEFAULT) {
            throw new IllegalArgumentException("Parameter alertThreshold must not be null or DEFAULT.");
        }
        this.defaultAlertThreshold = alertThreshold;
    }

    public int getPluginId() {
        return -1;
    }

    public AddOn.Status getStatus() {
        return this.status;
    }

    public void setStatus(AddOn.Status status) {
        if (status == null) {
            throw new IllegalArgumentException("Parameter status must not be null.");
        }
        this.status = status;
    }

    public static Set<Integer> getDefaultHistoryTypes() {
        return DEFAULT_HISTORY_TYPES_SET;
    }

    @Override
    public boolean appliesToHistoryType(int historyType) {
        return PluginPassiveScanner.getDefaultHistoryTypes().contains(historyType);
    }

    @Override
    public List<Alert> getExampleAlerts() {
        return null;
    }

    public PassiveScanData getHelper() {
        return this.passiveScanData;
    }

    @Override
    public void setTaskHelper(PassiveScanTaskHelper helper) {
        this.taskHelper = helper;
    }

    @Override
    public PassiveScanTaskHelper getTaskHelper() {
        return this.taskHelper;
    }

    @Deprecated
    protected void addTag(String tag) {
        this.addHistoryTag(tag);
    }

    protected void addHistoryTag(String tag) {
        this.taskHelper.addHistoryTag(this.passiveScanData.getMessage().getHistoryRef(), tag);
    }

    public Map<String, String> getAlertTags() {
        return null;
    }

    public final String getDisplayName() {
        return StringUtils.isBlank((CharSequence)this.getName()) ? this.getClass().getSimpleName() : this.getName();
    }

    public PluginPassiveScanner copy() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        PluginPassiveScanner pps = (PluginPassiveScanner)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        Configuration conf = this.getConfig();
        if (conf == null) {
            throw new IllegalArgumentException("Cannot copy " + this.getClass().getCanonicalName() + " : " + this.getName() + " as the configuration is null");
        }
        pps.setConfig(conf);
        return pps;
    }

    protected AlertBuilder newAlert() {
        return new AlertBuilder(this, this.passiveScanData.getMessage());
    }

    public static final class AlertBuilder
    extends Alert.Builder {
        private final PluginPassiveScanner plugin;
        private final HttpMessage message;

        private AlertBuilder(PluginPassiveScanner plugin, HttpMessage message) {
            this.plugin = plugin;
            this.message = message;
            this.setPluginId(plugin.getPluginId());
            this.setName(plugin.getName());
            this.setMessage(message);
            this.setTags((Map)plugin.getAlertTags());
        }

        @Override
        public AlertBuilder setAlertId(int alertId) {
            super.setAlertId(alertId);
            return this;
        }

        @Override
        public AlertBuilder setPluginId(int pluginId) {
            super.setPluginId(pluginId);
            return this;
        }

        @Override
        public AlertBuilder setName(String name) {
            super.setName(name);
            return this;
        }

        @Override
        public AlertBuilder setRisk(int risk) {
            super.setRisk(risk);
            return this;
        }

        @Override
        public AlertBuilder setConfidence(int confidence) {
            super.setConfidence(confidence);
            return this;
        }

        @Override
        public AlertBuilder setDescription(String description) {
            super.setDescription(description);
            return this;
        }

        @Override
        public AlertBuilder setUri(String uri) {
            super.setUri(uri);
            return this;
        }

        @Override
        public AlertBuilder setParam(String param) {
            super.setParam(param);
            return this;
        }

        @Override
        public AlertBuilder setAttack(String attack) {
            throw new IllegalStateException("Passive alerts should not have an attack.");
        }

        @Override
        public AlertBuilder setOtherInfo(String otherInfo) {
            super.setOtherInfo(otherInfo);
            return this;
        }

        @Override
        public AlertBuilder setSolution(String solution) {
            super.setSolution(solution);
            return this;
        }

        @Override
        public AlertBuilder setReference(String reference) {
            super.setReference(reference);
            return this;
        }

        @Override
        public AlertBuilder setEvidence(String evidence) {
            super.setEvidence(evidence);
            return this;
        }

        @Override
        public AlertBuilder setInputVector(String inputVector) {
            super.setInputVector(inputVector);
            return this;
        }

        @Override
        public AlertBuilder setCweId(int cweId) {
            super.setCweId(cweId);
            return this;
        }

        @Override
        public AlertBuilder setWascId(int wascId) {
            super.setWascId(wascId);
            return this;
        }

        @Override
        public AlertBuilder setMessage(HttpMessage message) {
            super.setMessage(message);
            return this;
        }

        @Override
        public AlertBuilder setSourceHistoryId(int sourceHistoryId) {
            super.setSourceHistoryId(sourceHistoryId);
            return this;
        }

        @Override
        public AlertBuilder setHistoryRef(HistoryReference historyRef) {
            super.setHistoryRef(historyRef);
            return this;
        }

        @Override
        public AlertBuilder setSource(Alert.Source source) {
            super.setSource(source);
            return this;
        }

        @Override
        public AlertBuilder setAlertRef(String alertRef) {
            super.setAlertRef(alertRef);
            return this;
        }

        @Override
        public AlertBuilder setTags(Map<String, String> tags) {
            super.setTags(tags);
            return this;
        }

        @Override
        public AlertBuilder addTag(String tag) {
            super.addTag(tag, "");
            return this;
        }

        @Override
        public AlertBuilder addTag(String tag, String value) {
            super.addTag(tag, value);
            return this;
        }

        @Override
        public AlertBuilder removeTag(String tag) {
            super.removeTag(tag);
            return this;
        }

        @Override
        public AlertBuilder removeTag(String tag, String value) {
            super.removeTag(tag, value);
            return this;
        }

        public void raise() {
            this.plugin.taskHelper.raiseAlert(this.message.getHistoryRef(), this.build());
            Stats.incCounter("stats.pscan." + this.plugin.getPluginId() + ".alerts");
        }
    }
}

