/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.intl.chardet;

import java.io.BufferedInputStream;
import java.net.URL;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public class HtmlCharsetDetector {
    public static boolean found = false;

    public static void main(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length != 1 && stringArray.length != 2) {
            System.out.println("Usage: HtmlCharsetDetector <url> [<languageHint>]");
            System.out.println("");
            System.out.println("Where <url> is http://...");
            System.out.println("For optional <languageHint>. Use following...");
            System.out.println("\t\t1 => Japanese");
            System.out.println("\t\t2 => Chinese");
            System.out.println("\t\t3 => Simplified Chinese");
            System.out.println("\t\t4 => Traditional Chinese");
            System.out.println("\t\t5 => Korean");
            System.out.println("\t\t6 => Dont know (default)");
            return;
        }
        int n2 = stringArray.length == 2 ? Integer.parseInt(stringArray[1]) : 0;
        nsDetector nsDetector2 = new nsDetector(n2);
        nsDetector2.Init(new nsICharsetDetectionObserver(){

            @Override
            public void Notify(String string) {
                found = true;
                System.out.println("CHARSET = " + string);
            }
        });
        URL uRL = new URL(stringArray[0]);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        byte[] byArray = new byte[1024];
        boolean bl = false;
        boolean bl2 = true;
        while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
            if (bl2) {
                bl2 = nsDetector2.isAscii(byArray, n);
            }
            if (bl2 || bl) continue;
            bl = nsDetector2.DoIt(byArray, n, false);
        }
        nsDetector2.DataEnd();
        if (bl2) {
            System.out.println("CHARSET = ASCII");
            found = true;
        }
        if (!found) {
            String[] stringArray2 = nsDetector2.getProbableCharsets();
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.println("Probable Charset = " + stringArray2[i]);
            }
        }
    }
}

