/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.aplicacao;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import jsignnet.aplicacao.ControleProgresso;
import jsignnet.aplicacao.ControleProgressoPadrao;
import jsignnet.aplicacao.JSignNet;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedDataGenerator;

public abstract class Hash {
    public static final Hash MD5 = new Hash(CMSSignedDataGenerator.DIGEST_MD5, "MD5"){};
    public static final Hash SHA1 = new Hash(CMSSignedDataGenerator.DIGEST_SHA1, "SHA-1"){};
    public static final Hash SHA256 = new Hash(CMSSignedDataGenerator.DIGEST_SHA256, "SHA-256"){};
    public static final Hash SHA384 = new Hash(CMSSignedDataGenerator.DIGEST_SHA384, "SHA-384"){};
    public static final Hash SHA512 = new Hash(CMSSignedDataGenerator.DIGEST_SHA512, "SHA-512"){};
    public static final Hash SHA256withRSA = new Hash(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId(), "RSA-SHA256"){};
    public static final Hash SHA384withRSA = new Hash(PKCSObjectIdentifiers.sha384WithRSAEncryption.getId(), "RSA-SHA384"){};
    public static final Hash SHA512withRSA = new Hash(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId(), "RSA-SHA512"){};
    public static final Hash MESMO_DO_CERTIFICADO = new Hash(null, null){};
    public static final Hash[] ALGORITMOS = new Hash[]{MD5, SHA1, SHA256, SHA384, SHA512};
    private String _digestOID;
    private String _nomeAlgoritmo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] geraDigest(InputStream dados, ControleProgresso progresso) throws IOException, NoSuchAlgorithmException {
        if (dados == null) {
            throw new IllegalArgumentException("Os dados para c\u00e1lculo do hash precisam ser informados.");
        }
        if (progresso == null) {
            progresso = new ControleProgressoPadrao();
        }
        try {
            int len;
            MessageDigest digest = MessageDigest.getInstance(this._nomeAlgoritmo);
            long readBytes = 0L;
            byte[] buffer = new byte[32768];
            while ((len = dados.read(buffer)) > 0) {
                if (progresso.foiCancelado()) {
                    byte[] byArray = null;
                    return byArray;
                }
                digest.update(buffer, 0, len);
                progresso.valorMudou(readBytes += (long)len);
            }
            byte[] byArray = digest.digest();
            return byArray;
        }
        finally {
            progresso.tarefaTerminou();
            try {
                dados.close();
            }
            catch (IOException e) {
                JSignNet.logger.log(Level.INFO, "Falha ao fechar dados no c\u00e1lculo de hash", e);
            }
        }
    }

    private Hash(String digestOID, String nomeAlgoritmo) {
        this._digestOID = digestOID;
        this._nomeAlgoritmo = nomeAlgoritmo;
    }

    public String getDigestOID() {
        return this._digestOID;
    }

    public String getNomeAlgoritmo() {
        return this._nomeAlgoritmo;
    }

    public String toString() {
        if (this == MESMO_DO_CERTIFICADO) {
            return "Algoritmo de hashing igual ao do certificado usado para assinatura";
        }
        return "Algoritmo de hashing " + this.getNomeAlgoritmo();
    }

    public static Hash getHashDeNome(String nome) {
        if (nome == null) {
            throw new IllegalArgumentException("O nome do algoritmo precisa ser informado.");
        }
        for (int i = 0; i < ALGORITMOS.length; ++i) {
            Hash alg = ALGORITMOS[i];
            if (!Hash.removerHifen(alg.getNomeAlgoritmo()).equalsIgnoreCase(Hash.removerHifen(nome))) continue;
            return alg;
        }
        return null;
    }

    private static String removerHifen(String texto) {
        StringBuilder sb = new StringBuilder();
        for (char c : texto.toCharArray()) {
            if (c == '-') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static Hash getHashDeOID(String oid) {
        if (oid == null) {
            throw new IllegalArgumentException("O OID do algoritmo precisa ser informado.");
        }
        for (int i = 0; i < ALGORITMOS.length; ++i) {
            Hash alg = ALGORITMOS[i];
            if (!alg.getDigestOID().equalsIgnoreCase(oid)) continue;
            return alg;
        }
        return null;
    }
}

