/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.aplicacao;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import jsignnet.aplicacao.JSignNet;
import jsignnet.crypto.KeyStoreUtil;
import jsignnet.crypto.TipoKeyStore;
import jsignnet.crypto.X509CertificadoWrapper;
import jsignnet.erro.CertificadoNaoFoiLido;
import jsignnet.erro.ErroArquivoDiretorioNaoEncontrado;
import jsignnet.erro.ErroDeES;
import jsignnet.erro.ErroDeLeituraDeKeystore;
import jsignnet.erro.JSignExcecaoCadeiaVazia;
import jsignnet.erro.JSignException;
import jsignnet.infra.IContainer;
import jsignnet.infra.IFiltro;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class LeitorCertificados
implements IContainer {
    private IFiltro _filtro;

    protected LeitorCertificados() {
    }

    public synchronized IFiltro getFiltro() {
        return this._filtro;
    }

    public synchronized void setFiltro(IFiltro filtro) {
        this._filtro = filtro;
    }

    @Override
    public Map<String, X509CertificadoWrapper> getMapaCertificadosCAPI() throws JSignException {
        if (JSignNet.checkSO("win")) {
            KeyStore keystoreCAPI = KeyStoreUtil.leKeyStore(TipoKeyStore.SUNMSCAPI);
            this.fixAliases(keystoreCAPI);
            Map<String, X509CertificadoWrapper> resultado = this.populaCertificados(keystoreCAPI, null);
            return resultado;
        }
        return Collections.emptyMap();
    }

    private Map<String, X509CertificadoWrapper> populaCertificados(KeyStore ks, char[] senha) throws JSignException {
        Hashtable<String, X509CertificadoWrapper> resposta = new Hashtable<String, X509CertificadoWrapper>();
        IFiltro filtro = this.getFiltro();
        try {
            Enumeration<String> enumeration = ks.aliases();
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                if (!ks.isKeyEntry(alias)) continue;
                try {
                    X509CertificadoWrapper novaEntrada = new X509CertificadoWrapper(alias, ks, senha);
                    if (filtro != null && !filtro.isCertificadoValido(novaEntrada)) continue;
                    resposta.put(alias, novaEntrada);
                }
                catch (JSignExcecaoCadeiaVazia e) {
                    JSignNet.logger.log(Level.WARNING, "Falha ao ler a cadeia do certificado " + alias, e);
                }
            }
        }
        catch (KeyStoreException e) {
            throw new ErroDeLeituraDeKeystore(e);
        }
        catch (CertificateException e) {
            throw new CertificadoNaoFoiLido(e);
        }
        return resposta;
    }

    private Map<String, X509CertificadoWrapper> populaCertificadosConfiaveis(KeyStore ks, char[] senha) throws JSignException {
        Hashtable<String, X509CertificadoWrapper> resposta = new Hashtable<String, X509CertificadoWrapper>();
        IFiltro filtro = this.getFiltro();
        try {
            Enumeration<String> enumeration = ks.aliases();
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                if (!ks.isCertificateEntry(alias)) continue;
                try {
                    X509CertificadoWrapper novaEntrada = new X509CertificadoWrapper(alias, ks, senha);
                    if (filtro != null && !filtro.isCertificadoValido(novaEntrada)) continue;
                    resposta.put(alias, novaEntrada);
                }
                catch (JSignExcecaoCadeiaVazia e) {
                    JSignNet.logger.log(Level.WARNING, "Falha ao ler a cadeia do certificado " + alias, e);
                }
            }
        }
        catch (KeyStoreException e) {
            throw new ErroDeLeituraDeKeystore(e);
        }
        catch (CertificateException e) {
            throw new CertificadoNaoFoiLido(e);
        }
        return resposta;
    }

    @Override
    public Map<String, X509CertificadoWrapper> getMapaCertificadosJKS(File arquivo, char[] senha) throws JSignException {
        return this.getMapaCertificados(arquivo, senha, TipoKeyStore.JKS);
    }

    @Override
    public Map<String, X509CertificadoWrapper> getMapaCertificadosKeyChainStore() throws JSignException {
        Hashtable<String, X509CertificadoWrapper> resposta = new Hashtable<String, X509CertificadoWrapper>();
        if (JSignNet.checkSO("mac")) {
            KeyStore KeyChainStore = KeyStoreUtil.leKeyStore(TipoKeyStore.KEYCHAINSTORE);
            resposta.putAll(this.populaCertificados(KeyChainStore, null));
        }
        return resposta;
    }

    @Override
    public Map<String, X509CertificadoWrapper> getMapaCertificadosPKCS11(String pathArquivoConfiguracao, char[] pin) throws JSignException {
        if (JSignNet.checkJRE("1.5.0")) {
            try {
                Provider provider = this.instanciaSunPKCS11(pathArquivoConfiguracao);
                Security.addProvider(provider);
                KeyStore keystorePKCS11 = KeyStoreUtil.leKeyStorePKCS11(provider.getName(), pin);
                return this.populaCertificados(keystorePKCS11, pin);
            }
            catch (CertificadoNaoFoiLido provider) {
            }
            catch (ProviderException e) {
                JSignNet.logger.warning("Erro instanciando provider PKCS11:" + e.getMessage());
            }
            return Collections.emptyMap();
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, X509CertificadoWrapper> getMapaCertificadosPKCS12(File arquivo, char[] senha) throws JSignException {
        return this.getMapaCertificados(arquivo, senha, TipoKeyStore.PKCS12);
    }

    protected Map<String, X509CertificadoWrapper> getMapaCertificados(File arquivo, char[] senha, TipoKeyStore tipo) throws JSignException {
        HashMap<String, X509CertificadoWrapper> resposta = new HashMap<String, X509CertificadoWrapper>();
        KeyStore keystore = KeyStoreUtil.leKeyStore(arquivo, senha, tipo);
        resposta.putAll(this.populaCertificados(keystore, senha));
        return resposta;
    }

    public Map<String, X509CertificadoWrapper> getCertificadosConfiaveisJKS(File arquivo, char[] senha) throws JSignException {
        return this.populaCertificadosConfiaveis(KeyStoreUtil.leKeyStore(arquivo, senha, TipoKeyStore.JKS), senha);
    }

    public Map<String, X509CertificadoWrapper> getCertificadosConfiaveisJKS(InputStream arquivo, char[] senha) throws JSignException {
        return this.populaCertificadosConfiaveis(KeyStoreUtil.leKeyStore(arquivo, senha, TipoKeyStore.JKS), senha);
    }

    private Provider instanciaSunPKCS11(String caminhoArquivoCFG) throws JSignException {
        ComparableVersion versao9;
        ComparableVersion versaoAtual = new ComparableVersion(System.getProperty("java.version"));
        if (versaoAtual.compareTo(versao9 = new ComparableVersion("9")) >= 0) {
            return this.instanciaSunPKCS11JavaRecente(caminhoArquivoCFG);
        }
        return this.instanciaSunPKCS11Java8(caminhoArquivoCFG);
    }

    private Provider instanciaSunPKCS11Java8(String caminhoArquivoCFG) throws JSignException {
        Constructor<?> construtor;
        try {
            construtor = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(String.class);
        }
        catch (Exception e) {
            JSignNet.logger.severe("Erro instanciando provider sun PKCS11:" + e.getMessage());
            throw new JSignException(e, "Erro instanciando provider sun PKCS11:" + e.getMessage());
        }
        try {
            return (Provider)construtor.newInstance(caminhoArquivoCFG);
        }
        catch (InvocationTargetException e) {
            JSignNet.logger.log(Level.SEVERE, "Erro carregando configura\u00e7\u00e3o PKCS#11 " + caminhoArquivoCFG + ", erro:" + e.getTargetException().getMessage(), e.getTargetException());
            throw new JSignException(e, "Erro instanciando provider sun PKCS11 configurando " + caminhoArquivoCFG);
        }
        catch (Exception e) {
            JSignNet.logger.log(Level.SEVERE, "Erro carregando configura\u00e7\u00e3o PKCS#11 " + caminhoArquivoCFG + ", erro:" + e.getMessage(), e);
            throw new JSignException(e, "Erro instanciando provider sun PKCS11 configurando " + caminhoArquivoCFG);
        }
    }

    private Provider instanciaSunPKCS11JavaRecente(String caminhoArquivoCFG) throws JSignException {
        try {
            Provider p = Security.getProvider("SunPKCS11");
            Method configurar = Provider.class.getMethod("configure", String.class);
            p = (Provider)configurar.invoke((Object)p, caminhoArquivoCFG);
            return p;
        }
        catch (NoSuchMethodException e) {
            throw new ProviderException(e);
        }
        catch (InvocationTargetException e) {
            throw new ProviderException(e);
        }
        catch (IllegalAccessException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    public Map<String, String> getHardwarePKCS11(File diretorio) throws JSignException {
        HashMap<String, String> resposta = new HashMap<String, String>();
        try {
            if (diretorio.exists()) {
                File[] listagem = diretorio.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".cfg");
                    }
                });
                Properties propriedades = new Properties();
                for (int i = 0; i < listagem.length; ++i) {
                    propriedades.load(new FileInputStream(listagem[i]));
                    resposta.put((String)propriedades.get("name"), listagem[i].getAbsolutePath());
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new ErroArquivoDiretorioNaoEncontrado();
        }
        catch (IOException e) {
            throw new ErroDeES();
        }
        return resposta;
    }

    private void fixAliases(KeyStore keyStore) {
        try {
            Field field = keyStore.getClass().getDeclaredField("keyStoreSpi");
            field.setAccessible(true);
            KeyStoreSpi keyStoreVeritable = (KeyStoreSpi)field.get(keyStore);
            if ("sun.security.mscapi.KeyStore$MY".equals(keyStoreVeritable.getClass().getName())) {
                field = keyStoreVeritable.getClass().getEnclosingClass().getDeclaredField("entries");
                field.setAccessible(true);
                Object entriesObject = field.get(keyStoreVeritable);
                if (entriesObject instanceof Map) {
                    return;
                }
                Collection entries = (Collection)field.get(keyStoreVeritable);
                for (Object entry : entries) {
                    field = entry.getClass().getDeclaredField("certChain");
                    field.setAccessible(true);
                    X509Certificate[] certificates = (X509Certificate[])field.get(entry);
                    if (certificates.length == 0) continue;
                    String hashCode = Integer.toString(certificates[0].hashCode());
                    field = entry.getClass().getDeclaredField("alias");
                    field.setAccessible(true);
                    String alias = (String)field.get(entry);
                    if (alias.equals(hashCode)) continue;
                    field.set(entry, alias.concat(" - ").concat(hashCode));
                }
            }
        }
        catch (NoSuchFieldException e) {
            JSignNet.logger.log(Level.SEVERE, "Erro ao corrigir o alias do provider " + keyStore.getProvider().getName() + " :" + e.getMessage(), e);
        }
        catch (SecurityException e) {
            JSignNet.logger.log(Level.SEVERE, "Erro ao corrigir o alias do provider " + keyStore.getProvider().getName() + " :" + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            JSignNet.logger.log(Level.SEVERE, "Erro ao corrigir o alias do provider " + keyStore.getProvider().getName() + " :" + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            JSignNet.logger.log(Level.SEVERE, "Erro ao corrigir o alias do provider " + keyStore.getProvider().getName() + " :" + e.getMessage(), e);
        }
    }

    static {
        JSignNet.adicionaProviders();
    }
}

