/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.aplicacao;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import jsignnet.aplicacao.ControleProgresso;
import jsignnet.aplicacao.FileInputStreamParcial;
import jsignnet.aplicacao.Hash;
import jsignnet.aplicacao.JSignNet;
import jsignnet.erro.ErroAoLerAssinatura;
import jsignnet.erro.JSignExcecaoCancelamento;
import jsignnet.erro.JSignException;
import jsignnet.infra.CMSProcessablePartialFile;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSVerifierCertificateNotValidException;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class ValidadorAssinatura {
    protected ValidadorAssinatura() {
    }

    public boolean verificar(byte[] assinatura, byte[] conteudoAssinado) throws JSignException {
        boolean resposta = false;
        try {
            if (null == Security.getProvider("BC")) {
                Security.addProvider(new BouncyCastleProvider());
            }
            CMSSignedData signData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(conteudoAssinado), assinatura);
            Store certs = signData.getCertificates();
            SignerInformationStore signers = signData.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            while (it.hasNext() && !resposta) {
                SignerInformation signer = (SignerInformation)it.next();
                Collection certCollection = certs.getMatches((Selector)signer.getSID());
                Iterator certIt = certCollection.iterator();
                if (certIt == null) continue;
                X509CertificateHolder certHolder = (X509CertificateHolder)certIt.next();
                X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
                try {
                    resposta = signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert));
                }
                catch (CMSVerifierCertificateNotValidException e) {
                    JSignNet.logger.info("Certificado inv\u00e1lido utilizado para a assinatura: " + e.getMessage());
                    resposta = false;
                }
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                if (e.getMessage().indexOf("content hash found in signed attributes different") != -1) {
                    return false;
                }
                JSignNet.logger.severe("Erro no processo de verifica\u00e7\u00e3o da assinatura: " + e.getMessage());
            } else {
                JSignNet.logger.severe("Erro no processo de verifica\u00e7\u00e3o da assinatura: " + e.toString());
            }
            e.printStackTrace();
            throw new JSignException(e, "Erro no processo de verifica\u00e7\u00e3o da assinatura: " + e.getMessage());
        }
        return resposta;
    }

    public boolean verificar(byte[] assinatura, File arquivo, long tamanhoArquivo) throws JSignException {
        boolean resposta = false;
        try {
            if (null == Security.getProvider("BC")) {
                Security.addProvider(new BouncyCastleProvider());
            }
            CMSSignedData signData = new CMSSignedData((CMSProcessable)new CMSProcessablePartialFile(arquivo, tamanhoArquivo), assinatura);
            Store certs = signData.getCertificates();
            SignerInformationStore signers = signData.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            while (it.hasNext() && !resposta) {
                SignerInformation signer = (SignerInformation)it.next();
                Collection certCollection = certs.getMatches((Selector)signer.getSID());
                Iterator certIt = certCollection.iterator();
                if (certIt == null) continue;
                X509CertificateHolder certHolder = (X509CertificateHolder)certIt.next();
                X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
                resposta = signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert));
            }
        }
        catch (Exception e) {
            JSignNet.logger.severe("Erro no processo de verifica\u00e7\u00e3o da assinatura: " + e.getMessage());
            throw new JSignException(e, "Erro no processo de verifica\u00e7\u00e3o da assinatura: " + e.getMessage());
        }
        return resposta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verificarHash(Hash algoritmo, byte[] assinatura, File arquivo, long tamanhoArquivo, ControleProgresso progresso) throws JSignException, NoSuchAlgorithmException, IOException {
        progresso.setMinimo(0L);
        progresso.setMaximo(arquivo.length());
        FileInputStreamParcial in = new FileInputStreamParcial(arquivo, tamanhoArquivo);
        byte[] hash = algoritmo.geraDigest(in, progresso);
        if (hash == null) {
            progresso.tarefaTerminou();
            throw new JSignExcecaoCancelamento("Usu\u00e1rio cancelou a verifica\u00e7\u00e3o de assinatura digital.");
        }
        try {
            boolean bl = this.verificar(assinatura, hash);
            return bl;
        }
        finally {
            progresso.tarefaTerminou();
        }
    }

    public String getOIDAlgoritmoAssinatura(byte[] assinatura) throws ErroAoLerAssinatura {
        CMSSignedData signData;
        if (assinatura == null) {
            throw new IllegalArgumentException("A assinatura deve ser informada.");
        }
        try {
            signData = new CMSSignedData(assinatura);
        }
        catch (CMSException e) {
            throw new ErroAoLerAssinatura("N\u00e3o foi poss\u00edvel identificar o algoritmo na assinatura.");
        }
        catch (IllegalArgumentException e) {
            throw new ErroAoLerAssinatura("A assinatura digital n\u00e3o \u00e9 v\u00e1lida.");
        }
        try {
            SignerInformationStore signers = signData.getSignerInfos();
            Collection c = signers.getSigners();
            if (c.size() > 1) {
                throw new IllegalArgumentException("Assinatura tem mais de um assinante.");
            }
            if (c.size() <= 0) {
                throw new IllegalArgumentException("Assinatura sem assinante.");
            }
            Iterator it = c.iterator();
            SignerInformation signer = (SignerInformation)it.next();
            return signer.getDigestAlgOID();
        }
        catch (NullPointerException e) {
            throw new ErroAoLerAssinatura("A assinatura digital n\u00e3o \u00e9 v\u00e1lida.");
        }
    }

    public Hash getAlgoritmoAssinatura(byte[] assinatura) throws ErroAoLerAssinatura {
        String oidAlgoritmo = this.getOIDAlgoritmoAssinatura(assinatura);
        return Hash.getHashDeOID(oidAlgoritmo);
    }

    public byte[] extrairCertificado(byte[] assinatura) throws JSignException {
        try {
            if (null == Security.getProvider("BC")) {
                Security.addProvider(new BouncyCastleProvider());
            }
            CMSSignedData signData = new CMSSignedData(assinatura);
            Store certs = signData.getCertificates();
            SignerInformationStore signers = signData.getSignerInfos();
            Collection c = signers.getSigners();
            if (c.size() != 1) {
                return null;
            }
            Iterator it = c.iterator();
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder certHolder = (X509CertificateHolder)certIt.next();
            X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
            return cert.getEncoded();
        }
        catch (Exception e) {
            JSignNet.logger.severe("Erro no processo de extra\u00e7\u00e3o do certificado: " + e.getMessage());
            throw new JSignException(e, "Erro no processo de extra\u00e7\u00e3o do certificado: " + e.getMessage());
        }
    }

    static {
        JSignNet.adicionaProviders();
    }
}

