/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.crypto.icp;

import jsignnet.crypto.X509CertificadoWrapper;
import jsignnet.infra.IFiltro;

public class FiltroICPNumeroSerieSujeito
implements IFiltro {
    static final int TAMANHO_CNPJ = 14;
    static final int TAMANHO_CPF = 11;
    private static FiltroICPNumeroSerieSujeito _instancia = new FiltroICPNumeroSerieSujeito();

    private FiltroICPNumeroSerieSujeito() {
    }

    public static FiltroICPNumeroSerieSujeito singleton() {
        return _instancia;
    }

    @Override
    public boolean isCertificadoValido(X509CertificadoWrapper certificado) {
        String numeroSerieSujeito = certificado.getNumeroSerieSujeito();
        return numeroSerieSujeito != null && !numeroSerieSujeito.isEmpty() && (numeroSerieSujeito.length() == 11 || numeroSerieSujeito.length() == 14);
    }
}

