/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app.acoes;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.UUID;
import serpro.ppgd.app.acoes.ActionAb;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.exception.BarramentoException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.NavegadorHtml;
import serpro.ppgd.irpf.gui.nuvem.PainelProcessaLogin;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.nuvem.UsuarioLogado;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.CodigoTabelaMensagens;
import serpro.ppgd.irpf.util.CPFUtil;
import serpro.ppgd.negocio.ConstantesGlobais;

public class LoginGovAction
extends ActionAb {
    private static final long serialVersionUID = 1L;

    public LoginGovAction() {
    }

    public LoginGovAction(String pNomeAcao) {
        super(pNomeAcao);
    }

    @Override
    public final void executarAcao(ActionEvent ae) {
        try {
            this.iniciarLogon();
        }
        catch (AplicacaoException e) {
            GuiUtil.mostrarErro(e);
        }
    }

    public void iniciarLogon() throws AplicacaoException {
        this.iniciarLogon(null);
    }

    public void iniciarLogon(TarefaAposLogin aposSucesso) throws AplicacaoException {
        String state = UUID.randomUUID().toString();
        String msg = CadastroTabelasIRPF.recuperarMensagemHTML((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00500, (int)500);
        if (!GuiUtil.mostrarConfirma(ControladorGui.getJanelaPrincipal(), msg)) {
            return;
        }
        PainelProcessaLogin painelEspera = new PainelProcessaLogin();
        Runnable executarAposSucesso = () -> {
            BarramentoIRPFService.stopHTTPLocalhostServer();
            ControladorGui.atualizarUsuarioLogado(BarramentoIRPFService.getUsuarioLogado());
            GuiUtil.fecharDialog(painelEspera);
            GuiUtil.mostrarAviso("nuvem.info.login.sucesso", new String[]{CPFUtil.formatar((String)BarramentoIRPFService.getUsuarioLogado().getCpf()), BarramentoIRPFService.getUsuarioLogado().getNome()});
            if (aposSucesso != null) {
                aposSucesso.executar(BarramentoIRPFService.getUsuarioLogado());
            }
        };
        Runnable executarAposErro = () -> {
            BarramentoIRPFService.stopHTTPLocalhostServer();
            GuiUtil.fecharDialog(painelEspera);
        };
        try {
            BarramentoIRPFService.initHTTPLocalhostServer((Runnable)executarAposSucesso, (Runnable)executarAposErro, (String)state);
        }
        catch (BarramentoException e) {
            throw new AplicacaoException(e.getMessage(), (Throwable)e);
        }
        try {
            NavegadorHtml.executarNavegador(BarramentoIRPFService.URL_AUTENTICACAO_GOV_LOGIN_REDIRECT + "?exercicio=" + ConstantesGlobais.EXERCICIO + "&state=" + state);
        }
        catch (IOException e) {
            throw new AplicacaoException(e.getMessage(), (Throwable)e);
        }
        painelEspera.setAcaoCancelar(() -> {
            BarramentoIRPFService.stopHTTPLocalhostServer();
            GuiUtil.mostrarAviso("nuvem.info.login.cancelar");
            GuiUtil.fecharDialog(painelEspera);
        });
        GuiUtil.exibeDialog(ControladorGui.getJanelaPrincipal(), painelEspera, true, "Aguardando Login", false, null, null);
    }

    @FunctionalInterface
    public static interface TarefaAposLogin {
        public void executar(UsuarioLogado var1);
    }
}

