/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app.acoes;

import java.awt.event.ActionEvent;
import serpro.ppgd.app.acoes.ActionAb;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.dialogs.PainelGravarTransmitir;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.CPF;

public class TransmitirDeclaracaoAction
extends ActionAb {
    private static final long serialVersionUID = 1L;
    private CPF cpfAberto = null;
    private boolean comCertificado = false;

    public TransmitirDeclaracaoAction(boolean aComCert) {
        this.comCertificado = aComCert;
    }

    public TransmitirDeclaracaoAction() {
    }

    @Override
    public void executarAcao(ActionEvent e) {
        if (PainelGravarTransmitir.verificaReceitanetOk()) {
            if (this.cpfAberto != null) {
                try {
                    new PainelGravarTransmitir(this.cpfAberto.naoFormatado(), this.comCertificado);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.cpfAberto = null;
            } else {
                GuiUtil.exibeDialog(new PainelGravarTransmitir(this.comCertificado), true, MensagemUtil.getMensagem((String)"TransmitirDeclaracao"), false);
            }
        } else {
            PainelGravarTransmitir.exibeMsgReceitanetNaoInstalado();
        }
    }

    @Override
    public boolean isFecharDemonstrativoExigido() {
        if (ControladorGui.isDemonstrativoAberto()) {
            this.cpfAberto = IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf();
        }
        return !ControladorGui.isReadOnly();
    }

    @Override
    public boolean isDesabilitadoVersaoBeta() {
        return true;
    }

    @Override
    protected String getChaveMensagemConfirmaFecharDemonstrativo() {
        return "ConfirmarFecharDemonstrativoTransmitir";
    }

    @Override
    protected boolean podeExecutarEmReadOnly() {
        return false;
    }
}

