/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app.acoes;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import jupar.Downloader;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.styles.RoundedBalloonStyle;
import net.java.balloontip.utils.TimingUtils;
import serpro.ppgd.app.ConstantesMensagens;
import serpro.ppgd.app.acoes.ActionAb;
import serpro.ppgd.app.acoes.SairAction;
import serpro.ppgd.gui.DialogoOcupado;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.JanelaPrincipalIRPF;
import serpro.ppgd.irpf.gui.Toast;
import serpro.ppgd.irpf.gui.update.PainelAvisoVerificarAtualizacoes;
import serpro.ppgd.irpf.gui.update.PainelDownloadAtualizacoes;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.update.IRPFUpdateProperties;
import serpro.ppgd.irpf.util.update.IRPFUpdater;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.LogPPGD;

public class VerificarNovaVersaoAction
extends ActionAb {
    private static final long serialVersionUID = 1L;
    public static final String NOME_ARQ_PROPRIEDADES = "release_properties.xml";
    private boolean exibirDicaAtualizar = true;
    private boolean exibirPopups = true;

    @Override
    public void executarAcao(ActionEvent e) {
        this.verificarUltimaVersao();
    }

    public void verificarUltimaVersao() {
        AplicacaoException appException = null;
        IRPFUpdateProperties updateProperties = null;
        try {
            updateProperties = GuiUtil.executarTarefa("Verificando atualiza\u00e7\u00e3o...", 5, () -> IRPFUpdater.getInstance().verificarUltimaVersaoOnline(), true);
        }
        catch (AplicacaoException ex) {
            appException = ex;
        }
        catch (Exception ex) {
            LogPPGD.erro((String)ex.getMessage());
            ex.printStackTrace();
            appException = new AplicacaoException(ConstantesMensagens.ConstantesEnum.MSG_ATUALIZAR_ERRO_VERIFICACAO.getChave());
        }
        this.verificacaoFinalizada(IRPFUpdater.getInstance(), updateProperties, appException);
    }

    public Map<String, CadastroTabelasIRPF.TabelasBasicas> obterMapaArquivosParaAtualizar(IRPFUpdater irpfUpdater) {
        CadastroTabelasIRPF.TabelasBasicas[] tabelas;
        HashMap<String, CadastroTabelasIRPF.TabelasBasicas> mapaArquivosParaAtualizar = new HashMap<String, CadastroTabelasIRPF.TabelasBasicas>();
        for (CadastroTabelasIRPF.TabelasBasicas tabela : tabelas = CadastroTabelasIRPF.TabelasBasicas.values()) {
            if (!irpfUpdater.temNovaVersaoArquivo(tabela.getIdentificador(), tabela.getHash())) continue;
            mapaArquivosParaAtualizar.put(tabela.getIdentificador(), tabela);
        }
        return mapaArquivosParaAtualizar;
    }

    public void verificacaoFinalizada(IRPFUpdater irpfUpdater, IRPFUpdateProperties updateProperties, AplicacaoException exception) {
        if (exception != null) {
            if (this.isExibirPopups()) {
                GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), exception.getMessage());
            }
        } else if (updateProperties != null) {
            this.confirmarNovaVersao(irpfUpdater, updateProperties);
        } else {
            Map<String, CadastroTabelasIRPF.TabelasBasicas> mapaArquivosParaAtualizar = this.obterMapaArquivosParaAtualizar(irpfUpdater);
            if (mapaArquivosParaAtualizar.size() > 0) {
                this.atualizarTabelas(irpfUpdater, mapaArquivosParaAtualizar);
            } else if (this.isExibirPopups()) {
                GuiUtil.mostrarInfo("atualizar.aviso.semNovaVersao", new String[]{ConstantesGlobais.EXERCICIO});
            }
        }
    }

    public BalloonTip novaInstanciaBalaoDica() {
        BalloonTip balloonTip = new BalloonTip((JComponent)((JanelaPrincipalIRPF)PlataformaPPGD.getPlataforma().getJanelaPrincipal()).getJMenuFerramentas(), (JComponent)new JLabel(MensagemUtil.getMensagem((String)"atualizar.aviso.dicaMenuFerramentas")), (BalloonTipStyle)new RoundedBalloonStyle(5, 5, Color.white, Color.gray), BalloonTip.Orientation.LEFT_ABOVE, BalloonTip.AttachLocation.ALIGNED, 30, 15, true);
        balloonTip.setPadding(10);
        balloonTip.setTopLevelContainer(PlataformaPPGD.getPlataforma().getJanelaPrincipal().getLayeredPane());
        return balloonTip;
    }

    public void confirmarNovaVersao(final IRPFUpdater irpfUpdater, final IRPFUpdateProperties updateProperties) {
        String titulo = MensagemUtil.getMensagem((String)"atualizar.titulo");
        String mensagem = null;
        PainelAvisoVerificarAtualizacoes painel = null;
        if (!irpfUpdater.temPermissaoEscritaPastaBase() || updateProperties.isDownloadManual()) {
            mensagem = updateProperties.getTipoAtualizacao() == IRPFUpdateProperties.TipoAtualizacao.Obrigatoria ? (irpfUpdater.temPermissaoEscritaPastaBase() ? "atualizar.aviso.atualizacaoManualObrigatoria" : "atualizar.aviso.semPermissaoAtualizacao.atualizacaoManualObrigatoria") : (irpfUpdater.temPermissaoEscritaPastaBase() ? "atualizar.aviso.atualizacaoManual" : "atualizar.aviso.semPermissaoAtualizacao.atualizacaoManual");
            mensagem = MensagemUtil.getMensagem((String)mensagem, (String[])new String[]{ConstantesGlobais.EXERCICIO, updateProperties.getUltimaVersao()});
            painel = new PainelAvisoVerificarAtualizacoes(titulo, mensagem, "Sim", "N\u00e3o");
            GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), painel, true, "Verificar Atualiza\u00e7\u00f5es", false, null, null, false, 0, false, true);
            if (painel.isAtualizar()) {
                try {
                    irpfUpdater.execNavegador(updateProperties.getEnderecoServidorDownloadManual());
                }
                catch (AplicacaoException e) {
                    LogPPGD.erro((String)e.getMessage());
                    GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), e.getMessage());
                }
                SairAction fecharAction = new SairAction();
                fecharAction.setMostrarConfirmacaoFecharPrograma(false);
                fecharAction.actionPerformed(null);
            }
        } else {
            mensagem = updateProperties.getTipoAtualizacao() == IRPFUpdateProperties.TipoAtualizacao.Obrigatoria ? "atualizar.confirma.atualizacaoObrigatoria" : "atualizar.confirma.novaVersao";
            mensagem = MensagemUtil.getMensagem((String)mensagem, (String[])new String[]{ConstantesGlobais.EXERCICIO, updateProperties.getUltimaVersao()});
            painel = new PainelAvisoVerificarAtualizacoes(titulo, mensagem);
            GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), painel, true, "Verificar Atualiza\u00e7\u00f5es", false, null, null, false, 0, false, true);
            if (painel.isAtualizar()) {
                if (this.verificarDemonstrativoFechado()) {
                    final PainelDownloadAtualizacoes painelDownload = new PainelDownloadAtualizacoes("Atualizando o IRPF" + ConstantesGlobais.EXERCICIO, GuiUtil.getImage("/icones/png16px/actualize-arrows-couple-in-circle.png"));
                    final Downloader.DownloadProgress progress = new Downloader.DownloadProgress(512){

                        public void onProgressChanged(boolean finished) {
                            final long downloaded = this.getTotalDownloadedFileSize() * 100L / this.getTotalDownloadingFileSize();
                            if (finished) {
                                if (this.isCanceled()) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            painelDownload.getLblDescricao().setText("Transfer\u00eancia de arquivos cancelada.");
                                            painelDownload.getLblPercentual().setText("");
                                            painelDownload.getProgressBar().setValue(painelDownload.getProgressBar().getMaximum());
                                        }
                                    });
                                } else {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            painelDownload.getLblDescricao().setText("Transfer\u00eancia de arquivos conclu\u00edda.");
                                            painelDownload.getLblPercentual().setText("");
                                            painelDownload.getProgressBar().setValue(painelDownload.getProgressBar().getMaximum());
                                        }
                                    });
                                }
                            } else {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        painelDownload.getLblDescricao().setText("Transferindo arquivo " + (this.getTotalDownloadedFiles() + 1) + " de " + this.getTotalFiles());
                                        painelDownload.getLblPercentual().setText(downloaded + "% completo");
                                        painelDownload.getProgressBar().setValue((int)downloaded);
                                    }
                                });
                            }
                        }
                    };
                    painelDownload.getBtnCancelar().addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            progress.setCanceled(true);
                        }
                    });
                    Runnable updatethread = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), painelDownload, true, "Verificar Atualiza\u00e7\u00f5es", false, null, null, false, 0, false, true);
                                    }
                                });
                                irpfUpdater.download(updateProperties, progress);
                            }
                            catch (AplicacaoException ex) {
                                try {
                                    GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), ex.getMessage());
                                }
                                catch (Throwable throwable) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            GuiUtil.fecharDialog(painelDownload);
                                        }
                                    });
                                    throw throwable;
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                return;
                            }
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            if (progress.isCanceled()) {
                                System.out.println("Atualiza\u00e7\u00e3o do IRPF" + ConstantesGlobais.EXERCICIO + ". Transfer\u00eancia de arquivos cancelada.");
                                GuiUtil.mostrarAviso(GuiUtil.getParent(), MensagemUtil.getMensagem((String)"atualizar.aviso.downloadCancelado"));
                            } else {
                                System.out.println("Atualiza\u00e7\u00e3o do IRPF" + ConstantesGlobais.EXERCICIO + ". Transfer\u00eancia de arquivos conclu\u00edda.");
                                GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new PainelAvisoVerificarAtualizacoes("Concluir Atualiza\u00e7\u00e3o", MensagemUtil.getMensagem((String)"atualizar.aviso.update"), PainelAvisoVerificarAtualizacoes.IconeAvisoAtualizacao.ICONE_OK, null, "OK"), true, "Verificar Atualiza\u00e7\u00f5es", false, null, null, false, 0, false, true);
                                SairAction fecharAction = new SairAction(){

                                    @Override
                                    protected void onExitPgd() {
                                        try {
                                            irpfUpdater.execUpdate(updateProperties);
                                        }
                                        catch (AplicacaoException ex) {
                                            GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), ex.getMessage());
                                        }
                                    }
                                };
                                fecharAction.setMostrarConfirmacaoFecharPrograma(false);
                                fecharAction.actionPerformed(null);
                            }
                        }
                    };
                    new Thread(updatethread).start();
                }
            } else if (this.isExibirDicaAtualizar()) {
                final BalloonTip balloonTip = this.novaInstanciaBalaoDica();
                TimingUtils.showTimedBalloon((BalloonTip)balloonTip, (int)10000, (ActionListener)new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        balloonTip.closeBalloon();
                    }
                });
            }
        }
    }

    public void atualizarTabelas(final IRPFUpdater irpfUpdater, final Map<String, CadastroTabelasIRPF.TabelasBasicas> mapaArquivosParaAtualizar) {
        if (irpfUpdater.temPermissaoEscritaPastaBase() && this.verificarDemonstrativoFechado()) {
            final DialogoOcupado dlg = DialogoOcupado.exibeDialogo((String)"Atualizando tabelas internas...");
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    System.out.println("Executando download...");
                    irpfUpdater.download(mapaArquivosParaAtualizar.keySet(), null);
                    irpfUpdater.update(mapaArquivosParaAtualizar.keySet());
                    irpfUpdater.resetUpdateStatus();
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                protected void done() {
                    AplicacaoException ex = null;
                    try {
                        this.get();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                        Throwable cause = e.getCause();
                        ex = cause != null && cause instanceof AplicacaoException ? (AplicacaoException)cause : new AplicacaoException(ConstantesMensagens.ConstantesEnum.MSG_ATUALIZAR_ERRO_VERIFICACAO.getChave(), (Throwable)e);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                dlg.finaliza();
                            }
                        });
                        if (ex == null) {
                            for (CadastroTabelasIRPF.TabelasBasicas tabela : mapaArquivosParaAtualizar.values()) {
                                tabela.carregarTabela();
                            }
                            ControladorGui.informarTabelasAtualizadas();
                            if (VerificarNovaVersaoAction.this.isExibirPopups()) {
                                GuiUtil.mostrarInfo("atualizar.info.atualizacaoTabelasSucesso");
                            } else {
                                Toast.makeText(ControladorGui.getJanelaPrincipal(), MensagemUtil.getMensagem((String)"atualizar.info.atualizacaoTabelasSucesso")).display();
                            }
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        ex = new AplicacaoException(ConstantesMensagens.ConstantesEnum.MSG_ATUALIZAR_ERRO_VERIFICACAO.getChave());
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        if (ex == null) {
                            for (CadastroTabelasIRPF.TabelasBasicas tabela : mapaArquivosParaAtualizar.values()) {
                                tabela.carregarTabela();
                            }
                            ControladorGui.informarTabelasAtualizadas();
                            if (VerificarNovaVersaoAction.this.isExibirPopups()) {
                                GuiUtil.mostrarInfo("atualizar.info.atualizacaoTabelasSucesso");
                            } else {
                                Toast.makeText(ControladorGui.getJanelaPrincipal(), MensagemUtil.getMensagem((String)"atualizar.info.atualizacaoTabelasSucesso")).display();
                            }
                        }
                        {
                            catch (Throwable throwable) {
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                if (ex == null) {
                                    for (CadastroTabelasIRPF.TabelasBasicas tabela : mapaArquivosParaAtualizar.values()) {
                                        tabela.carregarTabela();
                                    }
                                    ControladorGui.informarTabelasAtualizadas();
                                    if (VerificarNovaVersaoAction.this.isExibirPopups()) {
                                        GuiUtil.mostrarInfo("atualizar.info.atualizacaoTabelasSucesso");
                                    } else {
                                        Toast.makeText(ControladorGui.getJanelaPrincipal(), MensagemUtil.getMensagem((String)"atualizar.info.atualizacaoTabelasSucesso")).display();
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    if (ex == null) {
                        for (CadastroTabelasIRPF.TabelasBasicas tabela : mapaArquivosParaAtualizar.values()) {
                            tabela.carregarTabela();
                        }
                        ControladorGui.informarTabelasAtualizadas();
                        if (VerificarNovaVersaoAction.this.isExibirPopups()) {
                            GuiUtil.mostrarInfo("atualizar.info.atualizacaoTabelasSucesso");
                        } else {
                            Toast.makeText(ControladorGui.getJanelaPrincipal(), MensagemUtil.getMensagem((String)"atualizar.info.atualizacaoTabelasSucesso")).display();
                        }
                    }
                }
            }.execute();
        }
    }

    public boolean isExibirDicaAtualizar() {
        return this.exibirDicaAtualizar;
    }

    public void setExibirDicaAtualizar(boolean exibirDicaAtualizar) {
        this.exibirDicaAtualizar = exibirDicaAtualizar;
    }

    public boolean isExibirPopups() {
        return this.exibirPopups;
    }

    public void setExibirPopups(boolean exibirPopups) {
        this.exibirPopups = exibirPopups;
    }

    @Override
    public boolean isFecharDemonstrativoExigido() {
        return true;
    }
}

