/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.app.acoes.GravarCopiaSegurancaAction;
import serpro.ppgd.app.acoes.RecuperarDecOnlineAction;
import serpro.ppgd.app.acoes.SalvarOnlineAction;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelPesquisaPorNome;
import serpro.ppgd.irpf.gui.TableSelecionaDeclaracaoPreenchimento;
import serpro.ppgd.irpf.gui.dialogs.PainelGravarTransmitir;
import serpro.ppgd.irpf.gui.dialogs.PainelSelecaoTipoImpressaoNova;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;

public class PainelDeclaracoesPreenchimento
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Abrir uma declara\u00e7\u00e3o";
    private static final int INDICE_COLUNA_TIPO = 1;
    private static final int INDICE_COLUNA_AJUSTE_ESPOLIO_SAIDA = 2;
    private static final int INDICE_COLUNA_CPF = 3;
    private static final int INDICE_COLUNA_NOME = 4;
    private JLabel btnAbrir;
    private JLabel btnExcluir;
    private JLabel btnGravar;
    private JLabel btnImprimir;
    private JLabel btnTransmitir;
    private JCheckBox chkCertificacaoDigital;
    private TableSelecionaDeclaracaoPreenchimento edtTableDecs;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private PainelPesquisaPorNome painelPesquisaPorNome;

    public PainelDeclaracoesPreenchimento() {
        this.initComponents();
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ControladorGui.repaintTelaBemVindos();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ControladorGui.repaintTelaBemVindos();
            }
        };
        this.btnAbrir.addMouseListener(mouseListener);
        this.btnExcluir.addMouseListener(mouseListener);
        this.btnGravar.addMouseListener(mouseListener);
        this.btnImprimir.addMouseListener(mouseListener);
        this.btnTransmitir.addMouseListener(mouseListener);
        this.configurarEventosTabela();
        this.jScrollPane1.getViewport().setBackground(Color.WHITE);
        this.configurarBotao(this.btnAbrir, "Abrir Declara\u00e7\u00e3o");
        this.configurarBotao(this.btnExcluir, "Excluir Declara\u00e7\u00e3o");
        this.configurarBotao(this.btnTransmitir, "Entregar Declara\u00e7\u00e3o");
        this.configurarBotao(this.btnImprimir, "Imprimir Declara\u00e7\u00e3o");
        this.configurarBotao(this.btnGravar, "Gravar C\u00f3pia de Seguran\u00e7a");
        this.btnAbrir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PainelDeclaracoesPreenchimento.this.edtTableDecs.getSelectedRow() == -1) {
                    ControladorGui.repaintTelaBemVindos();
                    GuiUtil.mostrarInfo(null, "Selecione uma declara\u00e7\u00e3o");
                } else {
                    PainelDeclaracoesPreenchimento.this.btnAbrirClick();
                }
            }
        });
        this.btnExcluir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PainelDeclaracoesPreenchimento.this.edtTableDecs.getSelectedRow() == -1) {
                    ControladorGui.repaintTelaBemVindos();
                    GuiUtil.mostrarInfo(null, "Selecione uma declara\u00e7\u00e3o");
                } else {
                    PainelDeclaracoesPreenchimento.this.btnExcluirClick(true);
                }
            }
        });
        this.btnTransmitir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PainelDeclaracoesPreenchimento.this.edtTableDecs.getSelectedRow() == -1) {
                    ControladorGui.repaintTelaBemVindos();
                    GuiUtil.mostrarInfo(null, "Selecione uma declara\u00e7\u00e3o");
                } else {
                    PainelDeclaracoesPreenchimento.this.btnTransmitirClick();
                }
            }
        });
        this.btnImprimir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PainelDeclaracoesPreenchimento.this.edtTableDecs.getSelectedRow() == -1) {
                    ControladorGui.repaintTelaBemVindos();
                    GuiUtil.mostrarInfo(null, "Selecione uma declara\u00e7\u00e3o");
                } else {
                    PainelDeclaracoesPreenchimento.this.btnImprimirClick();
                }
            }
        });
        this.btnGravar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PainelDeclaracoesPreenchimento.this.edtTableDecs.getSelectedRow() == -1) {
                    GuiUtil.mostrarInfo(null, "Selecione uma declara\u00e7\u00e3o");
                } else {
                    PainelDeclaracoesPreenchimento.this.btnGravarClick();
                }
            }
        });
        this.edtTableDecs.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (PainelDeclaracoesPreenchimento.this.edtTableDecs.getSelectedRowCount() > 0 && e.getKeyCode() == 32) {
                    PainelDeclaracoesPreenchimento.this.btnAbrirClick();
                }
            }
        });
    }

    public int obterNumeroDeclaracoes() {
        return this.edtTableDecs.getModel().getRowCount();
    }

    public void btnAbrirClick() {
        try {
            ControladorGui.abrirDemonstrativo(this.getIdDeclaracaoSelecionado(), true);
        }
        catch (HashInvalidoException ex) {
            ControladorGui.tratarException((Exception)((Object)ex));
        }
    }

    public void btnExcluirClick(boolean confirmar) {
        ControladorGui.repaintTelaBemVindos();
        if (confirmar && JOptionPane.showConfirmDialog(this.getParent(), "Tem certeza que deseja excluir esta declara\u00e7\u00e3o?", "Confirma\u00e7\u00e3o", 0) == 0) {
            ArrayList<IdentificadorDeclaracao> ids = new ArrayList<IdentificadorDeclaracao>();
            ids.add(this.getIdDeclaracaoSelecionado());
            ControladorGui.excluirDemonstrativo(ids);
            this.atualizarListaDeclaracoesPreenchimento();
        }
    }

    public void btnTransmitirClick() {
        if (PainelGravarTransmitir.verificaReceitanetOk()) {
            ControladorGui.repaintTelaBemVindos();
            String cpfAberto = this.getIdDeclaracaoSelecionado().getCpf().naoFormatado();
            new PainelGravarTransmitir(cpfAberto, this.chkCertificacaoDigital.isSelected());
        } else {
            PainelGravarTransmitir.exibeMsgReceitanetNaoInstalado();
        }
    }

    public void btnImprimirClick() {
        ControladorGui.repaintTelaBemVindos();
        PainelSelecaoTipoImpressaoNova selTipoImpressao = new PainelSelecaoTipoImpressaoNova(this.getIdDeclaracaoSelecionado());
        GuiUtil.exibeDialog(selTipoImpressao, true, "IRPF " + ConstantesGlobais.EXERCICIO + " Impress\u00e3o", false);
    }

    public void btnSalvarClick() {
        ControladorGui.repaintTelaBemVindos();
        if (GuiUtil.mostrarConfirma("nuvem.info.salvar.declaracao.fechada")) {
            try {
                ControladorGui.abrirDemonstrativo(this.getIdDeclaracaoSelecionado(), true);
                SalvarOnlineAction salvarRecuperarOnlineAction = new SalvarOnlineAction();
                salvarRecuperarOnlineAction.executarAcao(null);
            }
            catch (HashInvalidoException ex) {
                ControladorGui.tratarException((Exception)((Object)ex));
            }
        }
    }

    public void btnRecuperarClick() {
        ControladorGui.repaintTelaBemVindos();
        RecuperarDecOnlineAction recuperarOnlineAction = new RecuperarDecOnlineAction();
        recuperarOnlineAction.executarAcao(null);
    }

    public void btnGravarClick() {
        ControladorGui.repaintTelaBemVindos();
        new GravarCopiaSegurancaAction(this.getIdDeclaracaoSelecionado());
    }

    private IdentificadorDeclaracao getIdDeclaracaoSelecionado() {
        int linha = ((TableRowSorter)this.edtTableDecs.getRowSorter()).convertRowIndexToModel(this.edtTableDecs.getSelectedRow());
        IdentificadorDeclaracao id = this.edtTableDecs.getIdentificadorDeclaracao(linha);
        return id;
    }

    private void configurarEventosTabela() {
        this.edtTableDecs.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PainelDeclaracoesPreenchimento.this.habilitarBotoes();
                if (e.getClickCount() == 2 && PainelDeclaracoesPreenchimento.this.edtTableDecs.getSelectedRowCount() > 0) {
                    try {
                        ControladorGui.abrirDemonstrativo(PainelDeclaracoesPreenchimento.this.getIdDeclaracaoSelecionado(), true);
                    }
                    catch (HashInvalidoException ex) {
                        ControladorGui.tratarException((Exception)((Object)ex));
                    }
                }
            }
        });
        this.edtTableDecs.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                PainelDeclaracoesPreenchimento.this.habilitarBotoes();
            }
        });
        this.habilitarBotoes();
        this.painelPesquisaPorNome.setSorter(this.edtTableDecs.getTableRowSorter());
    }

    private void habilitarBotoes() {
        if (this.edtTableDecs.getSelectionModel().isSelectionEmpty()) {
            this.btnAbrir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_abrir_PB.png")));
            this.btnExcluir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_excluir_PB.png")));
            this.btnTransmitir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_transmitir_globo_PB.png")));
            this.btnImprimir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/IM_decl_PB.png")));
            this.btnGravar.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_gravar_PB.png")));
        } else {
            this.btnAbrir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_abrir.png")));
            this.btnExcluir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_excluir.png")));
            this.btnTransmitir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_transmitir_globo.png")));
            this.btnImprimir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/IM_decl.png")));
            this.btnGravar.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_gravar.png")));
        }
    }

    private void configurarBotao(final JLabel botao, String hint) {
        botao.setToolTipText(hint);
        botao.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                botao.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                botao.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    public void atualizarListaDeclaracoesPreenchimento() {
        this.edtTableDecs = new TableSelecionaDeclaracaoPreenchimento();
        this.jScrollPane1.setViewportView(this.edtTableDecs);
        this.configurarEventosTabela();
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.chkCertificacaoDigital = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.edtTableDecs = new TableSelecionaDeclaracaoPreenchimento();
        this.btnAbrir = new JLabel();
        this.btnExcluir = new JLabel();
        this.btnTransmitir = new JLabel();
        this.btnImprimir = new JLabel();
        this.btnGravar = new JLabel();
        this.painelPesquisaPorNome = new PainelPesquisaPorNome(false);
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jLabel4.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/AB_completa.png")));
        this.jLabel4.setText("Completa");
        this.jLabel5.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/AB_simplif.png")));
        this.jLabel5.setText("Simplificada");
        this.chkCertificacaoDigital.setBackground(new Color(254, 254, 254));
        this.chkCertificacaoDigital.setFont(FontesUtil.FONTE_NORMAL);
        this.chkCertificacaoDigital.setText("Transmitir com certifica\u00e7\u00e3o digital");
        this.chkCertificacaoDigital.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkCertificacaoDigital.setOpaque(true);
        this.chkCertificacaoDigital.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelDeclaracoesPreenchimento.this.chkCertificacaoDigitalActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel4, -2, 91, -2).addPreferredGap(0).add((Component)this.jLabel5).add(18, 18, 18).add((Component)this.chkCertificacaoDigital).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel5, -2, 28, -2).add((Component)this.jLabel4, -2, 28, -2).add((Component)this.chkCertificacaoDigital)));
        this.jLabel4.getAccessibleContext().setAccessibleName("");
        this.jLabel4.getAccessibleContext().setAccessibleDescription("");
        this.jLabel5.getAccessibleContext().setAccessibleName("");
        this.jLabel5.getAccessibleContext().setAccessibleDescription("");
        this.jScrollPane1.setViewportView(this.edtTableDecs);
        this.btnAbrir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_abrir_PB.png")));
        this.btnExcluir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_excluir_PB.png")));
        this.btnTransmitir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_transmitir_globo_PB.png")));
        this.btnImprimir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/IM_decl_PB.png")));
        this.btnGravar.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_gravar_PB.png")));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.painelPesquisaPorNome, -1, 686, Short.MAX_VALUE).add((Component)this.jScrollPane1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.btnAbrir).add(2, (Component)this.btnExcluir)).add(2, (Component)this.btnTransmitir)).add(2, (Component)this.btnImprimir)).add(2, (Component)this.btnGravar)).addContainerGap(-1, Short.MAX_VALUE)).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.painelPesquisaPorNome, -2, 28, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 198, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.btnAbrir).addPreferredGap(0).add((Component)this.btnExcluir).addPreferredGap(0).add((Component)this.btnTransmitir).addPreferredGap(0).add((Component)this.btnImprimir).addPreferredGap(0).add((Component)this.btnGravar).add(0, 0, Short.MAX_VALUE))).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2)));
        this.painelPesquisaPorNome.getAccessibleContext().setAccessibleName("");
        this.painelPesquisaPorNome.getAccessibleContext().setAccessibleDescription("");
    }

    private void chkCertificacaoDigitalActionPerformed(ActionEvent evt) {
    }
}

