/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Color;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import serpro.ppgd.irpf.ColecaoIdDeclaracao;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.txt.util.IRPFTxtUtil;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public final class TableModelSelecionaDeclaracao
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private ColecaoIdDeclaracao colecaoIds = IRPFFacade.getListaIdDeclaracoes();
    private String pathTransmitidas;
    private String pathGravadas;

    public TableModelSelecionaDeclaracao() {
        this.setPathTransmitidas(UtilitariosArquivo.getPathTransmitidas());
        this.setPathGravadas(UtilitariosArquivo.getPathGravadas());
    }

    @Override
    public int getRowCount() {
        return this.colecaoIds.itens().size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.montaPainelNumRecibo(rowIndex);
            }
            case 1: {
                return this.obtemInformacao(rowIndex, columnIndex);
            }
            case 2: {
                return this.obtemInformacao(rowIndex, columnIndex);
            }
            case 3: {
                return this.obtemInformacao(rowIndex, columnIndex);
            }
            case 4: {
                return this.obtemInformacao(rowIndex, columnIndex);
            }
        }
        return "";
    }

    public IdentificadorDeclaracao getIdentificadorDeclaracao(int rowIndex) {
        IdentificadorDeclaracao id = (IdentificadorDeclaracao)this.colecaoIds.itens().get(rowIndex);
        return id;
    }

    private Object obtemInformacao(int rowIndex, int columnIndex) {
        IdentificadorDeclaracao idDeclaracao = this.getIdentificadorDeclaracao(rowIndex);
        String retif = "";
        if (idDeclaracao.getDeclaracaoRetificadora().naoFormatado().equals(Logico.SIM)) {
            retif = "Retificadora";
        } else if (idDeclaracao.getDeclaracaoRetificadora().naoFormatado().equals(Logico.NAO)) {
            retif = "Original";
        }
        String ajuste = "";
        ajuste = idDeclaracao.isEspolio() ? "Esp\u00f3lio" : (idDeclaracao.isSaida() ? "Sa\u00edda" : "Ajuste");
        switch (columnIndex) {
            case 1: {
                return retif;
            }
            case 2: {
                return ajuste;
            }
            case 3: {
                return idDeclaracao.getCpf().formatado();
            }
            case 4: {
                return idDeclaracao.getNome().formatado();
            }
        }
        return null;
    }

    private JPanel montaPainelNumRecibo(int rowIndex) {
        final IdentificadorDeclaracao id = this.getIdentificadorDeclaracao(rowIndex);
        File decGeradaEntrega = IRPFTxtUtil.montaPathTXTDeclaracao((String)this.getPathGravadas(), (IdentificadorDeclaracao)id, (boolean)true);
        boolean gravada = false;
        final String foiTransmitida = IRPFTxtUtil.declaracaoFoiTransmitida((IdentificadorDeclaracao)id, (String)this.getPathTransmitidas());
        JPanel pnl = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public String toString() {
                return TableModelSelecionaDeclaracao.this.obterNomeAcessivel(id, false, foiTransmitida);
            }
        };
        pnl.setLayout(new FlowLayout(0));
        pnl.setBackground(Color.WHITE);
        pnl.setAlignmentX(0.5f);
        if (id.isCompleta()) {
            pnl.add(new JLabel(GuiUtil.getImage("/icones/png16px/AB_completa.png")));
        } else {
            pnl.add(new JLabel(GuiUtil.getImage("/icones/png16px/AB_simplif.png")));
        }
        if (foiTransmitida != null && foiTransmitida.trim().length() > 0) {
            pnl.add(new JLabel(GuiUtil.getImage("/icones/png16px/AB_transmitido.png")));
            pnl.add(new JLabel(IRPFTxtUtil.formataNumeroRecibo((String)foiTransmitida)));
        }
        return pnl;
    }

    private String obterNomeAcessivel(IdentificadorDeclaracao id, boolean gravada, String foiTransmitida) {
        StringBuilder nomeAcessivel = new StringBuilder();
        nomeAcessivel.append("Declara\u00e7\u00e3o de ");
        if (id.isAjuste()) {
            nomeAcessivel.append("Ajuste Anual");
            if (id.isCompleta()) {
                nomeAcessivel.append(" Completa");
            } else {
                nomeAcessivel.append(" Simplificada");
            }
        } else if (id.isEspolio()) {
            nomeAcessivel.append("Final de Esp\u00f3lio");
        } else {
            nomeAcessivel.append("Sa\u00edda Definitiva do Pa\u00eds");
        }
        nomeAcessivel.append(" - ");
        nomeAcessivel.append("Contribuinte: " + id.getNome().naoFormatado());
        nomeAcessivel.append(" - ");
        nomeAcessivel.append("CPF: " + id.getCpf().naoFormatado());
        nomeAcessivel.append(" - ");
        nomeAcessivel.append(id.getDeclaracaoRetificadora().naoFormatado().equals(Logico.NAO) ? "Original" : "Retificadora");
        if (gravada) {
            nomeAcessivel.append(" - ");
            nomeAcessivel.append("Gravada");
        }
        if (foiTransmitida != null && foiTransmitida.trim().length() > 0) {
            nomeAcessivel.append(" - ");
            nomeAcessivel.append("Transmitida");
            nomeAcessivel.append(" - ");
            nomeAcessivel.append("N\u00famero do Recibo: " + IRPFTxtUtil.formataNumeroRecibo((String)foiTransmitida));
        }
        return nomeAcessivel.toString();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "N\u00ba do Recibo";
            }
            case 1: {
                return "Tipo";
            }
            case 2: {
                return "A/E/S";
            }
            case 3: {
                return "CPF";
            }
            case 4: {
                return "Nome";
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return super.isCellEditable(rowIndex, columnIndex);
    }

    public void setColecaoIdDeclaracao(ColecaoIdDeclaracao col) {
        this.colecaoIds = col;
        this.fireTableDataChanged();
    }

    public void setPathTransmitidas(String pathTransmitidas) {
        this.pathTransmitidas = pathTransmitidas;
    }

    public String getPathTransmitidas() {
        return this.pathTransmitidas;
    }

    public void setPathGravadas(String pathGravadas) {
        this.pathGravadas = pathGravadas;
    }

    public String getPathGravadas() {
        return this.pathGravadas;
    }
}

