/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Color;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import serpro.ppgd.irpf.ColecaoIdDeclaracao;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.negocio.Logico;

public final class TableModelSelecionaDeclaracaoPreenchimento
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private ColecaoIdDeclaracao colecaoIds;

    public TableModelSelecionaDeclaracaoPreenchimento(ColecaoIdDeclaracao pObj) {
        this.colecaoIds = pObj;
    }

    @Override
    public int getRowCount() {
        if (this.colecaoIds != null) {
            return this.colecaoIds.itens().size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.montaPainelTipo(rowIndex);
            }
            case 1: {
                return this.obtemInformacao(rowIndex, columnIndex);
            }
            case 2: {
                return this.obtemInformacao(rowIndex, columnIndex);
            }
            case 3: {
                return this.obtemInformacao(rowIndex, columnIndex);
            }
        }
        return "";
    }

    public IdentificadorDeclaracao getIdentificadorDeclaracao(int rowIndex) {
        IdentificadorDeclaracao id = (IdentificadorDeclaracao)this.colecaoIds.itens().get(rowIndex);
        return id;
    }

    private Object obtemInformacao(int rowIndex, int columnIndex) {
        IdentificadorDeclaracao idDeclaracao = this.getIdentificadorDeclaracao(rowIndex);
        String ajuste = "";
        ajuste = idDeclaracao.isEspolio() ? "Esp\u00f3lio" : (idDeclaracao.isSaida() ? "Sa\u00edda" : "Ajuste");
        switch (columnIndex) {
            case 1: {
                return ajuste;
            }
            case 2: {
                return idDeclaracao.getCpf().formatado();
            }
            case 3: {
                return idDeclaracao.getNome().formatado();
            }
        }
        return null;
    }

    private JPanel montaPainelTipo(int rowIndex) {
        final IdentificadorDeclaracao id = this.getIdentificadorDeclaracao(rowIndex);
        JPanel pnl = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public String toString() {
                return TableModelSelecionaDeclaracaoPreenchimento.this.obterNomeAcessivel(id);
            }
        };
        pnl.setLayout(new FlowLayout(0));
        pnl.setBackground(Color.WHITE);
        pnl.setAlignmentX(0.5f);
        if (id.isCompleta()) {
            pnl.add(new JLabel(GuiUtil.getImage("/icones/png16px/AB_completa.png")));
        } else {
            pnl.add(new JLabel(GuiUtil.getImage("/icones/png16px/AB_simplif.png")));
        }
        String retif = "";
        if (id.isOriginal()) {
            retif = "Original";
        } else if (id.isRetificadora()) {
            retif = "Retificadora";
        }
        pnl.add(new JLabel(retif));
        return pnl;
    }

    private String obterNomeAcessivel(IdentificadorDeclaracao id) {
        StringBuilder nomeAcessivel = new StringBuilder();
        nomeAcessivel.append("Declara\u00e7\u00e3o de ");
        if (id.isAjuste()) {
            nomeAcessivel.append("Ajuste Anual");
            if (id.isCompleta()) {
                nomeAcessivel.append(" Completa");
            } else {
                nomeAcessivel.append(" Simplificada");
            }
        } else if (id.isEspolio()) {
            nomeAcessivel.append("Final de Esp\u00f3lio");
        } else {
            nomeAcessivel.append("Sa\u00edda Definitiva do Pa\u00eds");
        }
        nomeAcessivel.append(" - ");
        nomeAcessivel.append("Contribuinte: " + id.getNome().naoFormatado());
        nomeAcessivel.append(" - ");
        nomeAcessivel.append("CPF: " + id.getCpf().naoFormatado());
        nomeAcessivel.append(" - ");
        nomeAcessivel.append(id.getDeclaracaoRetificadora().naoFormatado().equals(Logico.NAO) ? "Original" : "Retificadora");
        return nomeAcessivel.toString();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Tipo";
            }
            case 1: {
                return "A/E/S";
            }
            case 2: {
                return "CPF";
            }
            case 3: {
                return "Nome";
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void setColecaoIdDeclaracao(ColecaoIdDeclaracao col) {
        this.colecaoIds = col;
        this.fireTableDataChanged();
    }

    public void refresh() {
        this.fireTableDataChanged();
    }

    @Override
    public void addTableModelListener(TableModelListener pListener) {
        pListener.tableChanged(new TableModelEvent(this));
        super.addTableModelListener(pListener);
    }
}

