/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.componente;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.irpf.util.HTMLUtil;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class JEditLabel
extends JLabel
implements PropertyChangeListener {
    private WeakReference<JEditCampo> campoAssociado;
    private String textoOriginal;

    public JEditLabel() {
        this.iniciar();
    }

    public JEditLabel(Icon pImage) {
        super(pImage);
        this.iniciar();
    }

    public JEditLabel(String pTexto) {
        super(pTexto);
        this.iniciar();
    }

    public JEditLabel(Icon pImage, int pHorizontalAlignment) {
        super(pImage, pHorizontalAlignment);
        this.iniciar();
    }

    public JEditLabel(String pTexto, int pHorizontalAlignment) {
        super(pTexto, pHorizontalAlignment);
        this.iniciar();
    }

    public JEditLabel(String pTexto, Icon pImage, int pHorizontalAlignment) {
        super(pTexto, pImage, pHorizontalAlignment);
        this.iniciar();
    }

    protected void iniciar() {
        this.textoOriginal = this.getText();
        this.verificarRequerido();
    }

    protected void decorar() {
        String lLabelAtual = this.getText();
        if (!lLabelAtual.contains("*")) {
            this.setText("<html><p>" + HTMLUtil.removeHtmlTags((String)lLabelAtual) + "<span style=\"color: red;\"> *</span></p></html>");
            if (this.getToolTipText() == null) {
                this.setToolTipText("Campo Obrigat\u00f3rio");
            }
        }
    }

    private void verificarRequerido() {
        if (this.isCampoAssociadoRequerido()) {
            if (!this.isHabilitado()) {
                this.decorar();
            }
        } else {
            super.setText(this.textoOriginal);
        }
    }

    private boolean isCampoAssociadoRequerido() {
        if (this.campoAssociado != null) {
            List lListaValidadores = this.getCampoAssociado().getInformacao().getListaValidadores();
            for (ValidadorIf validadorIf : lListaValidadores) {
                if (!(validadorIf instanceof ValidadorNaoNulo)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isHabilitado() {
        boolean retorno = false;
        if (this.campoAssociado != null) {
            retorno = this.getCampoAssociado().getInformacao().isReadOnly();
        }
        return retorno;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.textoOriginal = this.getText();
        this.verificarRequerido();
    }

    public JEditCampo getCampoAssociado() {
        if (this.campoAssociado != null) {
            return (JEditCampo)this.campoAssociado.get();
        }
        return null;
    }

    public void setCampoAssociado(JEditCampo pCampoAssociado) {
        if (pCampoAssociado != null) {
            pCampoAssociado.addPropertyChangeListener((PropertyChangeListener)this);
            this.campoAssociado = new WeakReference<JEditCampo>(pCampoAssociado);
        } else {
            this.campoAssociado = null;
        }
        this.verificarRequerido();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("informacao".equals(evt.getPropertyName())) {
            this.verificarRequerido();
        }
    }
}

