/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.declaracao.assistida.informeplanosaude;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditAlfa;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.declaracao.assistida.informeplanosaude.ItemPagamentoPlanoSaude;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFLabelInfo;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Observador;

public class PainelItemPagamentosPlanoSaude
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int TIPO_CONTRIBUINTE_TITULAR = 0;
    public static final int TIPO_CONTRIBUINTE_DEPENDENTE = 1;
    public static final int TIPO_CONTRIBUINTE_ALIMENTANDO = 2;
    public static final int TIPO_CONTRIBUINTE_NAO_INFORMADO = 3;
    public static final int TIPO_CONTRIBUINTE_SEM_CORRESPONDENCIA = 4;
    private ItemPagamentoPlanoSaude pagamento;
    final List<ElementoTabela> dependentes = CadastroTabelasIRPF.recuperarDependentesInforme();
    final List<ElementoTabela> alimentandos = CadastroTabelasIRPF.recuperarAlimentandosInforme();
    private ButtonGroup btnGroupTipoContribuinte;
    private JAutoCompleteEditAlfa cmbDependenteAlimentando;
    private IRPFLabelInfo lblAvisoDependenteAlimentandoVazio;
    private JLabel lblCPFUsuario;
    private JLabel lblDespesaCom;
    private JLabel lblNomeUsuario;
    private JLabel lblOBSNaoImportar;
    private JLabel lblSelecaoDependenteAlimentando;
    private JLabel lblSeparador;
    private JLabel lblValorPago;
    private JPanel painelSelecaoTiposContribuintes;
    private JRadioButton rdAlimentando;
    private JRadioButton rdDependente;
    private JRadioButton rdTitular;

    public PainelItemPagamentosPlanoSaude(ItemPagamentoPlanoSaude pagamento, boolean ultimo) {
        this.pagamento = pagamento;
        this.pagamento.getCodigo().setConteudo("26");
        this.initComponents();
        this.lblSeparador.setVisible(!ultimo);
        this.preencherCampos();
    }

    private void preencherCampos() {
        int tipoContribuinte = this.obterTipoContribuinte(this.pagamento.getCpfBeneficiario().naoFormatado());
        this.lblDespesaCom.setText("<html><b>Despesa Realizada com " + this.getLabelTipoContribuinte("", tipoContribuinte) + "<html>");
        if (this.pagamento.getCpfBeneficiario().isVazio()) {
            this.lblCPFUsuario.setText("<html><b>CPF:</b>:<html>");
        } else {
            this.lblCPFUsuario.setText("<html><b>CPF " + this.getLabelTipoContribuinte("do", tipoContribuinte) + "</b>: " + this.pagamento.getCpfBeneficiario() + "<html>");
        }
        this.lblNomeUsuario.setText("<html><b>Nome " + this.getLabelTipoContribuinte("do", tipoContribuinte) + "</b>: " + this.pagamento.getNomeBeneficiario() + "<html>");
        if (tipoContribuinte == 3) {
            this.adicionarEventosRadioGroup();
            this.adicionarEventoCombo();
            this.cmbDependenteAlimentando.setVisible(false);
            this.exibirInfoListagemBeneficiario("1");
        } else {
            if (tipoContribuinte == 0) {
                this.pagamento.getTipoBeneficiario().setConteudo("1");
            } else if (tipoContribuinte == 1) {
                Dependente dependente = ControladorGui.getDemonstrativoAberto().getDependentes().getDependenteByCpf(this.pagamento.getCpfBeneficiario().naoFormatado());
                this.pagamento.getTipoBeneficiario().setConteudo("2");
                this.pagamento.getCpfBeneficiarioSelecionado().setConteudo(dependente.getCpfDependente().naoFormatado());
                this.pagamento.getNomeBeneficiarioSelecionado().setConteudo(dependente.getNome().naoFormatado());
            } else if (tipoContribuinte == 2) {
                Alimentando alimentando = ControladorGui.getDemonstrativoAberto().getAlimentandos().getAlimentandoByCpf(this.pagamento.getCpfBeneficiario().naoFormatado());
                this.pagamento.getTipoBeneficiario().setConteudo("3");
                this.pagamento.getCpfBeneficiarioSelecionado().setConteudo(alimentando.getCpf().naoFormatado());
                this.pagamento.getNomeBeneficiarioSelecionado().setConteudo(alimentando.getNome().naoFormatado());
            }
            this.painelSelecaoTiposContribuintes.setVisible(false);
        }
        this.lblValorPago.setText("<html><b>Valor Pago</b>: " + this.pagamento.getValorPago() + "<html>");
        if (tipoContribuinte == 4) {
            this.lblOBSNaoImportar.setVisible(true);
            this.pagamento.setImportar(false);
        } else {
            this.lblOBSNaoImportar.setVisible(false);
        }
    }

    private void exibirInfoListagemBeneficiario(String tipoBeneficiario) {
        if (tipoBeneficiario.equals("3")) {
            this.lblAvisoDependenteAlimentandoVazio.setVisible(true);
            this.lblAvisoDependenteAlimentandoVazio.setMensagem(MensagemUtil.getMensagem((String)"info_listagem", (String[])new String[]{"Alimentandos"}));
        } else if (tipoBeneficiario.equals("2")) {
            this.lblAvisoDependenteAlimentandoVazio.setVisible(true);
            this.lblAvisoDependenteAlimentandoVazio.setMensagem(MensagemUtil.getMensagem((String)"info_listagem", (String[])new String[]{"Dependentes"}));
        } else {
            this.lblAvisoDependenteAlimentandoVazio.setVisible(false);
            this.lblAvisoDependenteAlimentandoVazio.setMensagem("");
        }
    }

    private void adicionarEventosRadioGroup() {
        this.pagamento.getTipoBeneficiario().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelItemPagamentosPlanoSaude.this.validarBeneficiario();
            }
        });
        this.rdDependente.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PainelItemPagamentosPlanoSaude.this.cmbDependenteAlimentando.setDados(PainelItemPagamentosPlanoSaude.this.dependentes);
                    ((JComboBox)PainelItemPagamentosPlanoSaude.this.cmbDependenteAlimentando.getComponenteEditor()).setSelectedIndex(-1);
                    PainelItemPagamentosPlanoSaude.this.cmbDependenteAlimentando.setVisible(true);
                    PainelItemPagamentosPlanoSaude.this.pagamento.getTipoBeneficiario().setConteudo("2");
                    PainelItemPagamentosPlanoSaude.this.exibirInfoListagemBeneficiario("2");
                }
            }
        });
        this.rdAlimentando.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PainelItemPagamentosPlanoSaude.this.cmbDependenteAlimentando.setDados(PainelItemPagamentosPlanoSaude.this.alimentandos);
                    ((JComboBox)PainelItemPagamentosPlanoSaude.this.cmbDependenteAlimentando.getComponenteEditor()).setSelectedIndex(-1);
                    PainelItemPagamentosPlanoSaude.this.cmbDependenteAlimentando.setVisible(true);
                    PainelItemPagamentosPlanoSaude.this.pagamento.getTipoBeneficiario().setConteudo("3");
                    PainelItemPagamentosPlanoSaude.this.exibirInfoListagemBeneficiario("3");
                }
            }
        });
        this.rdTitular.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PainelItemPagamentosPlanoSaude.this.cmbDependenteAlimentando.setDados(new ArrayList());
                    ((JComboBox)PainelItemPagamentosPlanoSaude.this.cmbDependenteAlimentando.getComponenteEditor()).setSelectedIndex(-1);
                    PainelItemPagamentosPlanoSaude.this.cmbDependenteAlimentando.setVisible(false);
                    PainelItemPagamentosPlanoSaude.this.pagamento.getTipoBeneficiario().setConteudo("1");
                    PainelItemPagamentosPlanoSaude.this.exibirInfoListagemBeneficiario("1");
                }
            }
        });
    }

    private void validarBeneficiario() {
        this.pagamento.getTipoBeneficiario().validar();
        this.pagamento.getNomeBeneficiarioSelecionado().validar();
        if (this.pagamento.getTipoBeneficiario().isValido() && this.pagamento.getNomeBeneficiarioSelecionado().isValido()) {
            this.lblSelecaoDependenteAlimentando.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_verificar.png")));
        } else {
            this.lblSelecaoDependenteAlimentando.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/erro.png")));
        }
    }

    private void adicionarEventoCombo() {
        this.pagamento.getNomeBeneficiarioSelecionado().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelItemPagamentosPlanoSaude.this.validarBeneficiario();
            }
        });
        this.cmbDependenteAlimentando.getInformacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                String val = (String)valorNovo;
                if (!val.isEmpty() && !val.equals("-1")) {
                    String[] vals = val.split("\\|");
                    if (vals.length > 1) {
                        PainelItemPagamentosPlanoSaude.this.pagamento.getCpfBeneficiarioSelecionado().setConteudo(vals[0]);
                        PainelItemPagamentosPlanoSaude.this.pagamento.getNomeBeneficiarioSelecionado().setConteudo(vals[1]);
                    }
                } else {
                    PainelItemPagamentosPlanoSaude.this.pagamento.getCpfBeneficiarioSelecionado().clear();
                    PainelItemPagamentosPlanoSaude.this.pagamento.getNomeBeneficiarioSelecionado().clear();
                }
            }
        });
    }

    private String getLabelTipoContribuinte(String preposicao, int tipoContribuinte) {
        String espaco = "";
        if (preposicao.length() > 0) {
            espaco = " ";
        }
        if (tipoContribuinte == 0) {
            return preposicao + espaco + "Titular";
        }
        if (tipoContribuinte == 1) {
            return preposicao + espaco + "Dependente";
        }
        if (tipoContribuinte == 2) {
            return preposicao + espaco + "Alimentando";
        }
        return "";
    }

    private int obterTipoContribuinte(String cpf) {
        int tipoContribuinte = 4;
        if (cpf.length() == 0) {
            tipoContribuinte = 3;
        } else if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpf)) {
            tipoContribuinte = 0;
        } else if (ControladorGui.getDemonstrativoAberto().getDependentes().isExisteCpf(cpf)) {
            tipoContribuinte = 1;
        } else if (ControladorGui.getDemonstrativoAberto().getAlimentandos().isExisteCPF(cpf)) {
            tipoContribuinte = 2;
        }
        return tipoContribuinte;
    }

    private void initComponents() {
        this.btnGroupTipoContribuinte = new ButtonGroup();
        this.lblDespesaCom = new JLabel();
        this.lblCPFUsuario = new JLabel();
        this.lblNomeUsuario = new JLabel();
        this.lblSeparador = new JLabel();
        this.lblValorPago = new JLabel();
        this.lblOBSNaoImportar = new JLabel();
        this.painelSelecaoTiposContribuintes = new JPanel();
        this.rdDependente = new JRadioButton();
        this.rdAlimentando = new JRadioButton();
        this.lblSelecaoDependenteAlimentando = new JLabel();
        this.cmbDependenteAlimentando = new JAutoCompleteEditAlfa();
        this.rdTitular = new JRadioButton();
        this.lblAvisoDependenteAlimentandoVazio = new IRPFLabelInfo();
        this.btnGroupTipoContribuinte.add(this.rdDependente);
        this.btnGroupTipoContribuinte.add(this.rdAlimentando);
        this.btnGroupTipoContribuinte.add(this.rdTitular);
        this.setBackground(new Color(255, 255, 255));
        this.lblDespesaCom.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDespesaCom.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDespesaCom.setText("<html><b>Despesa Realizada com");
        this.lblDespesaCom.setAlignmentY(0.0f);
        this.lblCPFUsuario.setFont(FontesUtil.FONTE_NORMAL);
        this.lblCPFUsuario.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblCPFUsuario.setText("<html><b>CPF do Alimentando:");
        this.lblCPFUsuario.setAlignmentY(0.0f);
        this.lblNomeUsuario.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNomeUsuario.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNomeUsuario.setText("<html><b>Nome do Alimentando:");
        this.lblNomeUsuario.setAlignmentY(0.0f);
        this.lblSeparador.setFont(FontesUtil.FONTE_NORMAL);
        this.lblSeparador.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblSeparador.setText("                  ");
        this.lblSeparador.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, new Color(189, 189, 189)));
        this.lblValorPago.setFont(FontesUtil.FONTE_NORMAL);
        this.lblValorPago.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblValorPago.setText("<html><b>Valor Pago:");
        this.lblValorPago.setAlignmentY(0.0f);
        this.lblOBSNaoImportar.setFont(FontesUtil.FONTE_NORMAL);
        this.lblOBSNaoImportar.setForeground(new Color(234, 84, 84));
        this.lblOBSNaoImportar.setText("<html>OBS: Este Pagamento n\u00e3o ser\u00e1 importado pois o CPF presente no informe n\u00e3o corresponde ao Titular<br>ou a um Dependente ou Alimentando na declara\u00e7\u00e3o.</html>");
        this.painelSelecaoTiposContribuintes.setBackground(new Color(255, 255, 255));
        this.painelSelecaoTiposContribuintes.setBorder(null);
        this.rdDependente.setBackground(new Color(255, 255, 255));
        this.rdDependente.setFont(FontesUtil.FONTE_TITULO_MENOR);
        this.rdDependente.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.rdDependente.setText("Dependente");
        this.rdAlimentando.setBackground(new Color(255, 255, 255));
        this.rdAlimentando.setFont(FontesUtil.FONTE_TITULO_MENOR);
        this.rdAlimentando.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.rdAlimentando.setText("Alimentando");
        this.lblSelecaoDependenteAlimentando.setFont(FontesUtil.FONTE_NORMAL);
        this.lblSelecaoDependenteAlimentando.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblSelecaoDependenteAlimentando.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/erro.png")));
        this.lblSelecaoDependenteAlimentando.setText("Selecione a pessoa associada a este pagamento:");
        this.lblSelecaoDependenteAlimentando.setAlignmentY(0.0f);
        this.rdTitular.setBackground(new Color(255, 255, 255));
        this.rdTitular.setFont(FontesUtil.FONTE_TITULO_MENOR);
        this.rdTitular.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.rdTitular.setText("Titular");
        GroupLayout painelSelecaoTiposContribuintesLayout = new GroupLayout(this.painelSelecaoTiposContribuintes);
        this.painelSelecaoTiposContribuintes.setLayout(painelSelecaoTiposContribuintesLayout);
        painelSelecaoTiposContribuintesLayout.setHorizontalGroup(painelSelecaoTiposContribuintesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelSelecaoTiposContribuintesLayout.createSequentialGroup().addGroup(painelSelecaoTiposContribuintesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSelecaoDependenteAlimentando).addGroup(painelSelecaoTiposContribuintesLayout.createSequentialGroup().addComponent(this.rdTitular).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rdDependente).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rdAlimentando).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAvisoDependenteAlimentandoVazio, -2, -1, -2)).addComponent((Component)this.cmbDependenteAlimentando, -2, 588, -2)).addGap(0, 14, Short.MAX_VALUE)));
        painelSelecaoTiposContribuintesLayout.setVerticalGroup(painelSelecaoTiposContribuintesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelSelecaoTiposContribuintesLayout.createSequentialGroup().addGroup(painelSelecaoTiposContribuintesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(painelSelecaoTiposContribuintesLayout.createSequentialGroup().addComponent(this.lblSelecaoDependenteAlimentando, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(painelSelecaoTiposContribuintesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rdDependente).addComponent(this.rdAlimentando).addComponent(this.rdTitular))).addComponent(this.lblAvisoDependenteAlimentandoVazio, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.cmbDependenteAlimentando, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblNomeUsuario).addComponent(this.lblOBSNaoImportar, GroupLayout.Alignment.TRAILING).addComponent(this.painelSelecaoTiposContribuintes, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lblValorPago, -2, 240, -2).addGap(0, 362, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.lblDespesaCom, -2, 273, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblCPFUsuario))).addContainerGap()).addComponent(this.lblSeparador, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblValorPago, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDespesaCom, -2, 16, -2).addComponent(this.lblCPFUsuario, -2, 16, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNomeUsuario, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.painelSelecaoTiposContribuintes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblOBSNaoImportar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addComponent(this.lblSeparador)));
    }
}

