/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.declaracao.assistida.informerendimentos;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditAlfa;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.ItemPensaoAlimenticiaRendAcm;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Observador;

public class PainelItemPensaoAlimenticiaRendAcm
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ItemPensaoAlimenticiaRendAcm pensaoAlimenticia;
    private List<ElementoTabela> alimentandos = CadastroTabelasIRPF.recuperarAlimentandosInforme();
    private JAutoCompleteEditAlfa cmbAlimentando;
    private JLabel lblCPFAlimentando;
    private JLabel lblNomeAlimentando;
    private JLabel lblOBSNaoImportar;
    private JLabel lblSelecaoAlimentando;
    private JLabel lblSeparador;
    private JLabel lblValorPago;
    private JPanel painelSelecaoAlimentando;

    public PainelItemPensaoAlimenticiaRendAcm(ItemPensaoAlimenticiaRendAcm pensaoAlimenticia, boolean ultimo) {
        this.pensaoAlimenticia = pensaoAlimenticia;
        this.initComponents();
        this.lblSeparador.setVisible(!ultimo);
        this.preencherCampos();
        this.adcionarEventoOkCombo();
    }

    private void preencherCampos() {
        this.lblCPFAlimentando.setText("<html><b>CPF do Alimentando:</b> " + this.pensaoAlimenticia.getCpfAlimentando().formatado() + "</html>");
        this.lblNomeAlimentando.setText("<html><b>Nome do Alimentando:</b> " + this.pensaoAlimenticia.getAlimentando().formatado() + "</html>");
        this.lblValorPago.setText("<html><b>Valor Pago:</b> R$ " + this.pensaoAlimenticia.getValor().formatado() + "</html>");
        if (this.pensaoAlimenticia.getCpfAlimentando().isVazio()) {
            if (this.alimentandos.size() > 0) {
                this.cmbAlimentando.setDados(this.alimentandos);
                this.painelSelecaoAlimentando.setVisible(true);
            } else {
                this.painelSelecaoAlimentando.setVisible(false);
            }
        } else {
            Alimentando alimentando = ControladorGui.getDemonstrativoAberto().getAlimentandos().getAlimentandoByCpf(this.pensaoAlimenticia.getCpfAlimentando().naoFormatado());
            if (alimentando != null) {
                this.pensaoAlimenticia.getCpfAlimentandoSelecionado().setConteudo(alimentando.getCpf().naoFormatado());
                this.pensaoAlimenticia.getNomeAlimentandoSelecionado().setConteudo(alimentando.getNome().naoFormatado());
            }
            this.painelSelecaoAlimentando.setVisible(false);
        }
        this.lblOBSNaoImportar.setVisible(this.deveExibirOBS());
    }

    private void adcionarEventoOkCombo() {
        this.cmbAlimentando.getInformacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                String campo = (String)valorNovo;
                if (!campo.isEmpty() && !campo.equals("-1")) {
                    String[] campos = campo.split("\\|");
                    if (campos.length > 0) {
                        PainelItemPensaoAlimenticiaRendAcm.this.pensaoAlimenticia.getCpfAlimentandoSelecionado().setConteudo(campos[0]);
                        PainelItemPensaoAlimenticiaRendAcm.this.pensaoAlimenticia.getNomeAlimentandoSelecionado().setConteudo(campos[1]);
                    }
                } else {
                    PainelItemPensaoAlimenticiaRendAcm.this.pensaoAlimenticia.getCpfAlimentandoSelecionado().clear();
                    PainelItemPensaoAlimenticiaRendAcm.this.pensaoAlimenticia.getNomeAlimentandoSelecionado().clear();
                }
            }
        });
        ((JComboBox)this.cmbAlimentando.getComponenteEditor()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (((JComboBox)PainelItemPensaoAlimenticiaRendAcm.this.cmbAlimentando.getComponenteEditor()).getSelectedIndex() == -1) {
                    PainelItemPensaoAlimenticiaRendAcm.this.lblSelecaoAlimentando.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/erro.png")));
                } else {
                    PainelItemPensaoAlimenticiaRendAcm.this.lblSelecaoAlimentando.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_verificar.png")));
                }
            }
        });
    }

    private boolean deveExibirOBS() {
        boolean deveExibir = false;
        if (!this.pensaoAlimenticia.getCpfAlimentando().isVazio()) {
            if (!ControladorGui.getDemonstrativoAberto().getAlimentandos().isExisteCPF(this.pensaoAlimenticia.getCpfAlimentando().naoFormatado())) {
                deveExibir = true;
                this.pensaoAlimenticia.setImportar(false);
            }
        } else if (this.alimentandos.size() == 0) {
            deveExibir = true;
            this.pensaoAlimenticia.setImportar(false);
        }
        return deveExibir;
    }

    private void initComponents() {
        this.lblCPFAlimentando = new JLabel();
        this.lblNomeAlimentando = new JLabel();
        this.lblValorPago = new JLabel();
        this.lblSeparador = new JLabel();
        this.lblOBSNaoImportar = new JLabel();
        this.painelSelecaoAlimentando = new JPanel();
        this.lblSelecaoAlimentando = new JLabel();
        this.cmbAlimentando = new JAutoCompleteEditAlfa();
        this.setBackground(new Color(255, 255, 255));
        this.lblCPFAlimentando.setFont(FontesUtil.FONTE_NORMAL);
        this.lblCPFAlimentando.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblCPFAlimentando.setText("<html><b>CPF do Alimentando:");
        this.lblCPFAlimentando.setAlignmentY(0.0f);
        this.lblNomeAlimentando.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNomeAlimentando.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNomeAlimentando.setText("<html><b>Nome do Alimentando:");
        this.lblNomeAlimentando.setAlignmentY(0.0f);
        this.lblValorPago.setFont(FontesUtil.FONTE_NORMAL);
        this.lblValorPago.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblValorPago.setText("<html><b>Valor Pago:");
        this.lblValorPago.setAlignmentY(0.0f);
        this.lblSeparador.setFont(FontesUtil.FONTE_NORMAL);
        this.lblSeparador.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblSeparador.setText("                  ");
        this.lblSeparador.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, new Color(189, 189, 189)));
        this.lblOBSNaoImportar.setFont(FontesUtil.FONTE_NORMAL);
        this.lblOBSNaoImportar.setForeground(new Color(234, 84, 84));
        this.lblOBSNaoImportar.setText("OBS: Este Pagamento de pens\u00e3o aliment\u00edcia n\u00e3o ser\u00e1 importado por n\u00e3o existir alimentando correspondente na declara\u00e7\u00e3o.");
        this.painelSelecaoAlimentando.setBackground(new Color(255, 255, 255));
        this.painelSelecaoAlimentando.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.lblSelecaoAlimentando.setFont(FontesUtil.FONTE_NORMAL);
        this.lblSelecaoAlimentando.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblSelecaoAlimentando.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/erro.png")));
        this.lblSelecaoAlimentando.setText("Selecione o Alimentando para esta Pens\u00e3o Aliment\u00edcia:");
        this.lblSelecaoAlimentando.setAlignmentY(0.0f);
        GroupLayout painelSelecaoAlimentandoLayout = new GroupLayout(this.painelSelecaoAlimentando);
        this.painelSelecaoAlimentando.setLayout(painelSelecaoAlimentandoLayout);
        painelSelecaoAlimentandoLayout.setHorizontalGroup(painelSelecaoAlimentandoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelSelecaoAlimentandoLayout.createSequentialGroup().addGroup(painelSelecaoAlimentandoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSelecaoAlimentando).addComponent((Component)this.cmbAlimentando, -2, 589, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        painelSelecaoAlimentandoLayout.setVerticalGroup(painelSelecaoAlimentandoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelSelecaoAlimentandoLayout.createSequentialGroup().addComponent(this.lblSelecaoAlimentando, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cmbAlimentando, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSeparador, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.painelSelecaoAlimentando, -1, -1, Short.MAX_VALUE).addComponent(this.lblOBSNaoImportar, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblCPFAlimentando, -2, 234, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNomeAlimentando, -2, 377, -2)).addComponent(this.lblValorPago, -2, 184, -2)).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCPFAlimentando, -2, 16, -2).addComponent(this.lblNomeAlimentando, -2, 16, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblValorPago, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.painelSelecaoAlimentando, -2, -1, -2).addGap(18, 18, 18).addComponent(this.lblOBSNaoImportar).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblSeparador)));
    }
}

