/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import serpro.ppgd.app.acoes.LoginGovAction;
import serpro.ppgd.app.acoes.LogoutGovAction;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.NavegadorHtml;
import serpro.ppgd.irpf.gui.listener.LoginGovListener;
import serpro.ppgd.irpf.gui.listener.TabelasAtualizadasListener;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.nuvem.UsuarioLogado;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.CodigoTabelaLinks;
import serpro.ppgd.irpf.tabelas.CodigoTabelaMensagens;
import serpro.ppgd.negocio.ElementoTabela;

public class PainelAbaBemVindos
extends JPanel
implements LoginGovListener,
TabelasAtualizadasListener {
    private static final long serialVersionUID = 1L;
    private JButton btnLoginGov;
    private JButton btnLogoutGov;
    private JPanel pnlLinks;
    private JEditorPane pnlPaginaRFB;
    private JScrollPane scrollPaginaRFB;

    public PainelAbaBemVindos() {
        this.initComponents();
        this.atualizarBotaoLoginGov(BarramentoIRPFService.getUsuarioLogado() != null);
        ControladorGui.addLoginGovListener(this);
        ControladorGui.addTabelasAtualizadasListener(this);
        this.atualizarLinksUteis();
        this.pnlPaginaRFB.addHyperlinkListener(e -> {
            try {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    NavegadorHtml.executarNavegador(e.getURL().toString());
                }
            }
            catch (IOException ex) {
                GuiUtil.mostrarErro(ex);
            }
        });
        this.pnlPaginaRFB.getAccessibleContext().setAccessibleDescription(CadastroTabelasIRPF.recuperarMensagemHTML((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00503));
    }

    public void atualizarLinksUteis() {
        this.pnlLinks.removeAll();
        this.adicionarLink(CodigoTabelaLinks.CODIGO_LinkPGDIRPF1);
        this.adicionarLink(CodigoTabelaLinks.CODIGO_LinkPGDIRPF2);
        this.adicionarLink(CodigoTabelaLinks.CODIGO_LinkPGDIRPF3);
        this.adicionarLink(CodigoTabelaLinks.CODIGO_LinkPGDIRPF4);
        this.adicionarLink(CodigoTabelaLinks.CODIGO_LinkPGDIRPF5);
        this.adicionarLink(CodigoTabelaLinks.CODIGO_LinkPGDIRPF6);
    }

    public void atualizarMensagemRFB() {
        this.pnlPaginaRFB.setText(CadastroTabelasIRPF.recuperarMensagemHTML((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00503));
    }

    private void adicionarLink(String descricao, final String link) {
        final JButton btnLink = new JButton("<html><body><p>&#9659; <font color=\"#57B8ED\"><strong>" + descricao + "</strong></font></p></body></html>");
        btnLink.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        btnLink.setContentAreaFilled(false);
        btnLink.setCursor(new Cursor(12));
        btnLink.setHorizontalAlignment(2);
        btnLink.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                btnLink.setBorder(BorderFactory.createDashedBorder(null));
            }

            @Override
            public void focusLost(FocusEvent evt) {
                btnLink.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        });
        btnLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NavegadorHtml.executarNavegadorComMsgErro(link);
            }
        });
        this.pnlLinks.add(btnLink);
    }

    private void adicionarLink(CodigoTabelaLinks codigo) {
        ElementoTabela et = CadastroTabelasIRPF.recuperarLink((CodigoTabelaLinks)codigo);
        if (et != null) {
            this.adicionarLink(et.getConteudo(1), et.getConteudo(2));
        }
    }

    public void atualizarBotaoLoginGov(boolean usuarioLogado) {
        this.btnLoginGov.setVisible(!usuarioLogado);
        this.btnLogoutGov.setVisible(usuarioLogado);
    }

    private void initComponents() {
        this.pnlLinks = new JPanel();
        this.scrollPaginaRFB = new JScrollPane();
        this.pnlPaginaRFB = new JEditorPane();
        this.btnLoginGov = new JButton();
        this.btnLogoutGov = new JButton();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.pnlLinks.setBackground(new Color(254, 254, 254));
        this.pnlLinks.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "Links \u00fateis", 1, 2, new Font("Dialog", 1, 14), new Color(0, 74, 106)), BorderFactory.createEmptyBorder(10, 10, 1, 1)));
        this.pnlLinks.setLayout(new BoxLayout(this.pnlLinks, 3));
        this.scrollPaginaRFB.setBackground(new Color(254, 254, 254));
        this.scrollPaginaRFB.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.scrollPaginaRFB.setHorizontalScrollBarPolicy(31);
        this.scrollPaginaRFB.setViewportBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.pnlPaginaRFB.setEditable(false);
        this.pnlPaginaRFB.setBackground(new Color(254, 254, 254));
        this.pnlPaginaRFB.setContentType("text/html");
        this.pnlPaginaRFB.setText(CadastroTabelasIRPF.recuperarMensagemHTML((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00503));
        this.pnlPaginaRFB.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PainelAbaBemVindos.this.pnlPaginaRFBFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PainelAbaBemVindos.this.pnlPaginaRFBFocusLost(evt);
            }
        });
        this.scrollPaginaRFB.setViewportView(this.pnlPaginaRFB);
        this.pnlPaginaRFB.getAccessibleContext().setAccessibleName("Mensagem");
        this.pnlPaginaRFB.getAccessibleContext().setAccessibleDescription("");
        this.btnLoginGov.setBackground(new Color(241, 245, 249));
        this.btnLoginGov.setIcon(GuiUtil.getImage("/icones/png40px/login-gov-40px.png"));
        this.btnLoginGov.setText("");
        this.btnLoginGov.setToolTipText("<html><body>\n<p>\nUtilize sua conta <strong>gov.br</strong> para acessar as seguintes funcionalidades do IRPF:\n<ul style=\"list-style-type:square\">\n<li>Obter a declara\u00e7\u00e3o <strong>pr\u00e9-preenchida</strong>;</li>\n<li>Importar informa\u00e7\u00f5es do <strong>Carn\u00ea-le\u00e3o</strong>;</li>\n<li><strong>Salvar / Recuperar</strong> on-line declara\u00e7\u00e3o em preenchimento.</li>\n\n</ul>\n</p>\n</body></html>");
        this.btnLoginGov.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.btnLoginGov.setContentAreaFilled(false);
        this.btnLoginGov.setCursor(new Cursor(0));
        this.btnLoginGov.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PainelAbaBemVindos.this.btnLoginGovFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PainelAbaBemVindos.this.btnLoginGovFocusLost(evt);
            }
        });
        this.btnLoginGov.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelAbaBemVindos.this.btnLoginGovActionPerformed(evt);
            }
        });
        this.btnLogoutGov.setBackground(new Color(241, 245, 249));
        this.btnLogoutGov.setIcon(GuiUtil.getImage("/icones/png20px/logout-24px.png"));
        this.btnLogoutGov.setText("<html><body>Sair do <strong>gov.br</strong></body></html>");
        this.btnLogoutGov.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.btnLogoutGov.setContentAreaFilled(false);
        this.btnLogoutGov.setCursor(new Cursor(0));
        this.btnLogoutGov.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PainelAbaBemVindos.this.btnLogoutGovFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PainelAbaBemVindos.this.btnLogoutGovFocusLost(evt);
            }
        });
        this.btnLogoutGov.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelAbaBemVindos.this.btnLogoutGovActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPaginaRFB, -2, 444, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 47, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnLogoutGov, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLoginGov).addGap(24, 24, 24)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.pnlLinks, -2, 279, -2).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scrollPaginaRFB).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnLoginGov).addComponent(this.btnLogoutGov, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.pnlLinks, -1, 237, Short.MAX_VALUE))).addContainerGap()));
    }

    private void btnLoginGovFocusGained(FocusEvent evt) {
        this.btnLoginGov.setBorder(BorderFactory.createDashedBorder(null));
    }

    private void btnLoginGovFocusLost(FocusEvent evt) {
        this.btnLoginGov.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    private void btnLoginGovActionPerformed(ActionEvent evt) {
        new LoginGovAction().executarAcao(null);
    }

    private void btnLogoutGovFocusGained(FocusEvent evt) {
        this.btnLogoutGov.setBorder(BorderFactory.createDashedBorder(null));
    }

    private void btnLogoutGovFocusLost(FocusEvent evt) {
        this.btnLogoutGov.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    private void btnLogoutGovActionPerformed(ActionEvent evt) {
        new LogoutGovAction().executarAcao(null);
    }

    private void pnlPaginaRFBFocusGained(FocusEvent evt) {
        this.scrollPaginaRFB.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createDashedBorder(null)));
    }

    private void pnlPaginaRFBFocusLost(FocusEvent evt) {
        this.scrollPaginaRFB.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
    }

    @Override
    public void usuarioLogado(UsuarioLogado usuario) {
        this.atualizarBotaoLoginGov(true);
        this.btnLogoutGov.requestFocusInWindow();
    }

    @Override
    public void usuarioDeslogado() {
        this.atualizarBotaoLoginGov(false);
        this.btnLoginGov.requestFocusInWindow();
    }

    @Override
    public void tabelasAtualizadas() {
        this.atualizarMensagemRFB();
        this.atualizarLinksUteis();
    }
}

