/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTML;
import serpro.ppgd.irpf.gui.NavegadorHtml;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class PainelHtmlText
extends JPanel {
    private JButton btnOK;
    private JScrollPane scrollPane;
    private JTextPane textPane;

    public PainelHtmlText(String msg) {
        this.setUpComponents(msg, 500, 300);
    }

    public PainelHtmlText(String msg, int legth, int height) {
        this.setUpComponents(msg, legth, height);
    }

    private void setUpComponents(String msg, int legth, int height) {
        this.initComponents();
        this.setPreferredSize(new Dimension(legth, height));
        StringBuilder msgFinal = new StringBuilder();
        msgFinal.append("<html><head><style>.roboto {font-family: Roboto; font-size: 10px;}.mac {font-family: Helvetica; font-size: 10px;}</style></head><body>");
        if (FabricaUtilitarios.isMac()) {
            msgFinal.append("<div class=\"mac\">");
        } else {
            msgFinal.append("<div class=\"roboto\">");
        }
        msgFinal.append(msg.replaceAll("&lt;", "<").replaceAll("&gt;", ">"));
        msgFinal.append("</div></body></html>");
        this.textPane.setEditable(false);
        this.textPane.setText(msgFinal.toString());
        this.textPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PainelHtmlText.this.textPane.getSelectionStart() == PainelHtmlText.this.textPane.getSelectionEnd()) {
                    int offset = PainelHtmlText.this.textPane.viewToModel(e.getPoint());
                    try {
                        StyledDocument doc = PainelHtmlText.this.textPane.getStyledDocument();
                        Element elem = doc.getCharacterElement(offset);
                        AttributeSet attr = elem.getAttributes();
                        SimpleAttributeSet tag = (SimpleAttributeSet)attr.getAttribute(HTML.Tag.A);
                        if (tag != null) {
                            String link = tag.toString().replace("href=", "").trim();
                            NavegadorHtml.executarNavegadorComMsgErro(link);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PainelHtmlText.this.scrollPane.getVerticalScrollBar().setValue(0);
            }
        });
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                    PainelHtmlText.this.btnOK.requestFocus();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.textPane = new JTextPane();
        this.btnOK = new JButton();
        this.setBackground(new Color(241, 245, 249));
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.textPane.setBackground(new Color(241, 245, 249));
        this.textPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.textPane.setContentType("text/html");
        this.scrollPane.setViewportView(this.textPane);
        this.btnOK.setText("Ok");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelHtmlText.this.btnOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 394, Short.MAX_VALUE).addComponent(this.btnOK, -2, 80, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, 234, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnOK).addContainerGap()));
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }
}

