/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.ColecaoIdDeclaracao;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.exception.BarramentoException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.TableModelSelecionaDeclaracaoTransmitida;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesTransmitidas;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.PainelDownloads;
import serpro.ppgd.irpf.gui.util.PdfUtil;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.tabelas.TabelaDatasIRPF;
import serpro.ppgd.irpf.txt.gravacaorestauracao.RepositorioDeclaracaoCentralTxt;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.irpf.util.DataUtil;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.Validador;

public class PainelImprimirDARFMaed
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Imprimir Darf de Multa por Atraso na Entrega";
    private File dirSelecionado = new File(UtilitariosArquivo.getPathTransmitidas());
    private List<RepositorioDeclaracaoCentralTxt> repositorios;
    private boolean cancelou;
    private JButton btnAjuda;
    private JButton btnImprimir;
    private JButton btnSair;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JRadioButton rbImprimir;
    private JRadioButton rbVisualizar;
    private SubpainelDeclaracoesTransmitidas subpainelDeclaracoesTransmitidas;

    public PainelImprimirDARFMaed() {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
        this.atualizaTextoDirSelecionado();
        this.configurarPainelDeclaracoes();
    }

    private void configurarPainelDeclaracoes() {
        this.subpainelDeclaracoesTransmitidas.getTabela().setSelectionMode(0);
        this.subpainelDeclaracoesTransmitidas.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelImprimirDARFMaed.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirDARFMaed.this.btnImprimir.setEnabled(true);
                } else {
                    PainelImprimirDARFMaed.this.btnImprimir.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesTransmitidas.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelImprimirDARFMaed.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirDARFMaed.this.btnImprimirActionPerformed(null);
                }
            }
        });
    }

    public PainelImprimirDARFMaed(boolean salvarImagem) {
        this();
        if (salvarImagem) {
            this.jLabel1.setText("Selecione a declara\u00e7\u00e3o para salvar o recibo:");
            this.rbImprimir.setVisible(false);
            this.rbVisualizar.setSelected(true);
        }
    }

    private void atualizaTextoDirSelecionado() {
        String caminhoGravacao = this.dirSelecionado.getPath();
        if (System.getProperty("os.name").startsWith("Windows")) {
            caminhoGravacao = caminhoGravacao.replaceFirst("/", "");
        }
        TableModelSelecionaDeclaracaoTransmitida model = (TableModelSelecionaDeclaracaoTransmitida)this.subpainelDeclaracoesTransmitidas.getTabela().getModel();
        model.setColecaoIdDeclaracao(this.obtemListaDeclaracoesGravadas(this.dirSelecionado.getPath()));
        model.setPathGravadas(this.dirSelecionado.getPath());
        model.setPathTransmitidas(this.dirSelecionado.getPath());
    }

    private ColecaoIdDeclaracao obtemListaDeclaracoesGravadas(String path) {
        File dir = new File(path);
        FilenameFilter filterREC = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean retorno = Validador.validarString((String)name, (String)ConstantesGlobaisIRPF.PADRAO_NOME_ARQ_RECIBO) || Validador.validarString((String)name, (String)"\\d{8}.(REC|rec)");
                return retorno;
            }
        };
        File[] filesREC = dir.listFiles(filterREC);
        this.repositorios = new ArrayList<RepositorioDeclaracaoCentralTxt>();
        ColecaoIdDeclaracao ids = new ColecaoIdDeclaracao();
        if (filesREC != null) {
            RepositorioDeclaracaoCentralTxt repositorioRecibo = null;
            RegistroTxt registroRecibo = null;
            String cpfDec = null;
            for (int i = 0; i < filesREC.length; ++i) {
                String nomeFileREC = filesREC[i].getName();
                try {
                    repositorioRecibo = new RepositorioDeclaracaoCentralTxt("ARQ_COMPLRECIBO", new File(path + File.separator + nomeFileREC));
                    registroRecibo = repositorioRecibo.recuperarRegistroComplementoRecibo();
                    if (repositorioRecibo.recuperarRegistroComplementoReciboMulta() == null) continue;
                    cpfDec = registroRecibo.fieldByName("NR_CPF").asString();
                    if (cpfDec == null || cpfDec.trim().length() == 0) {
                        JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "Imprimir recibo - Erro ao ler arquivo do recibo.", "Imprimir Recibo", 0);
                    }
                }
                catch (GeracaoTxtException e) {
                    LogPPGD.erro((String)e.getMessage());
                    JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "<HTML>O Arquivo<BR>" + repositorioRecibo.getPath() + "<BR>est\u00e1 corrompido:<BR>" + e.getMessage() + "</HTML>", "Imprimir Recibo", 0);
                }
                catch (IOException e) {
                    LogPPGD.erro((String)e.getMessage());
                    JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "<HTML>Ocorreu um erro inesperado:<BR>" + e.getMessage() + "</HTML>", "Imprimir Recibo", 0);
                }
                File fileDEC = this.getArquivoDec(path, dir, nomeFileREC);
                if (!fileDEC.exists()) continue;
                try {
                    RepositorioDeclaracaoCentralTxt repDeclaracao = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", fileDEC);
                    repDeclaracao.validarDeclaracaoNaoPersistido();
                    ids.itens().add(repDeclaracao.recuperarIdDeclaracaoNaoPersistido(true));
                    this.repositorios.add(repDeclaracao);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "<HTML>Ocorreu um erro inesperado:<BR>" + e.getMessage() + "</HTML>", "Imprimir Recibo", 0);
                    continue;
                }
                catch (GeracaoTxtException e) {
                    JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "<HTML>O Arquivo<BR>" + fileDEC.getPath() + "<BR>est\u00e1 corrompido:<BR>" + e.getMessage() + "</HTML>", "Erro", 0);
                    continue;
                }
                catch (IOException e) {
                    LogPPGD.erro((String)e.getMessage());
                    JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "<HTML>Ocorreu um erro inesperado:<BR>" + e.getMessage() + "</HTML>", "Imprimir Recibo", 0);
                }
            }
        }
        return ids;
    }

    private File getArquivoDec(String path, File dir, String nomeFileRec) {
        String nomeFileDec = null;
        File retorno = null;
        if (nomeFileRec.length() > 12) {
            nomeFileDec = nomeFileRec.substring(0, nomeFileRec.length() - 4) + ".DEC";
            retorno = new File(path + File.separator + nomeFileDec);
        } else {
            FilenameFilter filterDEC = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean retorno = Validador.validarString((String)name, (String)ConstantesGlobaisIRPF.PADRAO_NOME_ARQ_DECLARACAO);
                    return retorno;
                }
            };
            File[] files = dir.listFiles(filterDEC);
            File fileDecMaisAtual = null;
            for (int i = 0; i < files.length; ++i) {
                String nomeArqDecAtual = files[i].getName();
                if (fileDecMaisAtual != null && fileDecMaisAtual.lastModified() > files[i].lastModified() || !nomeArqDecAtual.substring(0, 8).equals(nomeFileRec.subSequence(0, 8))) continue;
                fileDecMaisAtual = files[i];
            }
            retorno = fileDecMaisAtual;
            if (retorno == null) {
                nomeFileDec = nomeFileRec.substring(0, nomeFileRec.length() - 4) + ".DEC";
                retorno = new File(path + File.separator + nomeFileDec);
            }
        }
        return retorno;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.btnImprimir = new JButton();
        this.btnSair = new JButton();
        this.btnAjuda = new JButton();
        this.rbImprimir = new JRadioButton();
        this.rbVisualizar = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.subpainelDeclaracoesTransmitidas = new SubpainelDeclaracoesTransmitidas();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Selecione a declara\u00e7\u00e3o para imprimir o Darf de Multa por Atraso na Entrega:");
        this.jPanel1.setBackground(new Color(241, 245, 249));
        this.jPanel1.setForeground(new Color(255, 255, 255));
        this.btnImprimir.setMnemonic('o');
        this.btnImprimir.setText("Ok");
        this.btnImprimir.setEnabled(false);
        this.btnImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirDARFMaed.this.btnImprimirActionPerformed(evt);
            }
        });
        this.btnSair.setMnemonic('c');
        this.btnSair.setText("Cancelar");
        this.btnSair.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirDARFMaed.this.btnSairActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        this.rbImprimir.setBackground(new Color(241, 245, 249));
        this.buttonGroup1.add(this.rbImprimir);
        this.rbImprimir.setFont(FontesUtil.FONTE_NORMAL);
        this.rbImprimir.setText("Imprimir");
        this.rbVisualizar.setBackground(new Color(241, 245, 249));
        this.buttonGroup1.add(this.rbVisualizar);
        this.rbVisualizar.setFont(FontesUtil.FONTE_NORMAL);
        this.rbVisualizar.setSelected(true);
        this.rbVisualizar.setText("Visualizar");
        this.jLabel2.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel2.setForeground(new Color(0, 74, 106));
        this.jLabel2.setText("Selecione a op\u00e7\u00e3o desejada:");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.rbVisualizar).add((Component)this.rbImprimir).add((Component)this.jLabel2))).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.btnSair).add((Component)this.btnAjuda).add(2, (Component)this.btnImprimir, -2, 97, -2)).add(0, 0, Short.MAX_VALUE)))));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnImprimir, this.btnSair}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).addPreferredGap(1).add((Component)this.rbVisualizar).addPreferredGap(0).add((Component)this.rbImprimir).addPreferredGap(0, 41, Short.MAX_VALUE).add((Component)this.btnImprimir).addPreferredGap(0).add((Component)this.btnSair).addPreferredGap(0).add((Component)this.btnAjuda).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnImprimir, this.btnSair}, 2);
        this.btnImprimir.getAccessibleContext().setAccessibleName("OK");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.subpainelDeclaracoesTransmitidas, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.subpainelDeclaracoesTransmitidas, -1, 408, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.jLabel1.getAccessibleContext().setAccessibleName("Selecione os declara\u00e7\u00f5es para imprimir o recibo. Para colocar o foco na tabela de declara\u00e7\u00f5es, aperte a tecla TAB, e utilize as setas para cima e para baixo para navegar pelas declara\u00e7\u00f5es.");
    }

    private void btnImprimirActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
        int[] linhasSelecionadas = this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRows();
        int[] rows = new int[linhasSelecionadas.length];
        for (int a = 0; a < rows.length; ++a) {
            rows[a] = ((TableRowSorter)this.subpainelDeclaracoesTransmitidas.getTabela().getRowSorter()).convertRowIndexToModel(linhasSelecionadas[a]);
        }
        for (int i = 0; i < rows.length; ++i) {
            int linha = rows[i];
            if (linha == -1) continue;
            this.imprimirRecibo(linha);
        }
    }

    private void btnSairActionPerformed(ActionEvent evt) {
        this.cancelou = true;
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    public int getTipoOperacao() {
        if (this.rbVisualizar.isSelected()) {
            return 1;
        }
        if (this.rbImprimir.isSelected()) {
            return 3;
        }
        return 0;
    }

    public void imprimirRecibo(int linhaSelecionada) {
        try {
            RepositorioDeclaracaoCentralTxt repDecl = this.repositorios.get(linhaSelecionada);
            if (repDecl != null) {
                RegistroTxt registroRecibo = repDecl.recuperarRegistroRecibo();
                String tipo = registroRecibo.fieldByName("IN_RETIFICADORA").asBoolean() ? "retif" : "origi";
                String cpf = registroRecibo.fieldByName("NR_CPF").asString();
                String arqDEC = repDecl.getPath();
                int indiceUltimoSeparador = arqDEC.lastIndexOf(File.separator);
                Object arqREC = arqDEC.substring(0, arqDEC.length() - 4) + ".REC";
                File fileDec = new File(arqDEC);
                File fileRec = new File((String)arqREC);
                if (!fileRec.exists()) {
                    arqREC = arqDEC.substring(0, indiceUltimoSeparador + 1);
                    arqREC = (String)arqREC + cpf.substring(0, 8);
                    arqREC = (String)arqREC + ".REC";
                    fileRec = new File((String)arqREC);
                }
                PainelImprimirDARFMaed.exibirDarfMaed(tipo, cpf, fileDec, fileRec);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "<HTML>Ocorreu um erro inesperado:<BR>" + e.getMessage() + "</HTML>", "Imprimir Recibo", 0);
        }
    }

    public static void exibirDarfMaed(final String tipoDec, final String cpfContribuinte, final File fileDec, final File fileRec) {
        final PainelDownloads painelDownlodas = new PainelDownloads("Darf de Maed", null);
        final SwingWorker<byte[], Integer> sw = new SwingWorker<byte[], Integer>(){

            @Override
            protected byte[] doInBackground() throws Exception {
                this.publish(new Integer[0]);
                return PainelImprimirDARFMaed.obterPdfDarfMaed(fileDec, fileRec);
            }

            @Override
            protected void process(List<Integer> chunks) {
                painelDownlodas.getLblDescricao().setText("Obtendo Darf de Maed");
            }

            @Override
            protected void done() {
                if (this.isCancelled()) {
                    GuiUtil.mostrarAviso(GuiUtil.getParent(), "OperacaoCancelada pelo usu\u00e1rio");
                } else {
                    try {
                        GuiUtil.fecharDialog(painelDownlodas);
                        byte[] darf = (byte[])this.get();
                        String nomeArq = IRPFUtil.obterNomeArquivoPDF((String)cpfContribuinte, (String)tipoDec, (String)"darfmultaatraso", null);
                        PdfUtil.exibirPdf(darf, "Darf - Maed", new File(FileSystemView.getFileSystemView().getDefaultDirectory(), nomeArq).getAbsolutePath());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        Throwable cause = e.getCause();
                        if (cause != null && (cause instanceof AplicacaoException || cause instanceof BarramentoException)) {
                            GuiUtil.mostrarErro(GuiUtil.getParent(), cause.getMessage());
                        }
                        GuiUtil.mostrarErro(GuiUtil.getParent(), "Ocorreu um erro durante a gera\u00e7\u00e3o do Darf");
                    }
                }
            }
        };
        painelDownlodas.getBtnCancelar().setAction(new AbstractAction("Cancelar"){

            @Override
            public void actionPerformed(ActionEvent e) {
                sw.cancel(true);
                GuiUtil.fecharDialog(painelDownlodas);
            }
        });
        sw.execute();
        GuiUtil.exibeDialog(painelDownlodas, true, "Imprimir Darf", false);
    }

    public static byte[] obterPdfDarfMaed(File arquivoDeclaracao, File arquivoRecibo) throws AplicacaoException, BarramentoException {
        try {
            RegistroTxt registroEspolio;
            String codigoMunicipio;
            RepositorioDeclaracaoCentralTxt repositorioDeclaracao = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", arquivoDeclaracao);
            IdentificadorDeclaracao idDecl = repositorioDeclaracao.recuperarIdDeclaracao(true);
            boolean emCalamidade = false;
            if (ControladorGui.getDemonstrativoAberto() != null) {
                if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().getCpf().naoFormatado().equals(idDecl.getCpf().naoFormatado())) {
                    emCalamidade = ControladorGui.getDemonstrativoAberto().getEmCalamidade();
                    codigoMunicipio = ControladorGui.getDemonstrativoAberto().getContribuinte().getMunicipio().naoFormatado();
                } else {
                    GuiUtil.mostrarAviso("fecharDeclaracaoExecutarOperacao");
                    ControladorGui.fecharDemonstrativo();
                    IRPFFacade.abreDeclaracao((IdentificadorDeclaracao)idDecl);
                    emCalamidade = IRPFFacade.getInstancia().getDeclaracao().getEmCalamidade();
                    codigoMunicipio = IRPFFacade.getInstancia().getDeclaracao().getContribuinte().getMunicipio().naoFormatado();
                }
            } else {
                IRPFFacade.abreDeclaracao((IdentificadorDeclaracao)idDecl);
                emCalamidade = IRPFFacade.getInstancia().getDeclaracao().getEmCalamidade();
                codigoMunicipio = IRPFFacade.getInstancia().getDeclaracao().getContribuinte().getMunicipio().naoFormatado();
            }
            String dataReaberturaEntrega = TabelaDatasIRPF.obterDataReaberturaEntregaFormatada((boolean)emCalamidade);
            RepositorioDeclaracaoCentralTxt repositorioRecibo = new RepositorioDeclaracaoCentralTxt("ARQ_COMPLRECIBO", arquivoRecibo);
            RegistroTxt registroMulta = repositorioRecibo.recuperarRegistroComplementoReciboMulta();
            repositorioRecibo.validarComplementoRecibo(idDecl);
            Data dtVenc = new Data();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            dtVenc.setConteudo(sdf.parse(registroMulta.fieldByName("DT_VENCIMENTO").asString()));
            Data dtPA = new Data();
            if (idDecl.isEspolio() && (registroEspolio = repositorioDeclaracao.recuperarRegistroFinalEspolio()).fieldByName("IN_TIPO_PROCESSO").asString().equals("J")) {
                Data dataTransitoJulgado = new Data();
                dataTransitoJulgado.setConteudo(registroEspolio.fieldByName("DT_TRANSITOJULGADO").asString());
                Data data = new Data();
                data.setConteudo("01/03/" + ConstantesGlobais.EXERCICIO);
                if (dataTransitoJulgado.maisAntiga(data)) {
                    dtPA.setConteudo(dataReaberturaEntrega);
                } else {
                    int anoSeguinte = Integer.parseInt(dataTransitoJulgado.formatado().substring(6, 10)) + 1;
                    dtPA.setConteudo(DataUtil.obterPrimeiroDiaUtilDeMaioString((int)anoSeguinte) + "/05/" + anoSeguinte);
                }
            } else {
                dtPA.setConteudo(dataReaberturaEntrega);
            }
            Valor valorMulta = registroMulta.fieldByName("VR_MULTA").asValor();
            String numNotificacao = registroMulta.fieldByName("NR_DISTRIBUICAO").asString();
            String observacoes = "Caso seja feriado local, antecipe o pagamento||Imposto sobre a Renda da Pessoa F\u00edsica " + ConstantesGlobais.EXERCICIO;
            String descricaoPrincipal = "Multa Atraso Entrega DIRPF";
            Object descricoesAdicionais = idDecl.isAjuste() ? "Declara\u00e7\u00e3o de Ajuste Anual - Notifica\u00e7\u00e3o n\u00ba " + numNotificacao + "|" : (idDecl.isSaida() ? "Declara\u00e7\u00e3o de Sa\u00edda Definitiva do Pa\u00eds - Notifica\u00e7\u00e3o n\u00ba " + numNotificacao + "|" : (idDecl.isEspolio() ? "Declara\u00e7\u00e3o Final de Esp\u00f3lio - Notifica\u00e7\u00e3o n\u00ba " + numNotificacao + "|" : "|"));
            if (idDecl.isEspolio()) {
                return BarramentoIRPFService.obterPdfDarfMaedEspolio((String)idDecl.getCpf().naoFormatado(), (String)idDecl.getNome().naoFormatado(), (String)observacoes, (String)descricaoPrincipal, (String)descricoesAdicionais, (Date)dtPA.asDate(), (Date)dtVenc.asDate(), (Double)Double.valueOf(valorMulta.getParteInteira() + "." + valorMulta.getParteDecimal()), (String)codigoMunicipio);
            }
            return BarramentoIRPFService.obterPdfDarfMaed((String)idDecl.getCpf().naoFormatado(), (String)idDecl.getNome().naoFormatado(), (String)observacoes, (String)descricaoPrincipal, (String)descricoesAdicionais, (Date)dtPA.asDate(), (Date)dtVenc.asDate(), (Double)Double.valueOf(valorMulta.getParteInteira() + "." + valorMulta.getParteDecimal()), (String)codigoMunicipio);
        }
        catch (AplicacaoException | BarramentoException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AplicacaoException("Ocorreu um erro durante a gera\u00e7\u00e3o do Darf", false);
        }
    }

    public boolean isCancelou() {
        return this.cancelou;
    }
}

