/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.ColecaoIdDeclaracao;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.gui.TableModelSelecionaDeclaracaoTransmitida;
import serpro.ppgd.irpf.gui.dialogs.PainelImprimirDARFMaed;
import serpro.ppgd.irpf.gui.dialogs.PainelMensagemAuxilioEmergencial;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesTransmitidas;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.impressao.ImpressaoDarfAuxilioEmergencial;
import serpro.ppgd.irpf.impressao.ImpressaoDeclaracao;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.irpf.tabelas.TabelaDatasIRPF;
import serpro.ppgd.irpf.txt.gravacaorestauracao.RepositorioDeclaracaoCentralTxt;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.irpf.util.TipoDeclaracaoAES;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.repositorio.RepositorioException;
import serpro.receitanet.Util;

public class PainelImprimirRecibo
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Imprimir Recibo de Entrega da Declara\u00e7\u00e3o";
    private File dirSelecionado = new File(UtilitariosArquivo.getPathTransmitidas());
    private List<RepositorioDeclaracaoCentralTxt> repositorios;
    private boolean cancelou;
    private String reciboSelecionado = null;
    private JButton btnAjuda;
    private JButton btnImprimir;
    private JButton btnSair;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JRadioButton rbImprimir;
    private JRadioButton rbVisualizar;
    private SubpainelDeclaracoesTransmitidas subpainelDeclaracoesTransmitidas;

    public PainelImprimirRecibo() {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
        this.atualizaTextoDirSelecionado();
        this.configurarPainelDeclaracoes();
    }

    private void configurarPainelDeclaracoes() {
        this.subpainelDeclaracoesTransmitidas.getTabela().setSelectionMode(0);
        this.subpainelDeclaracoesTransmitidas.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelImprimirRecibo.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirRecibo.this.btnImprimir.setEnabled(true);
                } else {
                    PainelImprimirRecibo.this.btnImprimir.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesTransmitidas.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelImprimirRecibo.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirRecibo.this.btnImprimirActionPerformed(null);
                }
            }
        });
    }

    public PainelImprimirRecibo(String reciboSelecionado) {
        this();
        this.reciboSelecionado = reciboSelecionado;
        boolean selecionouDeclaraco = this.selecionarDeclaracao(reciboSelecionado);
        if (selecionouDeclaraco) {
            this.imprimir();
            ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
        }
    }

    public PainelImprimirRecibo(boolean salvarImagem) {
        this();
        if (salvarImagem) {
            this.jLabel1.setText("Selecione a declara\u00e7\u00e3o para salvar o recibo:");
            this.rbImprimir.setVisible(false);
            this.rbVisualizar.setSelected(true);
        }
    }

    private boolean selecionarDeclaracao(String reciboSelecionado) {
        boolean selecionouDeclaracao = false;
        TableModelSelecionaDeclaracaoTransmitida tableModel = (TableModelSelecionaDeclaracaoTransmitida)this.subpainelDeclaracoesTransmitidas.getTabela().getModel();
        int selIndice = -1;
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            String reciboAtual = String.valueOf(tableModel.getValueAt(i, 0)).split("Recibo: ")[1].replaceAll("\\.", "");
            if (!reciboAtual.equals(reciboSelecionado)) continue;
            selIndice = ((TableRowSorter)this.subpainelDeclaracoesTransmitidas.getTabela().getRowSorter()).convertRowIndexToView(i);
            break;
        }
        if (selIndice > -1) {
            this.subpainelDeclaracoesTransmitidas.getTabela().setRowSelectionInterval(selIndice, selIndice);
            selecionouDeclaracao = true;
        }
        return selecionouDeclaracao;
    }

    private void atualizaTextoDirSelecionado() {
        String caminhoGravacao = this.dirSelecionado.getPath();
        if (System.getProperty("os.name").startsWith("Windows")) {
            caminhoGravacao = caminhoGravacao.replaceFirst("/", "");
        }
        ((TableModelSelecionaDeclaracaoTransmitida)this.subpainelDeclaracoesTransmitidas.getTabela().getModel()).setColecaoIdDeclaracao(this.obtemListaDeclaracoesGravadas(this.dirSelecionado.getPath()));
        TableModelSelecionaDeclaracaoTransmitida model = (TableModelSelecionaDeclaracaoTransmitida)this.subpainelDeclaracoesTransmitidas.getTabela().getModel();
        model.setPathGravadas(this.dirSelecionado.getPath());
        model.setPathTransmitidas(this.dirSelecionado.getPath());
    }

    private ColecaoIdDeclaracao obtemListaDeclaracoesGravadas(String path) {
        File dir = new File(path);
        FilenameFilter filterREC = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean retorno = Validador.validarString((String)name, (String)ConstantesGlobaisIRPF.PADRAO_NOME_ARQ_RECIBO) || Validador.validarString((String)name, (String)"\\d{8}.(REC|rec)");
                return retorno;
            }
        };
        File[] filesREC = dir.listFiles(filterREC);
        this.repositorios = new ArrayList<RepositorioDeclaracaoCentralTxt>();
        ColecaoIdDeclaracao ids = new ColecaoIdDeclaracao();
        if (filesREC != null) {
            RepositorioDeclaracaoCentralTxt repositorioRecibo = null;
            RegistroTxt registroRecibo = null;
            RegistroTxt headerDec = null;
            String cpfDec = null;
            String controleSRFcodificado = null;
            for (int i = 0; i < filesREC.length; ++i) {
                String nomeFileREC = filesREC[i].getName();
                try {
                    repositorioRecibo = new RepositorioDeclaracaoCentralTxt("ARQ_COMPLRECIBO", new File(path + File.separator + nomeFileREC));
                    registroRecibo = repositorioRecibo.recuperarRegistroComplementoRecibo();
                    cpfDec = registroRecibo.fieldByName("NR_CPF").asString();
                    controleSRFcodificado = registroRecibo.fieldByName("CONTROLE_SRF").asString();
                    if (cpfDec == null || cpfDec.trim().length() == 0) {
                        JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "Imprimir recibo - Erro ao ler arquivo do recibo.", "Imprimir Recibo", 0);
                    }
                }
                catch (GeracaoTxtException e) {
                    LogPPGD.erro((String)e.getMessage());
                    JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "<HTML>O Arquivo<BR>" + repositorioRecibo.getPath() + "<BR>est\u00e1 corrompido:<BR>" + e.getMessage() + "</HTML>", "Imprimir Recibo", 0);
                }
                catch (IOException e) {
                    LogPPGD.erro((String)e.getMessage());
                    JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "<HTML>Ocorreu um erro inesperado:<BR>" + e.getMessage() + "</HTML>", "Imprimir Recibo", 0);
                }
                File fileDEC = this.getArquivoDec(path, dir, nomeFileREC);
                if (!fileDEC.exists()) continue;
                try {
                    RepositorioDeclaracaoCentralTxt repDeclaracao = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", fileDEC);
                    headerDec = repDeclaracao.recuperarRegistroHeader();
                    if (!this.controleSRFBate(headerDec, controleSRFcodificado)) continue;
                    repDeclaracao.validarDeclaracaoNaoPersistido();
                    ids.itens().add(repDeclaracao.recuperarIdDeclaracaoNaoPersistido(true));
                    this.repositorios.add(repDeclaracao);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "<HTML>Ocorreu um erro inesperado:<BR>" + e.getMessage() + "</HTML>", "Imprimir Recibo", 0);
                    continue;
                }
                catch (GeracaoTxtException e) {
                    JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "<HTML>O Arquivo<BR>" + fileDEC.getPath() + "<BR>est\u00e1 corrompido:<BR>" + e.getMessage() + "</HTML>", "Erro", 0);
                    continue;
                }
                catch (IOException e) {
                    LogPPGD.erro((String)e.getMessage());
                    JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "<HTML>Ocorreu um erro inesperado:<BR>" + e.getMessage() + "</HTML>", "Imprimir Recibo", 0);
                }
            }
        }
        return ids;
    }

    private boolean controleSRFBate(RegistroTxt headerDec, String controleSRFcodificado) throws GeracaoTxtException {
        String h = headerDec.fieldByName("NR_HASH").asString();
        String controleDecodificado = Util.decodificaControleSRF((byte[])controleSRFcodificado.getBytes());
        return h.equals(controleDecodificado);
    }

    private File getArquivoDec(String path, File dir, String nomeFileRec) {
        String nomeFileDec = null;
        File retorno = null;
        if (nomeFileRec.length() > 12) {
            nomeFileDec = nomeFileRec.substring(0, nomeFileRec.length() - 4) + ".DEC";
            retorno = new File(path + File.separator + nomeFileDec);
        } else {
            FilenameFilter filterDEC = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean retorno = Validador.validarString((String)name, (String)ConstantesGlobaisIRPF.PADRAO_NOME_ARQ_DECLARACAO);
                    return retorno;
                }
            };
            File[] files = dir.listFiles(filterDEC);
            File fileDecMaisAtual = null;
            for (int i = 0; i < files.length; ++i) {
                String nomeArqDecAtual = files[i].getName();
                if (fileDecMaisAtual != null && fileDecMaisAtual.lastModified() > files[i].lastModified() || !nomeArqDecAtual.substring(0, 8).equals(nomeFileRec.subSequence(0, 8))) continue;
                fileDecMaisAtual = files[i];
            }
            retorno = fileDecMaisAtual;
            if (retorno == null) {
                nomeFileDec = nomeFileRec.substring(0, nomeFileRec.length() - 4) + ".DEC";
                retorno = new File(path + File.separator + nomeFileDec);
            }
        }
        return retorno;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.btnImprimir = new JButton();
        this.btnSair = new JButton();
        this.btnAjuda = new JButton();
        this.rbImprimir = new JRadioButton();
        this.rbVisualizar = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.subpainelDeclaracoesTransmitidas = new SubpainelDeclaracoesTransmitidas();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Selecione a declara\u00e7\u00e3o para imprimir o recibo:");
        this.jPanel1.setBackground(new Color(241, 245, 249));
        this.jPanel1.setForeground(new Color(255, 255, 255));
        this.btnImprimir.setMnemonic('o');
        this.btnImprimir.setText("Ok");
        this.btnImprimir.setEnabled(false);
        this.btnImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirRecibo.this.btnImprimirActionPerformed(evt);
            }
        });
        this.btnSair.setMnemonic('c');
        this.btnSair.setText("Cancelar");
        this.btnSair.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirRecibo.this.btnSairActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        this.rbImprimir.setBackground(new Color(241, 245, 249));
        this.buttonGroup1.add(this.rbImprimir);
        this.rbImprimir.setFont(FontesUtil.FONTE_NORMAL);
        this.rbImprimir.setText("Imprimir");
        this.rbVisualizar.setBackground(new Color(241, 245, 249));
        this.buttonGroup1.add(this.rbVisualizar);
        this.rbVisualizar.setFont(FontesUtil.FONTE_NORMAL);
        this.rbVisualizar.setSelected(true);
        this.rbVisualizar.setText("Visualizar");
        this.jLabel2.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel2.setForeground(new Color(0, 74, 106));
        this.jLabel2.setText("Selecione a op\u00e7\u00e3o desejada:");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel2).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.btnSair).add((Component)this.btnAjuda).add(2, (Component)this.btnImprimir, -2, 97, -2)).add((Component)this.rbVisualizar).add((Component)this.rbImprimir)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnImprimir, this.btnSair}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).addPreferredGap(1).add((Component)this.rbVisualizar).addPreferredGap(1).add((Component)this.rbImprimir).addPreferredGap(0, 36, Short.MAX_VALUE).add((Component)this.btnImprimir).addPreferredGap(0).add((Component)this.btnSair).addPreferredGap(0).add((Component)this.btnAjuda)));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnImprimir, this.btnSair}, 2);
        this.btnImprimir.getAccessibleContext().setAccessibleName("OK");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.subpainelDeclaracoesTransmitidas, -1, 650, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.subpainelDeclaracoesTransmitidas, -1, 317, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.jLabel1.getAccessibleContext().setAccessibleName("Selecione os declara\u00e7\u00f5es para imprimir o recibo. Para colocar o foco na tabela de declara\u00e7\u00f5es, aperte a tecla TAB, e utilize as setas para cima e para baixo para navegar pelas declara\u00e7\u00f5es.");
    }

    private void btnImprimirActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
        this.imprimir();
    }

    private void imprimir() {
        int[] linhasSelecionadas = this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRows();
        int[] rows = new int[linhasSelecionadas.length];
        for (int a = 0; a < rows.length; ++a) {
            rows[a] = ((TableRowSorter)this.subpainelDeclaracoesTransmitidas.getTabela().getRowSorter()).convertRowIndexToModel(linhasSelecionadas[a]);
        }
        for (int i = 0; i < rows.length; ++i) {
            int linha = rows[i];
            if (linha == -1) continue;
            this.imprimirRecibo(linha);
        }
    }

    private void btnSairActionPerformed(ActionEvent evt) {
        this.cancelou = true;
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    public void imprimirRecibo(int linhaSelecionada) {
        try {
            RepositorioDeclaracaoCentralTxt repDecl = this.repositorios.get(linhaSelecionada);
            if (repDecl != null) {
                String arqDEC = repDecl.getPath();
                this.imprimirDec(arqDEC);
            }
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "<HTML>Ocorreu um erro inesperado:<BR>" + e.getMessage() + "</HTML>", "Imprimir Recibo", 0);
        }
    }

    public void imprimirDec(String arqDEC) throws Exception {
        ImpressaoDeclaracao impressao;
        int indiceUltimoSeparador = arqDEC.lastIndexOf(File.separator);
        Object arqREC = arqDEC.substring(0, arqDEC.length() - 4) + ".REC";
        File fileDec = new File(arqDEC);
        File fileRec = new File((String)arqREC);
        String cpf = fileDec.getName().substring(0, 11);
        if (!fileRec.exists()) {
            arqREC = arqDEC.substring(0, indiceUltimoSeparador + 1);
            arqREC = (String)arqREC + cpf.substring(0, 8);
            arqREC = (String)arqREC + ".REC";
            fileRec = new File((String)arqREC);
        }
        if ((impressao = this.gerarRecibo(fileDec, fileRec)) != null) {
            impressao.visualizar();
        }
    }

    private ImpressaoDeclaracao gerarRecibo(File arquivoDeclaracao, File arquivoRecibo) throws Exception {
        RepositorioDeclaracaoCentralTxt repositorioDeclaracao = null;
        RegistroTxt registroDeclaracao = null;
        RegistroTxt registroHeader = null;
        RepositorioDeclaracaoCentralTxt repositorioRecibo = null;
        RegistroTxt registroRecibo = null;
        RegistroTxt registroEspolio = null;
        RegistroTxt registroSaida = null;
        RegistroTxt registroMulta = null;
        RegistroTxt registroValidador = null;
        RegistroTxt registroIdentificacao = null;
        String cpfContribuinte = null;
        String tipoDeclaracao = null;
        Boolean retificadora = null;
        DeclaracaoIRPF dec = null;
        try {
            String strNrBanco;
            repositorioDeclaracao = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", arquivoDeclaracao);
            repositorioDeclaracao.lerDeclaracaoValidando();
            registroDeclaracao = repositorioDeclaracao.recuperarRegistroRecibo();
            IdentificadorDeclaracao idDeclaracao = repositorioDeclaracao.recuperarIdDeclaracao(true);
            registroHeader = repositorioDeclaracao.recuperarRegistroHeader();
            dec = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(idDeclaracao.getCpf().naoFormatado(), idDeclaracao.getNumReciboTransmitido().naoFormatado());
            registroIdentificacao = repositorioDeclaracao.recuperarRegistroIdentificacao();
            String tipoDeclaracaoAES = registroIdentificacao.fieldByName("IN_TIPODECLARACAO").asString();
            repositorioRecibo = new RepositorioDeclaracaoCentralTxt("ARQ_COMPLRECIBO", arquivoRecibo);
            registroRecibo = repositorioRecibo.recuperarRegistroComplementoRecibo();
            if (tipoDeclaracaoAES.equals(TipoDeclaracaoAES.ESPOLIO.getTipo())) {
                registroEspolio = repositorioDeclaracao.recuperarRegistroFinalEspolio();
            } else if (tipoDeclaracaoAES.equals(TipoDeclaracaoAES.SAIDA.getTipo())) {
                registroSaida = repositorioDeclaracao.recuperarRegistroSaida();
            }
            String pathDados = idDeclaracao.getPathArquivo().toString();
            registroMulta = repositorioRecibo.recuperarRegistroComplementoReciboMulta();
            registroValidador = repositorioRecibo.recuperarRegistroComplementoReciboValidador();
            cpfContribuinte = registroDeclaracao.fieldByName("NR_CPF").asString();
            if (registroDeclaracao.fieldByName("IN_RETIFICADORA").asBoolean()) {
                tipoDeclaracao = "retif";
                retificadora = true;
            } else {
                tipoDeclaracao = "origi";
                retificadora = false;
            }
            ImpressaoDeclaracao impressao = new ImpressaoDeclaracao(this.getTipoOperacao(), IRPFUtil.obterNomeArquivoPDF((String)cpfContribuinte, (String)tipoDeclaracao, (String)"recibo", null));
            impressao.addImpressaoDeclaracao("Recibo", "relRecibo.jasper", pathDados, "/classe");
            repositorioRecibo.validarComplementoRecibo(idDeclaracao);
            Object RW001 = " ";
            if (tipoDeclaracaoAES.equals(TipoDeclaracaoAES.AJUSTE.getTipo())) {
                impressao.addParametro("DEC_AJUSTE", "true");
            }
            if (registroRecibo.fieldByName("IN_APLIC_TRANSMISSAO").asString().equals("1") || registroRecibo.fieldByName("APLIC_TRANSMISSAO").asString().trim().length() == 0) {
                RW001 = " ";
            } else if (registroRecibo.fieldByName("IN_APLIC_TRANSMISSAO").asString().equals("2") && registroRecibo.fieldByName("COD_AG_TRANSMISSOR").asString().equals("999")) {
                RW001 = registroRecibo.fieldByName("APLIC_TRANSMISSAO").asString();
            } else if (registroRecibo.fieldByName("IN_APLIC_TRANSMISSAO").asString().equals("2") && !registroRecibo.fieldByName("COD_AG_TRANSMISSOR").asString().equals("999")) {
                RW001 = registroRecibo.fieldByName("APLIC_TRANSMISSAO").asString() + registroRecibo.fieldByName("COD_AG_TRANSMISSOR").asString();
            }
            if (registroValidador != null) {
                String qtdRetif = "N\u00ba " + String.valueOf(registroValidador.fieldByName("QTD_RETIFICADORAS").asInteger());
                impressao.addParametro("qtdRetificadoras", qtdRetif);
                String inPendencia = registroValidador.fieldByName("IN_PENDENCIA").asString();
                String nomeParametroPendencia = null;
                for (int i = 0; i < inPendencia.length(); ++i) {
                    nomeParametroPendencia = i == 0 ? "pendencia" + (i + 1) + "anoAtras" : "pendencia" + (i + 1) + "anosAtras";
                    impressao.addParametro(nomeParametroPendencia, String.valueOf(inPendencia.charAt(i) == '1'));
                }
                String msgQuotasRecibo = registroIdentificacao.fieldByName("TX_MENSAGEM_RECIBO").asString().trim();
                impressao.addParametro("msgQuotasRecibo", msgQuotasRecibo);
                String nomeMinisterio = "MINIST\u00c9RIO DA FAZENDA";
                impressao.addParametro("nomeMinisterio", nomeMinisterio);
                boolean temDebitoComRFB = registroValidador.fieldByName("IN_DEBITO").asString().equals("1");
                if (temDebitoComRFB) {
                    String dtMensagem = registroValidador.fieldByName("DT_MENSAGEM").asString();
                    dtMensagem = UtilitariosString.formataData((String)dtMensagem);
                    String msgTemDebito = "AVISO: Em " + dtMensagem + ", constavam d\u00e9bitos em aberto no \u00e2mbito da Secretaria Especial da Receita Federal do Brasil e/ou da Procuradoria-Geral da Fazenda Nacional. Para mais informa\u00e7\u00f5es, acesse o servi\u00e7o Certid\u00f5es e Situa\u00e7\u00e3o Fiscal no Portal e-CAC do site da Receita Federal na Internet (https://www.gov.br/receitafederal/pt-br).";
                    impressao.addParametro("msgTemDebito", msgTemDebito);
                }
                String inSaldoRestituicao = registroValidador.fieldByName("IN_SALDO_RESTITUICAO").asString();
                Object dataSaldoRestituicao = registroValidador.fieldByName("DT_SALDO_RESTITUICAO").asString();
                if ("1".equals(inSaldoRestituicao)) {
                    dataSaldoRestituicao = ((String)dataSaldoRestituicao).substring(6, 8) + "/" + ((String)dataSaldoRestituicao).substring(4, 6) + "/" + ((String)dataSaldoRestituicao).substring(0, 4);
                }
                impressao.addParametro("in_saldo_restituir", inSaldoRestituicao);
                impressao.addParametro("dt_saldo_restituir", (String)dataSaldoRestituicao);
            } else {
                impressao.addParametro("qtdRetificadoras", "");
            }
            impressao.addParametro("exercicio", ConstantesGlobais.EXERCICIO);
            impressao.addParametro("anobase", ConstantesGlobais.ANO_BASE);
            Data dataReaberturaEntrega = new Data();
            dataReaberturaEntrega.setConteudo(registroIdentificacao.fieldByName("DT_DIA_UTIL_RECIBO").asString());
            impressao.addParametro("primeiroDiaMulta", dataReaberturaEntrega.formatado());
            if (tipoDeclaracaoAES.equals(TipoDeclaracaoAES.ESPOLIO.getTipo())) {
                impressao.addParametro("TITULO", "RECIBO DE ENTREGA DA DECLARA\u00c7\u00c3O FINAL DE ESP\u00d3LIO");
            } else if (tipoDeclaracaoAES.equals(TipoDeclaracaoAES.SAIDA.getTipo())) {
                impressao.addParametro("TITULO", "RECIBO DE ENTREGA DA DECLARA\u00c7\u00c3O DE SA\u00cdDA DEFINITIVA DO PA\u00cdS");
                impressao.addParametro("dtCondicaoNaoResidente", UtilitariosString.formataData((String)registroSaida.fieldByName("DT_NAORESIDENTE").asString()));
            } else if (registroDeclaracao.fieldByName("IN_COMPLETA").asBoolean()) {
                impressao.addParametro("TITULO", "RECIBO DE ENTREGA DA DECLARA\u00c7\u00c3O DE AJUSTE ANUAL - OP\u00c7\u00c3O PELAS DEDU\u00c7\u00d5ES LEGAIS");
            } else {
                impressao.addParametro("TITULO", "RECIBO DE ENTREGA DA DECLARA\u00c7\u00c3O DE AJUSTE ANUAL - OP\u00c7\u00c3O PELO DESCONTO SIMPLIFICADO");
            }
            impressao.addParametro("nomeContribuinte", registroDeclaracao.fieldByName("NM_NOME").asString());
            impressao.addParametro("cpfContribuinte", UtilitariosString.formataCPF((String)cpfContribuinte));
            if (registroDeclaracao.fieldByName("SG_UF").asString().equals("EX")) {
                impressao.addParametro("endereco", registroDeclaracao.fieldByName("NM_LOGRA").asString());
            } else {
                String end = registroDeclaracao.fieldByName("TIP_LOGRA").asString() + " " + registroDeclaracao.fieldByName("NM_LOGRA").asString();
                impressao.addParametro("endereco", end);
            }
            impressao.addParametro("numero", registroDeclaracao.fieldByName("NR_NUMERO").asString());
            impressao.addParametro("complemento", registroDeclaracao.fieldByName("NM_COMPLEM").asString());
            impressao.addParametro("bairro", registroDeclaracao.fieldByName("NM_BAIRRO").asString());
            impressao.addParametro("cep", UtilitariosString.formataCEP((String)registroDeclaracao.fieldByName("NR_CEP").asString()));
            impressao.addParametro("municipio", registroDeclaracao.fieldByName("NM_MUNICIP").asString());
            impressao.addParametro("uf", registroDeclaracao.fieldByName("SG_UF").asString());
            Object telefone = registroDeclaracao.fieldByName("NR_TELEFONE").asString();
            if (((String)telefone).length() > 0) {
                telefone = "(" + registroDeclaracao.fieldByName("NR_DDD_TELEFONE").asString() + ") " + (String)telefone;
            }
            impressao.addParametro("telefone", (String)telefone);
            if (retificadora.booleanValue()) {
                impressao.addParametro("retificadora", "SIM");
            } else {
                impressao.addParametro("retificadora", "N\u00c3O");
            }
            impressao.addParametro("Tributaveis", registroDeclaracao.fieldByName("VR_TOTTRIB").asValor().formatado());
            impressao.addParametro("devido", registroDeclaracao.fieldByName("VR_IMPDEV").asValor().formatado());
            impressao.addParametro("Restituir", registroDeclaracao.fieldByName("VR_IMPREST").asValor().formatado());
            impressao.addParametro("Especie", registroDeclaracao.fieldByName("VR_VCMOEDAEST").asValor().formatado());
            impressao.addParametro("Pagar", registroDeclaracao.fieldByName("VR_IMPPAGAR").asValor().formatado());
            impressao.addParametro("DATA", registroRecibo.fieldByName("DIAREC").asString() + "/" + registroRecibo.fieldByName("MESREC").asString() + "/" + registroRecibo.fieldByName("ANOREC").asString());
            impressao.addParametro("HORA", registroRecibo.fieldByName("HORAREC").asString() + ":" + registroRecibo.fieldByName("MINREC").asString() + ":" + registroRecibo.fieldByName("SEGREC").asString());
            impressao.addParametro("RW001", (String)RW001);
            String nrRecibo = registroHeader.fieldByName("NR_HASH").asString();
            String dvNrRecibo = "" + Validador.calcularModulo11((String)nrRecibo, null, (int)2);
            dvNrRecibo = dvNrRecibo + Validador.calcularModulo11((String)(nrRecibo + dvNrRecibo), null, (int)2);
            String nrReciboForma = nrRecibo.substring(0, 2) + "." + nrRecibo.substring(2, 4) + "." + nrRecibo.substring(4, 6) + "." + nrRecibo.substring(6, 8) + "." + nrRecibo.substring(8, 10);
            String numReciboComDV = nrReciboForma + " - " + dvNrRecibo;
            impressao.addParametro("NUM_RECIBO_FORM_DV", numReciboComDV);
            impressao.addParametro("ASS_RECIBO", registroRecibo.fieldByName("ASSINATURA").asString());
            if (registroDeclaracao.fieldByName("VR_IMPPAGAR").asValor().isVazio()) {
                strNrBanco = registroDeclaracao.fieldByName("NR_BANCO").asString();
                String tipoConta = dec.getResumo().getCalculoImposto().getTipoConta().getConteudoAtual(0);
                if (!strNrBanco.trim().equals("") && Integer.valueOf(strNrBanco.trim()) != 0) {
                    impressao.addParametro("lblRestitParcel", "RESTITUI\u00c7\u00c3O");
                    impressao.addParametro("lblBancoQuotas", "C\u00d3DIGO DO BANCO");
                    impressao.addParametro("BancoNumQuotas", registroDeclaracao.fieldByName("NR_BANCO").asString());
                    impressao.addParametro("AgenciaValor", "AG\u00caNCIA BANC\u00c1RIA");
                    String agencia = registroDeclaracao.fieldByName("NR_AGENCIA").asString();
                    impressao.addParametro("AgenciaValQuota", agencia);
                    impressao.addParametro("lblCodBancoOuCC", "CONTA PARA CR\u00c9DITO");
                    Object conta = registroDeclaracao.fieldByName("NR_CONTA").asString();
                    conta = (String)conta + "-" + registroDeclaracao.fieldByName("NR_DV_CONTA").asString();
                    impressao.addParametro("codBancoOuCC", (String)conta);
                } else if (tipoConta.equals(CadastroTabelasIRPF.TIPO_CONTA_PIX)) {
                    impressao.addParametro("lblRestitParcel", "RESTITUI\u00c7\u00c3O");
                    impressao.addParametro("lblBancoQuotas", "      Cr\u00e9dito solicitado na chave PIX: CPF do titular da declara\u00e7\u00e3o");
                    impressao.addParametro("lblCodBancoOuCC", "");
                    impressao.addParametro("codBancoOuCC", "");
                } else {
                    impressao.addParametro("lblCodBancoOuCC", "");
                    impressao.addParametro("codBancoOuCC", "");
                }
            } else {
                if (!tipoDeclaracaoAES.equals(TipoDeclaracaoAES.AJUSTE.getTipo())) {
                    impressao.addParametro("lblRestitParcel", "");
                } else {
                    Object dataVencimento = TabelaDatasIRPF.obterVencimentosQuotas((boolean)dec.getEmCalamidade())[0];
                    if (((String)dataVencimento).indexOf("/") == -1) {
                        dataVencimento = ((String)dataVencimento).substring(0, 2) + "/" + ((String)dataVencimento).substring(2, 4) + "/" + ((String)dataVencimento).substring(4, 8);
                    }
                    impressao.addParametro("lblRestitParcel", "PARCELAMENTO (Vencimento da 1a quota em " + (String)dataVencimento + ")");
                    impressao.addParametro("lblBancoQuotas", "N\u00daMERO DE QUOTAS");
                    impressao.addParametro("BancoNumQuotas", registroDeclaracao.fieldByName("NR_QUOTAS").asString());
                    impressao.addParametro("AgenciaValor", "VALOR DA QUOTA");
                    impressao.addParametro("AgenciaValQuota", registroDeclaracao.fieldByName("VR_QUOTA").asValor().formatado());
                }
                strNrBanco = registroDeclaracao.fieldByName("NR_BANCO").asString();
                if (!strNrBanco.trim().equals("") && Integer.valueOf(strNrBanco.trim()) != 0) {
                    if (registroDeclaracao.fieldByName("IN_DEBITO_PRIMEIRA_QUOTA").asString().trim().equals("1")) {
                        impressao.addParametro("descDebitoQuota", "D\u00c9BITO AUTOM\u00c1TICO AUTORIZADO PELO DECLARANTE (a partir da 1\u00aa quota)");
                    } else {
                        impressao.addParametro("descDebitoQuota", "D\u00c9BITO AUTOM\u00c1TICO AUTORIZADO PELO DECLARANTE (a partir da 2\u00aa quota)");
                    }
                    impressao.addParametro("comDebitoAutomatico", "true");
                    impressao.addParametro("lblCodBancoOuCC", "C\u00d3DIGO DO BANCO");
                    impressao.addParametro("codBancoOuCC", registroDeclaracao.fieldByName("NR_BANCO").asString());
                    String agencia = registroDeclaracao.fieldByName("NR_AGENCIA").asString();
                    impressao.addParametro("agencia", agencia);
                    Object conta = registroDeclaracao.fieldByName("NR_CONTA").asString();
                    conta = (String)conta + "-" + registroDeclaracao.fieldByName("NR_DV_CONTA").asString();
                    impressao.addParametro("conta", (String)conta);
                } else {
                    impressao.addParametro("lblCodBancoOuCC", "");
                    impressao.addParametro("codBancoOuCC", "");
                    impressao.addParametro("descDebitoQuota", "");
                }
            }
            String assCertDigital = registroRecibo.fieldByName("NI_ASSINATURA_DECL").asString();
            if (assCertDigital != null && (assCertDigital.trim().length() == 11 || assCertDigital.trim().length() == 14)) {
                assCertDigital = assCertDigital.trim().length() == 11 ? UtilitariosString.formataCPF((String)assCertDigital) : UtilitariosString.formataCNPJ((String)assCertDigital);
                impressao.addParametro("LBL_ASS_CERT_DIGITAL", "Esta declara\u00e7\u00e3o foi assinada com o certificado digital do NI " + assCertDigital);
            } else {
                impressao.addParametro("LBL_ASS_CERT_DIGITAL", "");
            }
            Map mapAuxilio = repositorioRecibo.recuperarValoresAuxilioEmergencial();
            if (!mapAuxilio.isEmpty()) {
                impressao.addImpressaoDeclaracao("Darf Aux\u00edlio Emergencial", "relDarfAuxilio.jasper", pathDados, "/classe");
                ImpressaoDarfAuxilioEmergencial impressaoDarfAuxilioEmergencial = new ImpressaoDarfAuxilioEmergencial();
                impressaoDarfAuxilioEmergencial.adicionarParametrosAuxilioEmergencial(dec, impressao, mapAuxilio);
                GuiUtil.exibeDialog(new PainelMensagemAuxilioEmergencial(), true, "Aviso - Devolu\u00e7\u00e3o do Aux\u00edlio Emergencial", false);
            }
            if (registroMulta != null && registroMulta.fieldByName("IN_ACAO_FISCAL").asString().equals("1")) {
                impressao.addParametro("contribSobFiscal", "Esta declara\u00e7\u00e3o est\u00e1 sendo apresentada ap\u00f3s o in\u00edcio de procedimento fiscal.\nSomente alimentar\u00e3o a base de dados da RFB as informa\u00e7\u00f5es das seguintes fichas:\n1 - IDENTIFICA\u00c7\u00c3O DO CONTRIBUINTE\n2 - BENS E DIREITOS (exceto doa\u00e7\u00f5es recebidas em esp\u00e9cie)\n3 - D\u00cdVIDAS E \u00d4NUS REAIS\nAs demais informa\u00e7\u00f5es que est\u00e3o sendo alteradas devem ser entregues \u00e0 fiscaliza\u00e7\u00e3o.");
            }
            if (registroMulta != null && registroMulta.fieldByName("NR_DISTRIBUICAO").asString().trim().length() > 0) {
                String codNotificacao = registroMulta.fieldByName("NR_DISTRIBUICAO").asString();
                impressao.addParametro("Notificacao", codNotificacao.substring(0, codNotificacao.length() - 2) + "-" + codNotificacao.substring(codNotificacao.length() - 2, codNotificacao.length()));
                String lblCodNotificacao = "C\u00d3DIGO DA NOTIFICA\u00c7\u00c3O DE MULTA POR ATRASO NA ENTREGA DA DECLARA\u00c7\u00c3O";
                impressao.addParametro("lblNotificacao", lblCodNotificacao);
                this.gerarImpressaoNotificacaoMulta(arquivoDeclaracao, arquivoRecibo, impressao, registroHeader, registroMulta, registroDeclaracao, registroRecibo, numReciboComDV, tipoDeclaracaoAES);
                PainelImprimirDARFMaed.exibirDarfMaed(tipoDeclaracao, cpfContribuinte, arquivoDeclaracao, arquivoRecibo);
            } else {
                impressao.addParametro("lblNotificacao", "");
                impressao.addParametro("Notificacao", "");
            }
            IRPFUtil.setNomeArquivo((String)IRPFUtil.obterNomeArquivoPDF((String)cpfContribuinte, (String)tipoDeclaracao, (String)"recibo", null));
            return impressao;
        }
        catch (RepositorioException e) {
            LogPPGD.erro((String)e.getMessage());
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), e.getMessage(), "Impress\u00e3o do Recibo", 0);
        }
        catch (FileNotFoundException e) {
            LogPPGD.erro((String)e.getMessage());
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), e.getMessage(), "Impress\u00e3o do Recibo", 0);
        }
        catch (GeracaoTxtException e) {
            LogPPGD.erro((String)e.getMessage());
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), e.getMessage(), "Impress\u00e3o do Recibo", 0);
        }
        catch (IOException e) {
            LogPPGD.erro((String)e.getMessage());
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), e.getMessage(), "Impress\u00e3o do Recibo", 0);
        }
        return null;
    }

    private String obterNomePorCPF(DeclaracaoIRPF dec, String cpf) {
        String nome = dec.getIdentificadorDeclaracao().getNome().naoFormatado();
        if (!dec.getIdentificadorDeclaracao().getCpf().formatado().equals(cpf)) {
            for (Dependente dependente : dec.getDependentes().itens()) {
                if (!dependente.getCpfDependente().formatado().equals(cpf)) continue;
                nome = dependente.getNome().formatado();
                break;
            }
        }
        return nome;
    }

    private String formataNumero(BigDecimal valor) {
        DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(new Locale("pt", "BR")));
        Valor valorFormatado = new Valor(df.format(valor));
        return valorFormatado.formatado();
    }

    private void gerarImpressaoNotificacaoMulta(File arquivoDeclaracao, File arquivoRecibo, ImpressaoDeclaracao impressao, RegistroTxt registroHeader, RegistroTxt pRegMulta, RegistroTxt pRegDec, RegistroTxt registroRecibo, String numReciboComDV, String tipoDeclaracaoAES) throws IOException, RepositorioException, GeracaoTxtException {
        int somaCondicoesObrigatoriedade = registroHeader.fieldByName("IN_CRIT_OBRIGAT").asInteger();
        if (tipoDeclaracaoAES.equals(TipoDeclaracaoAES.ESPOLIO.getTipo())) {
            impressao.addImpressaoDeclaracao("Notifica\u00e7\u00e3o de Lan\u00e7amento", "relNotificacaoEspolio.jasper", null, null);
            impressao.addParametroUltimo("MOSTRAR_CONDICAO_1", String.valueOf(PainelImprimirRecibo.isNumeroContidoSoma(1, somaCondicoesObrigatoriedade)));
        } else if (tipoDeclaracaoAES.equals(TipoDeclaracaoAES.SAIDA.getTipo())) {
            impressao.addImpressaoDeclaracao("Notifica\u00e7\u00e3o de Lan\u00e7amento", "relNotificacaoSaida.jasper", null, null);
            impressao.addParametroUltimo("MOSTRAR_CONDICAO_1", String.valueOf(PainelImprimirRecibo.isNumeroContidoSoma(1, somaCondicoesObrigatoriedade)));
        } else {
            impressao.addImpressaoDeclaracao("Notifica\u00e7\u00e3o de Lan\u00e7amento", "relNotificacao.jasper", null, null);
            int[] ordem = new int[]{1, 2, 8, 4, 64, 32, 128, 16, 256};
            int indice = 1;
            for (int i = 0; i < ordem.length; ++i) {
                int criterio = ordem[i];
                boolean visivel = PainelImprimirRecibo.isNumeroContidoSoma(criterio, somaCondicoesObrigatoriedade);
                impressao.addParametroUltimo("MOSTRAR_CONDICAO_" + criterio, String.valueOf(visivel));
                if (!visivel) continue;
                impressao.addParametroUltimo("INDICE_" + criterio, String.valueOf(indice++));
            }
        }
        String nomeMinisterio = "MINIST\u00c9RIO DA FAZENDA";
        impressao.addParametroUltimo("nomeMinisterio", nomeMinisterio);
        Valor tempoAtraso = pRegMulta.fieldByName("QT_MESES").asValor();
        impressao.addParametroUltimo("ehEspolio", tipoDeclaracaoAES.equals(TipoDeclaracaoAES.ESPOLIO.getTipo()) ? "true" : "false");
        impressao.addParametroUltimo("DtEntregaNot", registroRecibo.fieldByName("DIAREC").asString() + "/" + registroRecibo.fieldByName("MESREC").asString() + "/" + registroRecibo.fieldByName("ANOREC").asString());
        impressao.addParametroUltimo("HrEntregaNot", registroRecibo.fieldByName("HORAREC").asString() + ":" + registroRecibo.fieldByName("MINREC").asString() + ":" + registroRecibo.fieldByName("SEGREC").asString());
        impressao.addParametroUltimo("MesesNot", pRegMulta.fieldByName("QT_MESES").asString());
        impressao.addParametroUltimo("impDev", registroHeader.fieldByName("VR_IMPDEVIDO").asValor().formatado());
        if (tempoAtraso.comparacao(">", "20")) {
            tempoAtraso.setConteudo("20");
        }
        impressao.addParametroUltimo("tempoAtrasoMax", tempoAtraso.formatado());
        Valor impostoDevido = registroHeader.fieldByName("VR_IMPDEVIDO").asValor();
        Valor valorCalculado = impostoDevido.operacao('*', tempoAtraso);
        valorCalculado.append('/', "100,00");
        impressao.addParametroUltimo("MultaCalc", valorCalculado.formatado());
        impressao.addParametro("EXERCICIO", ConstantesGlobais.EXERCICIO);
        impressao.addParametro("ANO_CALENDARIO", ConstantesGlobais.ANO_BASE);
        impressao.addParametro("ReciboNot", numReciboComDV);
        Object strCodNot = pRegMulta.fieldByName("NR_DISTRIBUICAO").asString();
        if (strCodNot != null && ((String)strCodNot).length() > 2) {
            strCodNot = ((String)strCodNot).substring(0, ((String)strCodNot).length() - 2) + "-" + ((String)strCodNot).substring(((String)strCodNot).length() - 2);
        }
        impressao.addParametro("CodNot", (String)strCodNot);
        impressao.addParametro("MunicNot", pRegDec.fieldByName("NM_MUNICIP").asString());
        Valor valMultaFixa = new Valor();
        valMultaFixa.setConteudo(pRegMulta.fieldByName("VR_MULTA").asValor());
        impressao.addParametroUltimo("MultaFixa", valMultaFixa.formatado());
        impressao.addParametroUltimo("Multa", valMultaFixa.formatado());
        impressao.addParametroUltimo("MultaExtenso", IRPFUtil.escreverValorMonetarioPorExtenso((String)valMultaFixa.formatado()));
        String multaAtrasoEntrega = ConstantesGlobais.MULTA_POR_ATRASO_ENTREGA.formatado();
        impressao.addParametroUltimo("CONSTANTE_VAL_MULTA", multaAtrasoEntrega);
        impressao.addParametroUltimo("CONSTANTE_VAL_MULTA_EXTENSO", IRPFUtil.escreverValorMonetarioPorExtenso((String)multaAtrasoEntrega));
        impressao.addParametroUltimo("LIMITE_ISENCAO", TabelaAliquotasIRPF.ConstantesAliquotas.limiteIsencao.getValor().formatado());
        impressao.addParametroUltimo("LIMITE_REND_ISEN_TRIB_EXCL", TabelaAliquotasIRPF.ConstantesAliquotas.limiteRendimentosIsentosTributExclusiva.getValor().formatado());
        impressao.addParametroUltimo("LIMITE_BENS_DIREITOS", TabelaAliquotasIRPF.ConstantesAliquotas.limiteBensDireitos.getValor().formatado());
        impressao.addParametroUltimo("LIMITE_RECEITA_BRUTA_AR", TabelaAliquotasIRPF.ConstantesAliquotas.limiteReceitaBrutaAtividadeRural.getValor().formatado());
        impressao.addParametroUltimo("VALOR_OBRIGATORIEDADE_CRITERIO_RENDA_VARIAVEL", "40.000,00");
        impressao.addParametroUltimo("NOME_AUDITOR_TECNICO", pRegMulta.fieldByName("NM_DELEGADO").asString());
        impressao.addParametroUltimo("PATH", "");
        int cargo = pRegMulta.fieldByName("NR_CARGO").asInteger();
        if (cargo == 1) {
            impressao.addParametroUltimo("CARGO", "AUDITOR-FISCAL DA RECEITA FEDERAL DO BRASIL");
        } else if (cargo == 2) {
            impressao.addParametroUltimo("CARGO", "T\u00c9CNICO DA RECEITA FEDERAL DO BRASIL");
        }
        impressao.addParametroUltimo("MATRIC_AUDITOR_TECNICO", pRegMulta.fieldByName("NR_MATRIC_DELEGADO").asString());
        Object nomeDelegacia = "";
        nomeDelegacia = pRegMulta.fieldByName("TP_DELEGACIA").asString();
        nomeDelegacia = (String)nomeDelegacia + " " + pRegMulta.fieldByName("NM_UA").asString();
        impressao.addParametroUltimo("NOME_DELEGACIA", (String)nomeDelegacia);
        impressao.addParametro("icone", ClassLoader.getSystemClassLoader().getResource("icones/brasao.jpg").toString());
    }

    private static boolean isNumeroContidoSoma(int num, int soma) {
        return (num & soma) > 0;
    }

    public int getTipoOperacao() {
        if (this.rbVisualizar.isSelected()) {
            return 1;
        }
        if (this.rbImprimir.isSelected()) {
            return 3;
        }
        return 0;
    }

    public boolean isCancelou() {
        return this.cancelou;
    }
}

