/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditCPF;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.dialogs.PainelCriarNovaDeclaracao;
import serpro.ppgd.irpf.gui.dialogs.PainelInformaRegimeTributacao;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.TipoDeclaracaoAES;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;

public class SubPainelDeclaracaoEmBranco
extends JPanel {
    private PainelCriarNovaDeclaracao painelPai;
    private IdentificadorDeclaracao idDec;
    private JButton btnOk;
    private JEditCPF edtCpf;
    private JEditAlfa edtNome;
    private JLabel lblAcaoIniciarDeclaracao;
    private JLabel lblCpf;
    private JLabel lblNome;
    private JPanel pntTitulo;

    public SubPainelDeclaracaoEmBranco(PainelCriarNovaDeclaracao painelPai) {
        this.initComponents();
        this.painelPai = painelPai;
        this.idDec = new IdentificadorDeclaracao();
        this.edtCpf.setInformacao((Informacao)this.idDec.getCpf());
        this.edtNome.setInformacao((Informacao)this.idDec.getNome());
        CacheNI.getInstancia().registrarCacheCampoNI((Container)this);
    }

    public void obterFoco() {
        this.edtCpf.requestFocusInWindow();
    }

    private void criarDeclaracao(IdentificadorDeclaracao id, TipoDeclaracaoAES tipoDeclaracao, JEditCPF edtCPF, JEditAlfa edtNome) {
        if (tipoDeclaracao == null) {
            return;
        }
        id.getTipoDeclaracaoAES().setConteudo(tipoDeclaracao.getTipo());
        id.getNumReciboTransmitido().setConteudo("0000000000");
        id.getInNovaDeclaracao().setConteudo(Logico.SIM);
        id.getCpf().validar();
        id.getNome().validar();
        if (id.getCpf().isVazio()) {
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new JLabel(MensagemUtil.getMensagem((String)"cpf_branco")), "Erro", 0);
            edtCPF.getComponenteFoco().requestFocusInWindow();
            return;
        }
        if (!id.getCpf().isValido()) {
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new JLabel(MensagemUtil.getMensagem((String)"cpf_invalido")), "Erro", 0);
            edtCPF.getComponenteFoco().requestFocusInWindow();
            return;
        }
        if (id.getNome().isVazio()) {
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new JLabel(MensagemUtil.getMensagem((String)"nome_branco")), "Erro", 0);
            edtNome.getComponenteFoco().requestFocusInWindow();
            return;
        }
        if (!id.getNome().isValido()) {
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new JLabel(id.getNome().getRetornoTodasValidacoes().getPrimeiroRetornoValidacaoMaisSevero().getMensagemValidacao()), "Erro", 0);
            edtNome.getComponenteFoco().requestFocusInWindow();
            return;
        }
        if (IRPFFacade.existeDeclaracao((String)id.getCpf().naoFormatado(), (String)"0000000000")) {
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new JLabel(MensagemUtil.getMensagem((String)"existe_cpf")), "Erro", 0);
            edtCPF.getComponenteFoco().requestFocusInWindow();
            return;
        }
        IRPFFacade.criarDeclaracao((IdentificadorDeclaracao)id);
        if (tipoDeclaracao.equals((Object)TipoDeclaracaoAES.AJUSTE)) {
            PainelInformaRegimeTributacao painelInfoTributacao = new PainelInformaRegimeTributacao(id);
            GuiUtil.exibeDialog(painelInfoTributacao, true, "Aten\u00e7\u00e3o", false);
            try {
                ControladorGui.abrirDemonstrativo(id, true);
            }
            catch (HashInvalidoException e) {
                ControladorGui.tratarException((Exception)((Object)e));
            }
        } else {
            try {
                ControladorGui.abrirDemonstrativo(id, true);
            }
            catch (HashInvalidoException e) {
                ControladorGui.tratarException((Exception)((Object)e));
            }
        }
    }

    private void initComponents() {
        this.pntTitulo = new JPanel();
        this.lblAcaoIniciarDeclaracao = new JLabel();
        this.lblCpf = new JLabel();
        this.edtCpf = new JEditCPF();
        this.lblNome = new JLabel();
        this.edtNome = new JEditAlfa();
        this.btnOk = new JButton();
        this.setBackground(new Color(254, 254, 254));
        this.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.pntTitulo.setBackground(new Color(205, 224, 239));
        this.lblAcaoIniciarDeclaracao.setFont(FontesUtil.FONTE_MAIOR);
        this.lblAcaoIniciarDeclaracao.setForeground(new Color(0, 74, 106));
        this.lblAcaoIniciarDeclaracao.setText("Criar Declara\u00e7\u00e3o em Branco");
        GroupLayout pntTituloLayout = new GroupLayout(this.pntTitulo);
        this.pntTitulo.setLayout(pntTituloLayout);
        pntTituloLayout.setHorizontalGroup(pntTituloLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pntTituloLayout.createSequentialGroup().addContainerGap().addComponent(this.lblAcaoIniciarDeclaracao).addContainerGap(-1, Short.MAX_VALUE)));
        pntTituloLayout.setVerticalGroup(pntTituloLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAcaoIniciarDeclaracao, -1, 28, Short.MAX_VALUE));
        this.lblCpf.setForeground(new Color(0, 74, 106));
        this.lblCpf.setText("CPF");
        this.lblNome.setForeground(new Color(0, 74, 106));
        this.lblNome.setText("Nome");
        this.btnOk.setMnemonic('o');
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubPainelDeclaracaoEmBranco.this.btnOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pntTitulo, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(44, 44, 44).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCpf).addComponent((Component)this.edtCpf, -2, 147, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblNome).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent((Component)this.edtNome, -1, 228, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.btnOk, -2, 63, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pntTitulo, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCpf).addComponent(this.lblNome)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.edtCpf, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtNome, -2, -1, -2).addComponent(this.btnOk, -2, 27, -2))).addGap(0, 14, Short.MAX_VALUE)));
        this.edtCpf.getAccessibleContext().setAccessibleName("CPF");
        this.edtCpf.getAccessibleContext().setAccessibleDescription("");
        this.edtNome.getAccessibleContext().setAccessibleName("Nome");
        this.edtNome.getAccessibleContext().setAccessibleDescription("");
        this.getAccessibleContext().setAccessibleName("Criar declara\u00e7\u00e3o em branco");
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.criarDeclaracao(this.idDec, this.painelPai.getTipoDeclaracao(), this.edtCpf, this.edtNome);
    }
}

