/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.nuvem;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.exception.BarramentoException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.nuvem.CaptchaUtil;
import serpro.ppgd.irpf.gui.nuvem.PainelCaptchaAb;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.nuvem.Captcha;

public class CaptchaAudioSwingWorker
extends SwingWorker<byte[], Void> {
    private Captcha captcha;
    private PainelCaptchaAb painelCaptcha;

    public CaptchaAudioSwingWorker(Captcha captcha, PainelCaptchaAb painelCaptcha) {
        this.captcha = captcha;
        this.painelCaptcha = painelCaptcha;
    }

    @Override
    protected byte[] doInBackground() throws Exception {
        this.painelCaptcha.getComponenteResposta().requestFocusInWindow();
        this.configurarEstadoTela(false);
        byte[] retorno = this.captcha.getSom();
        return retorno;
    }

    @Override
    protected void done() {
        try {
            this.captcha.setSom((byte[])this.get());
            CaptchaUtil.ouvirAudioCaptcha(this.captcha.getSom());
        }
        catch (CancellationException cancellationException) {
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof ExecutionException && (e.getCause() instanceof AplicacaoException || e.getCause() instanceof BarramentoException)) {
                GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), e.getCause().getMessage());
            } else {
                GuiUtil.mostrarErro("nuvem.erro.inesperado");
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.configurarEstadoTela(true);
        }
    }

    private void configurarEstadoTela(boolean estado) {
        this.painelCaptcha.getLabelOcupado().setVisible(!estado);
        this.painelCaptcha.getLabelOcupado().setBusy(!estado);
        this.painelCaptcha.getBtnAtualizar().setEnabled(estado);
        this.painelCaptcha.getBtnAudio().setEnabled(estado);
        this.painelCaptcha.getBtnOk().setEnabled(estado);
    }
}

