/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.util.calc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import serpro.ppgd.gui.ConstantesGlobaisGUI;

public class BotaoCalculadora
extends JButton {
    private static final long serialVersionUID = 1L;
    protected static final Dimension tamanhoPadrao = new Dimension(20, 20);
    private boolean usarAntiAliasing;

    public BotaoCalculadora() {
        this.init();
    }

    private void init() {
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setMinimumSize(tamanhoPadrao);
        this.setPreferredSize(tamanhoPadrao);
        this.setSize(tamanhoPadrao);
    }

    @Override
    public void setText(String pTexto) {
        super.setText(pTexto);
        this.configurarEvento(pTexto);
    }

    protected void configurarEvento(String pTexto) {
        boolean ehNumero = false;
        if (pTexto.length() == 1 || pTexto.equals("Transportar") || pTexto.equals("AC")) {
            String key = "pressionou" + pTexto;
            KeyStroke stroke = null;
            KeyStroke stroke2 = null;
            if (pTexto.equals("-")) {
                stroke = KeyStroke.getKeyStroke("SUBTRACT");
                stroke2 = KeyStroke.getKeyStroke("MINUS");
            } else if (pTexto.equals("+")) {
                stroke = KeyStroke.getKeyStroke("ADD");
                stroke2 = KeyStroke.getKeyStroke(61, 1);
            } else if (pTexto.equals("X")) {
                stroke = KeyStroke.getKeyStroke('*');
            } else if (pTexto.equals("/")) {
                stroke = KeyStroke.getKeyStroke('/');
            } else if (pTexto.equals("=")) {
                stroke = KeyStroke.getKeyStroke("ENTER");
                stroke2 = KeyStroke.getKeyStroke("EQUALS");
            } else if (pTexto.equals(",")) {
                stroke = KeyStroke.getKeyStroke(44, 0);
                String os = System.getProperty("os.name").toLowerCase();
                stroke2 = os.startsWith("windows") ? KeyStroke.getKeyStroke(110, 0) : KeyStroke.getKeyStroke(108, 0);
            } else if ("0123456789".indexOf(pTexto) > -1) {
                stroke = KeyStroke.getKeyStroke(pTexto);
                ehNumero = true;
            } else {
                stroke = "Transportar".equals(pTexto) ? KeyStroke.getKeyStroke("T") : ("AC".equals(pTexto) ? KeyStroke.getKeyStroke(27, 0) : KeyStroke.getKeyStroke(pTexto));
            }
            this.registraKeyStroke(key, stroke);
            if (stroke2 != null) {
                key = key + "2";
                this.registraKeyStroke(key, stroke2);
            }
            if (ehNumero) {
                key = key + "numpad";
                stroke = KeyStroke.getKeyStroke("NUMPAD" + pTexto);
                this.registraKeyStroke(key, stroke);
            }
        }
    }

    protected void configurarVisualBotao() {
        if (this.getText() == null || this.getText().trim().length() == 0) {
            return;
        }
        boolean ehNumerico = Character.isDigit(this.getText().charAt(0));
        if (this.getText().equals("Transportar")) {
            this.setFont(ConstantesGlobaisGUI.FONTE_9_NORMAL);
            this.setForeground(Color.red);
        } else if (this.getText().equals("/") || this.getText().equals("X") || this.getText().equals("-") || this.getText().equals("+") || this.getText().equals("AC") || this.getText().equals("=")) {
            this.setFont(ConstantesGlobaisGUI.FONTE_11_BOLD);
            this.setForeground(Color.red);
            this.setUsarAntiAliasing(true);
        } else if (this.getText().equals("MC") || this.getText().equals("MR") || this.getText().equals("M-") || this.getText().equals("M+") || this.getText().equals(",") || ehNumerico) {
            this.setFont(ConstantesGlobaisGUI.FONTE_11_BOLD);
            this.setForeground(new Color(6, 0, 117));
            this.setUsarAntiAliasing(true);
        } else if (this.getText().equals("CE") || this.getText().equals("+/-")) {
            this.setFont(ConstantesGlobaisGUI.FONTE_11_BOLD);
            this.setUsarAntiAliasing(true);
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        RenderingHints rhints = g2d.getRenderingHints();
        boolean antialiasOn = rhints.containsValue(RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isUsarAntiAliasing() && !antialiasOn) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        super.paint(g);
    }

    private void registraKeyStroke(String key, KeyStroke stroke) {
        this.getInputMap(2).put(stroke, key);
        this.getActionMap().put(key, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BotaoCalculadora.this.doClick();
            }
        });
    }

    public boolean isUsarAntiAliasing() {
        return this.usarAntiAliasing;
    }

    public void setUsarAntiAliasing(boolean comAA) {
        this.usarAntiAliasing = comAA;
    }
}

