/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.util.calc;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import serpro.ppgd.irpf.ValorBigDecimal;
import serpro.ppgd.negocio.Valor;

public class DisplayForm
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String valorInterno = "0";
    private JLabel displayValor;

    public DisplayForm() {
        this.initComponents();
    }

    private void initComponents() {
        this.displayValor = new JLabel();
        this.displayValor.setBackground(Color.white);
        this.displayValor.setFont(this.displayValor.getFont().deriveFont((float)this.displayValor.getFont().getSize() + 6.0f));
        this.displayValor.setForeground(new Color(0, 74, 106));
        this.displayValor.setHorizontalAlignment(4);
        this.displayValor.setText("15000,45");
        this.displayValor.setBorder(BorderFactory.createEtchedBorder());
        this.displayValor.setOpaque(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayValor, -1, 227, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayValor, -1, 58, Short.MAX_VALUE));
    }

    public void atualiza(String pValor) {
        this.atualizarValorInterno(pValor);
        this.getDisplayValor().setText(this.getValorInterno());
    }

    public void atualiza(String pValor, boolean pReformata) {
        this.atualizarValorInterno(pValor);
        this.getDisplayValor().setText(this.getValorFormatado());
    }

    private void atualizarValorInterno(String pValor) {
        this.valorInterno = pValor;
        if (this.valorInterno.equals(",")) {
            this.valorInterno = "0,";
        }
    }

    private Valor getConvertidoCasasDecimais(String valor, int casas) {
        Valor valorAtual = new Valor(null, "Valor", 11, 6);
        valorAtual.setConteudo(valor);
        Object novoValor = "";
        novoValor = valorAtual.formatado();
        int diff = valorAtual.getCasasDecimais() - casas;
        if (diff > 0) {
            novoValor = ((String)novoValor).substring(0, ((String)novoValor).length() - diff);
        } else if (diff < 0) {
            if (valorAtual.getCasasDecimais() == 0) {
                novoValor = (String)novoValor + ",";
            }
            diff = -diff;
            for (int i = 0; i < diff; ++i) {
                novoValor = (String)novoValor + "0";
            }
        }
        Valor valorConvertido = new Valor((String)novoValor);
        return valorConvertido;
    }

    public JLabel getDisplayValor() {
        return this.displayValor;
    }

    public void setDisplayValor(JLabel displayValor) {
        this.displayValor = displayValor;
    }

    public String getValorInterno() {
        return this.valorInterno;
    }

    public String getValorInternoTruncado(int casas) {
        String truncado = this.getConvertidoCasasDecimais(this.getValorInterno(), casas).formatado();
        return truncado;
    }

    public String getValorFormatado() {
        ValorBigDecimal valorAtual = new ValorBigDecimal();
        valorAtual.setCasasDecimais(9);
        valorAtual.setConteudo(this.valorInterno);
        String parteDecimalStr = valorAtual.getParteDecimal();
        int parteDecimalInt = 0;
        if (!parteDecimalStr.equals("")) {
            parteDecimalInt = Integer.valueOf(parteDecimalStr);
        }
        if (parteDecimalInt > 0) {
            String lValor = valorAtual.getConteudoFormatado();
            int indice = this.verificarPrimeiroNaoZero(lValor);
            if (indice != lValor.length() - 1) {
                lValor = lValor.substring(0, indice + 1);
            }
            return lValor;
        }
        valorAtual.converteQtdCasasDecimais(0);
        return valorAtual.getConteudoFormatado();
    }

    private int verificarPrimeiroNaoZero(String pNumero) {
        for (int x = pNumero.length() - 1; x >= 0; --x) {
            if (pNumero.charAt(x) == '0') continue;
            return x;
        }
        return -1;
    }
}

