/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.bens;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JEditMascara;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.bens.Bens;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableAb;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.PainelPrincipalAb;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.TableListaSumario;
import serpro.ppgd.irpf.gui.bens.BensToolBarListener;
import serpro.ppgd.irpf.gui.bens.JIRPFToolbarBens;
import serpro.ppgd.irpf.gui.bens.PainelBensDetalhe;
import serpro.ppgd.irpf.gui.bens.PainelBensDetalheEspolio;
import serpro.ppgd.irpf.gui.bens.TableModelBens;
import serpro.ppgd.irpf.gui.componente.JEditNumeroProcesso;
import serpro.ppgd.irpf.gui.listener.ToolBarListener;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.IRPFTableDecorator;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarAb;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.CodigoTabelaMensagens;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;

public class PainelBensLista
extends PainelPrincipalAb
implements BensToolBarListener {
    private static final long serialVersionUID = 1L;
    public static final String TITULO = "Bens e Direitos";
    protected Bens colecao = null;
    private JCheckBox chkAtualizacaoValorBem;
    private JEditMascara edtNumeroProcesso;
    private JIRPFToolbarBens irpfToolbarBens;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JPanel pnlNumeroProcesso;
    private TableLista tableLista;

    public PainelBensLista() {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), this.getButtonHelpID());
        this.initComponents();
        this.getTabela().setRowHeight(30);
        this.configurarTamanhoColunas();
        IRPFTableDecorator.decorate((IRPFTableAb)this.getTabela(), (ToolBarListener)this);
        this.getTabela().getSelectionModel().addListSelectionListener(this.irpfToolbarBens);
        this.associarInformacao();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tableLista = this.instanciarTabela(this.getTableModel(), this.getColunaOrdenacao(), this.getColunasOrdenaveis());
        this.irpfToolbarBens = new JIRPFToolbarBens();
        this.chkAtualizacaoValorBem = new JCheckBox();
        this.pnlNumeroProcesso = new JPanel();
        this.jLabel1 = new JLabel();
        this.edtNumeroProcesso = new JEditNumeroProcesso();
        this.setBackground(new Color(241, 245, 249));
        this.jScrollPane1.setViewportView((Component)this.tableLista);
        this.irpfToolbarBens.addToolBarListener(this);
        this.chkAtualizacaoValorBem.setBackground(new Color(241, 245, 249));
        this.chkAtualizacaoValorBem.setFont(FontesUtil.FONTE_NORMAL);
        this.chkAtualizacaoValorBem.setText("Atualizou o valor de algum bem im\u00f3vel e pagou o ganho de capital at\u00e9 16/12/2024 de acordo com a Lei n\u00ba 14.973/2024?");
        this.chkAtualizacaoValorBem.setPreferredSize(new Dimension(503, 30));
        this.chkAtualizacaoValorBem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensLista.this.chkAtualizacaoValorBemActionPerformed(evt);
            }
        });
        this.pnlNumeroProcesso.setBackground(new Color(241, 245, 249));
        this.pnlNumeroProcesso.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jLabel1.setText("N\u00famero do Processo:");
        GroupLayout pnlNumeroProcessoLayout = new GroupLayout((Container)this.pnlNumeroProcesso);
        this.pnlNumeroProcesso.setLayout((LayoutManager)pnlNumeroProcessoLayout);
        pnlNumeroProcessoLayout.setHorizontalGroup((GroupLayout.Group)pnlNumeroProcessoLayout.createParallelGroup(1).add((GroupLayout.Group)pnlNumeroProcessoLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.edtNumeroProcesso, -2, 200, -2).addContainerGap(87, Short.MAX_VALUE)));
        pnlNumeroProcessoLayout.setVerticalGroup((GroupLayout.Group)pnlNumeroProcessoLayout.createParallelGroup(1).add((GroupLayout.Group)pnlNumeroProcessoLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.edtNumeroProcesso, -2, -1, -2)));
        this.edtNumeroProcesso.getAccessibleContext().setAccessibleName("N\u00famero do Processo:");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.irpfToolbarBens, -1, -1, Short.MAX_VALUE).add((Component)this.jScrollPane1).add((Component)this.chkAtualizacaoValorBem, -1, 831, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pnlNumeroProcesso, -2, -1, -2).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.chkAtualizacaoValorBem, -2, -1, -2).add(4, 4, 4).add((Component)this.pnlNumeroProcesso, -2, -1, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 249, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.irpfToolbarBens, -2, -1, -2)));
    }

    private void chkAtualizacaoValorBemActionPerformed(ActionEvent evt) {
        if (this.chkAtualizacaoValorBem.isSelected()) {
            IRPFFacade.getInstancia().getBens().getExisteAtualizacaoValorBem().setConteudo(Logico.SIM);
        } else {
            IRPFFacade.getInstancia().getBens().getExisteAtualizacaoValorBem().setConteudo(Logico.NAO);
            for (Bem bem : IRPFFacade.getInstancia().getBens().itens()) {
                bem.getAtualizadoValorBem().setConteudo(Logico.NAO);
            }
        }
        this.pnlNumeroProcesso.setVisible(this.chkAtualizacaoValorBem.isSelected());
    }

    private void associarInformacao() {
        this.edtNumeroProcesso.setInformacao((Informacao)IRPFFacade.getInstancia().getBens().getNumeroProcessoAtualizacaoValorBem());
    }

    public IRPFTableAb getTabela() {
        return this.tableLista;
    }

    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(5);
        tcm.getColumn(1).setPreferredWidth(5);
        tcm.getColumn(2).setPreferredWidth(5);
        tcm.getColumn(3).setPreferredWidth(100);
        tcm.getColumn(4).setPreferredWidth(200);
        tcm.getColumn(5).setPreferredWidth(50);
        tcm.getColumn(6).setPreferredWidth(50);
    }

    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableListaSumario tableListaSumario2 = new TableListaSumario(model, colunaOrdenacao, colunasOrdenaveis);
        tableListaSumario2.accessibleColumnHeader = new String[]{"Item", "C\u00f3digo", "Localiza\u00e7\u00e3o", "Discrimina\u00e7\u00e3o", this.getTableModel().getColumnName(4).replace("<html><center>", "").replace("R$</center></html>", "").replace("<br>", " "), this.getTableModel().getColumnName(5).replace("<html><center>", "").replace("R$</center></html>", "").replace("<br>", " ")};
        return tableListaSumario2;
    }

    protected String getClassePainelNavegacao() {
        return PainelBensDetalhe.class.getName();
    }

    protected String getButtonHelpID() {
        return "Fichas da Declara\u00e7\u00e3o/Bens e Direitos";
    }

    protected TableListaModel getTableModel() {
        return new TableModelBens(IRPFFacade.getInstancia().getBens());
    }

    protected int getColunaOrdenacao() {
        return 1;
    }

    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1};
    }

    private void excluirRendimentosAssociados(IRPFTableAb tabela, int[] linhasSelecionadas) {
        for (int i = 0; i < linhasSelecionadas.length; ++i) {
            int indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhasSelecionadas[i]);
            IRPFTableModelAb model = (IRPFTableModelAb)tabela.getModel();
            this.colecao = (Bens)model.getObjetoNegocio();
            Bem bemSelecionado = (Bem)this.colecao.itens().get(indiceVetor);
            String tipoRendIsento = bemSelecionado.buscarTipoRendimentoIsento(bemSelecionado.getGrupo().naoFormatado(), bemSelecionado.getCodigo().naoFormatado());
            ItemQuadroAuxiliarAb rendIsentoSelecionado = bemSelecionado.buscarRendimentoIsentoAssociado(tipoRendIsento, ControladorGui.getDemonstrativoAberto());
            ControladorGui.getDemonstrativoAberto().getRendIsentos().excluirRendimento(tipoRendIsento, rendIsentoSelecionado);
            String tipoRendExclusivo = bemSelecionado.buscarTipoRendimentoExclusivo(bemSelecionado.getGrupo().naoFormatado(), bemSelecionado.getCodigo().naoFormatado());
            ItemQuadroAuxiliarAb rendExclusivoSelecionado = bemSelecionado.buscarRendimentoExclusivoAssociado(tipoRendExclusivo, ControladorGui.getDemonstrativoAberto());
            ControladorGui.getDemonstrativoAberto().getRendTributacaoExclusiva().excluirRendimento(tipoRendExclusivo, rendExclusivoSelecionado);
        }
    }

    private boolean verificarRendimentosAssociados(IRPFTableAb tabela, int linhaSelecionada) {
        String tipoRendExclusivo;
        boolean existe = false;
        int indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaSelecionada);
        IRPFTableModelAb model = (IRPFTableModelAb)tabela.getModel();
        this.colecao = (Bens)model.getObjetoNegocio();
        Bem bemSelecionado = (Bem)this.colecao.itens().get(indiceVetor);
        ItemQuadroAuxiliarAb rendIsentoSelecionado = null;
        ItemQuadroAuxiliarAb rendExclusivoSelecionado = null;
        String tipoRendIsento = bemSelecionado.buscarTipoRendimentoIsento(bemSelecionado.getGrupo().naoFormatado(), bemSelecionado.getCodigo().naoFormatado());
        if (tipoRendIsento != null) {
            rendIsentoSelecionado = bemSelecionado.buscarRendimentoIsentoAssociado(tipoRendIsento, ControladorGui.getDemonstrativoAberto());
        }
        if (rendIsentoSelecionado == null && (tipoRendExclusivo = bemSelecionado.buscarTipoRendimentoExclusivo(bemSelecionado.getGrupo().naoFormatado(), bemSelecionado.getCodigo().naoFormatado())) != null) {
            rendExclusivoSelecionado = bemSelecionado.buscarRendimentoExclusivoAssociado(tipoRendExclusivo, ControladorGui.getDemonstrativoAberto());
        }
        if (rendIsentoSelecionado != null || rendExclusivoSelecionado != null) {
            existe = true;
        }
        return existe;
    }

    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0 && this.getTabela().getSelectedRow() < this.getTabela().getRowCount() - 1) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            IRPFTableModelAb model = (IRPFTableModelAb)this.getTabela().getModel();
            Bens colecao = (Bens)model.getObjetoNegocio();
            Bem bem = (Bem)colecao.itens().get(indiceVetor);
            if (this.isEspolio()) {
                ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelBensDetalheEspolio(bem, true));
            } else {
                ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelBensDetalhe(bem, true));
            }
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    private boolean isEspolio() {
        return IRPFFacade.getInstancia().getIdDeclaracaoAberto().isEspolio();
    }

    public void onBtnExcluirClick(ActionEvent e) {
        IRPFTableAb tabela = this.getTabela();
        if (tabela.getSelectedRowCount() > 0 && tabela.getSelectedRow() < tabela.getRowCount() - 1) {
            int[] linhasTabela = tabela.getSelectedRows();
            String msgConfirmaExclusao = null;
            boolean excluirRendimentos = false;
            if (linhasTabela.length == 1) {
                if (this.verificarRendimentosAssociados(tabela, linhasTabela[0])) {
                    msgConfirmaExclusao = MensagemUtil.getMensagem((String)"bem_com_rendimento_excluir");
                    excluirRendimentos = true;
                } else {
                    msgConfirmaExclusao = MensagemUtil.getMensagem((String)"ConfirmaExcluirItens1", (String[])new String[]{"bem(ns)"});
                }
            } else {
                msgConfirmaExclusao = MensagemUtil.getMensagem((String)"bem_exclusao_multipla");
                excluirRendimentos = true;
            }
            if (GuiUtil.mostrarConfirma((Component)((Object)this), (String)msgConfirmaExclusao)) {
                if (excluirRendimentos) {
                    this.excluirRendimentosAssociados(tabela, linhasTabela);
                }
                ArrayList<Bem> listaRemocao = new ArrayList<Bem>(linhasTabela.length);
                Bens colecao = new Bens(null, null);
                for (int linhaTabela : linhasTabela) {
                    int indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela);
                    IRPFTableModelAb model = (IRPFTableModelAb)tabela.getModel();
                    colecao = (Bens)model.getObjetoNegocio();
                    listaRemocao.add((Bem)colecao.itens().get(indiceVetor));
                }
                colecao.itens().removeAll(listaRemocao);
            }
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public void onBtnNovoClick(ActionEvent e) {
        Bem bem = ControladorGui.getDemonstrativoAberto().getBens().instanciaNovoObjeto();
        IRPFFacade.getInstancia().getBens().itens().add(bem);
        if (this.isEspolio()) {
            ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelBensDetalheEspolio(bem, false));
        } else {
            ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelBensDetalhe(bem, false));
        }
    }

    @Override
    public void onBtnRepetirClick(ActionEvent e) {
        IRPFTableAb tabela = this.getTabela();
        if (tabela.getSelectedRowCount() >= 0 && tabela.getSelectedRow() < tabela.getRowCount() - 1) {
            int[] linhasTabela = tabela.getSelectedRows();
            IRPFTableModelAb model = (IRPFTableModelAb)tabela.getModel();
            for (int linhaTabela : linhasTabela) {
                int indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela);
                Bens colecao = (Bens)model.getObjetoNegocio();
                Bem bem = (Bem)colecao.itens().get(indiceVetor);
                bem.getValorExercicioAtual().setConteudo(bem.getValorExercicioAnterior());
            }
            model.refresh();
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_bens.png");
    }

    public void preExibir() {
        IRPFFacade.getInstancia().getBens().reordenaPorCodigo();
        ((Bens)((IRPFTableModelAb)this.getTabela().getModel()).getObjetoNegocio()).excluirRegistrosEmBranco();
        ((IRPFTableModelAb)this.getTabela().getModel()).refresh();
        IRPFTableAb table = this.getTabela();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            table.getColumnModel().getColumn(i).setHeaderValue(table.getModel().getColumnName(i));
        }
        table.getTableHeader().repaint();
        boolean existeAtualizacaoValorBem = IRPFFacade.getInstancia().getBens().getExisteAtualizacaoValorBem().naoFormatado().equals(Logico.SIM);
        this.chkAtualizacaoValorBem.setSelected(existeAtualizacaoValorBem);
        this.pnlNumeroProcesso.setVisible(existeAtualizacaoValorBem);
    }

    public JComponent getDefaultFocus() {
        return this.chkAtualizacaoValorBem;
    }

    public String getMensagemTela() {
        return CadastroTabelasIRPF.recuperarMensagemHTML((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00506);
    }

    public boolean isTelaComMensagem() {
        return true;
    }

    public JIRPFToolbarBens getIrpfToolbar() {
        return this.irpfToolbarBens;
    }

    public Bens getColecao() {
        return this.colecao;
    }

    public String getHelpID() {
        return this.getButtonHelpID();
    }

    public String getTituloPainel() {
        return TITULO;
    }

    public boolean isTelaComFavoritos() {
        return true;
    }
}

