/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dependentes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JButtonGroupPanel;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditCPF;
import serpro.ppgd.gui.xbeans.JEditData;
import serpro.ppgd.gui.xbeans.JEditMascara;
import serpro.ppgd.gui.xbeans.JEditTelefone;
import serpro.ppgd.gui.xbeans.PPGDRadioItem;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCodigo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFLabelInfo;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.componente.JEditValorTotal;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.TipoDeclaracaoAES;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelDependentesDetalhe
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "Dependentes";
    private static final String HELP_ID = "Fichas da Declara\u00e7\u00e3o/Dependentes";
    private boolean isSaida = false;
    private Dependente dependente = null;
    private String strCpfDependente = null;
    private PainelDemonstrativoIf painelPai;
    private boolean emEdicao;
    private Dependente itemInicial = null;
    private JButtonGroupPanel btnGrpSaiuMesmaData;
    private JButtonMensagem btnMensagemSaiuMesmaData;
    private JCheckBox chkMoraComTitular;
    private JAutoCompleteEditCodigo cmbTipoDependente;
    public JEditTelefone edtCelular;
    private JEditCPF edtCpf;
    public JEditMascara edtDDD;
    private JEditData edtDataNascimento;
    public JEditAlfa edtEmail;
    private JEditAlfa edtNome;
    private JEditValorTotal edtTotalDeducao;
    private JLabel jLabel17;
    private JPanel jPanel2;
    private JLabel lblCelular;
    private JLabel lblCpf;
    private JLabel lblDDD;
    private JLabel lblDataNascimento;
    private IRPFLabelInfo lblInfoCelular;
    private JLabel lblNome;
    private JLabel lblSaiuMesmaData;
    private JLabel lblTipoDependente;
    private JLabel lblTitulo;
    private JLabel lblTotalDeducao;
    private JPanel pnlSaiuNaMesmaData;
    private PPGDRadioItem rdbNao;
    private PPGDRadioItem rdbSim;

    public PainelDependentesDetalhe(PainelDemonstrativoIf painelPai, Dependente dependente, boolean emEdicao) {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
        this.painelPai = painelPai;
        this.initComponents();
        this.dependente = dependente;
        this.emEdicao = emEdicao;
        this.isSaida = IRPFFacade.getInstancia().getIdDeclaracaoAberto().getTipoDeclaracaoAES().formatado().equals(TipoDeclaracaoAES.SAIDA.getTipo());
        PPGDRadioItem radioVazio = new PPGDRadioItem();
        radioVazio.setText("Vazio");
        radioVazio.setValorSelecionadoTrue("2");
        this.btnGrpSaiuMesmaData.adicionaOpcao((Component)radioVazio);
        this.configuraIndicadorSaidaDependente();
        this.configuraIndicadorTitularExterior();
        this.associarInformacao();
        this.edtCpf.getComponenteEditor().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!PainelDependentesDetalhe.this.strCpfDependente.equals(PainelDependentesDetalhe.this.edtCpf.getInformacao().naoFormatado())) {
                    if (!IRPFFacade.getInstancia().getDependentes().isExisteCpf(PainelDependentesDetalhe.this.strCpfDependente) && !IRPFFacade.getInstancia().getDependentes().confirmaExclusaoImportacoesDependente(PainelDependentesDetalhe.this.edtNome.getInformacao().naoFormatado(), PainelDependentesDetalhe.this.strCpfDependente, false)) {
                        PainelDependentesDetalhe.this.edtCpf.getInformacao().setConteudo(PainelDependentesDetalhe.this.strCpfDependente);
                    } else {
                        PainelDependentesDetalhe.this.strCpfDependente = PainelDependentesDetalhe.this.edtCpf.getInformacao().naoFormatado();
                    }
                }
            }
        });
        this.strCpfDependente = this.edtCpf.getInformacao().naoFormatado();
        if (emEdicao) {
            this.itemInicial = dependente.obterCopia();
        }
    }

    private void associarInformacao() {
        if (this.dependente.getIndSaidaPaisMesmaData().isVazio()) {
            this.dependente.getIndSaidaPaisMesmaData().setConteudo("2");
        }
        this.btnGrpSaiuMesmaData.setInformacao((Informacao)this.dependente.getIndSaidaPaisMesmaData());
        this.cmbTipoDependente.setInformacao((Informacao)this.dependente.getCodigo());
        this.edtNome.setInformacao((Informacao)this.dependente.getNome());
        this.edtCpf.setInformacao((Informacao)this.dependente.getCpfDependente());
        this.edtDataNascimento.setInformacao((Informacao)this.dependente.getDataNascimento());
        this.edtDDD.setInformacao((Informacao)this.dependente.getDdd());
        this.edtCelular.setInformacao((Informacao)this.dependente.getTelefone());
        this.edtEmail.setInformacao((Informacao)this.dependente.getEmail());
    }

    private void configuraIndicadorSaidaDependente() {
        boolean visivel = this.isSaida;
        this.pnlSaiuNaMesmaData.setVisible(visivel);
    }

    private void configuraIndicadorTitularExterior() {
        boolean enderecoBrasil = IRPFFacade.getInstancia().getContribuinte().getExterior().naoFormatado().equals(Logico.NAO);
        boolean moraComTitular = "1".equals(this.dependente.getIndMoraComTitular().naoFormatado());
        this.lblDDD.setVisible(enderecoBrasil || !moraComTitular);
        this.edtDDD.setVisible(enderecoBrasil || !moraComTitular);
        this.lblCelular.setVisible(enderecoBrasil || !moraComTitular);
        this.edtCelular.setVisible(enderecoBrasil || !moraComTitular);
    }

    private void initComponents() {
        this.lblTitulo = new JLabel();
        this.jPanel2 = new JPanel();
        this.lblTipoDependente = new JLabel();
        this.cmbTipoDependente = new JAutoCompleteEditCodigo();
        this.lblNome = new JLabel();
        this.edtNome = new JEditAlfa();
        this.lblCpf = new JLabel();
        this.edtCpf = new JEditCPF();
        this.lblDataNascimento = new JLabel();
        this.edtDataNascimento = new JEditData();
        this.pnlSaiuNaMesmaData = new JPanel();
        this.btnGrpSaiuMesmaData = new JButtonGroupPanel();
        this.rdbSim = new PPGDRadioItem();
        this.rdbNao = new PPGDRadioItem();
        this.btnMensagemSaiuMesmaData = new JButtonMensagem();
        this.lblSaiuMesmaData = new JLabel();
        this.chkMoraComTitular = new JCheckBox();
        this.jLabel17 = new JLabel();
        this.edtEmail = new JEditAlfa();
        this.lblDDD = new JLabel();
        this.edtDDD = new JEditMascara();
        this.lblCelular = new JLabel();
        this.edtCelular = new JEditTelefone();
        this.lblInfoCelular = new IRPFLabelInfo(MensagemUtil.getMensagem((String)"info_celular"), true);
        this.lblTotalDeducao = new JLabel();
        this.edtTotalDeducao = new JEditValorTotal();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.lblTitulo.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblTitulo.setForeground(new Color(0, 74, 106));
        this.lblTitulo.setText("Dados do Dependente");
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.lblTipoDependente.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTipoDependente.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblTipoDependente.setLabelFor((Component)this.cmbTipoDependente);
        this.lblTipoDependente.setText("Tipo de Dependente");
        this.cmbTipoDependente.setToolTipText("Tipo de Dependente");
        this.lblNome.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNome.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNome.setLabelFor((Component)this.edtNome);
        this.lblNome.setText("Nome");
        this.lblCpf.setFont(FontesUtil.FONTE_NORMAL);
        this.lblCpf.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblCpf.setLabelFor((Component)this.edtCpf);
        this.lblCpf.setText("CPF");
        this.lblDataNascimento.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDataNascimento.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDataNascimento.setLabelFor((Component)this.edtDataNascimento);
        this.lblDataNascimento.setText("Data de Nascimento");
        this.pnlSaiuNaMesmaData.setBorder(null);
        this.pnlSaiuNaMesmaData.setOpaque(false);
        this.btnGrpSaiuMesmaData.setBorder(null);
        this.btnGrpSaiuMesmaData.setButtonMensagem(this.btnMensagemSaiuMesmaData);
        this.rdbSim.setBackground(new Color(255, 255, 255));
        this.rdbSim.setText("Sim");
        this.rdbSim.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbSim.setValorSelecionadoTrue(Logico.SIM);
        this.rdbSim.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelDependentesDetalhe.this.rdbSimFocusLost(evt);
            }
        });
        this.rdbNao.setBackground(new Color(255, 255, 255));
        this.rdbNao.setText("N\u00e3o");
        this.rdbNao.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbNao.setValorSelecionadoTrue(Logico.NAO);
        this.rdbNao.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelDependentesDetalhe.this.rdbNaoFocusLost(evt);
            }
        });
        GroupLayout btnGrpSaiuMesmaDataLayout = new GroupLayout((Container)this.btnGrpSaiuMesmaData);
        this.btnGrpSaiuMesmaData.setLayout((LayoutManager)btnGrpSaiuMesmaDataLayout);
        btnGrpSaiuMesmaDataLayout.setHorizontalGroup((GroupLayout.Group)btnGrpSaiuMesmaDataLayout.createParallelGroup(1).add(2, (GroupLayout.Group)btnGrpSaiuMesmaDataLayout.createSequentialGroup().add((Component)this.rdbSim, -1, 90, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.rdbNao, -2, 89, -2)));
        btnGrpSaiuMesmaDataLayout.setVerticalGroup((GroupLayout.Group)btnGrpSaiuMesmaDataLayout.createParallelGroup(1).add((GroupLayout.Group)btnGrpSaiuMesmaDataLayout.createParallelGroup(3).add((Component)this.rdbSim, -2, 14, -2).add((Component)this.rdbNao, -2, 14, -2)));
        this.btnMensagemSaiuMesmaData.setText("jButtonMensagem1");
        this.lblSaiuMesmaData.setFont(FontesUtil.FONTE_NORMAL);
        this.lblSaiuMesmaData.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblSaiuMesmaData.setLabelFor((Component)this.btnGrpSaiuMesmaData);
        this.lblSaiuMesmaData.setText("Saiu do pa\u00eds na mesma data que o declarante?");
        GroupLayout pnlSaiuNaMesmaDataLayout = new GroupLayout((Container)this.pnlSaiuNaMesmaData);
        this.pnlSaiuNaMesmaData.setLayout((LayoutManager)pnlSaiuNaMesmaDataLayout);
        pnlSaiuNaMesmaDataLayout.setHorizontalGroup((GroupLayout.Group)pnlSaiuNaMesmaDataLayout.createParallelGroup(1).add((GroupLayout.Group)pnlSaiuNaMesmaDataLayout.createSequentialGroup().add((Component)this.btnGrpSaiuMesmaData, -2, -1, -2).addPreferredGap(0).add((Component)this.btnMensagemSaiuMesmaData, -2, -1, -2)).add((Component)this.lblSaiuMesmaData));
        pnlSaiuNaMesmaDataLayout.setVerticalGroup((GroupLayout.Group)pnlSaiuNaMesmaDataLayout.createParallelGroup(1).add((GroupLayout.Group)pnlSaiuNaMesmaDataLayout.createSequentialGroup().add((Component)this.lblSaiuMesmaData).addPreferredGap(0).add((GroupLayout.Group)pnlSaiuNaMesmaDataLayout.createParallelGroup(1).add((Component)this.btnGrpSaiuMesmaData, -2, -1, -2).add((Component)this.btnMensagemSaiuMesmaData, -2, -1, -2))));
        this.chkMoraComTitular.setBackground(new Color(255, 255, 255));
        this.chkMoraComTitular.setText("Dependente mora com o titular da declara\u00e7\u00e3o?");
        this.chkMoraComTitular.setVerticalTextPosition(1);
        this.chkMoraComTitular.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelDependentesDetalhe.this.chkMoraComTitularActionPerformed(evt);
            }
        });
        this.jLabel17.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel17.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel17.setText("E-mail");
        this.edtEmail.setToolTipText("Informe o e-mail");
        this.edtEmail.setInformacaoAssociada("contribuinte.email");
        this.lblDDD.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDDD.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDDD.setText("DDD 0xx");
        this.edtDDD.setToolTipText("Informe o DDD do telefone");
        this.edtDDD.setCaracteresValidos("0123456789 ");
        this.edtDDD.setInformacaoAssociada("contribuinte.ddd");
        this.edtDDD.setMascara("**'");
        this.lblCelular.setFont(FontesUtil.FONTE_NORMAL);
        this.lblCelular.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblCelular.setText("Celular");
        this.edtCelular.setToolTipText("Informe n\u00ba do telefone com 9 d\u00edgitos.");
        this.edtCelular.setInformacaoAssociada("contribuinte.telefone");
        this.edtCelular.setMascara("*****-****");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel17).add((Component)this.edtEmail, -2, 310, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.lblDDD).add((Component)this.edtDDD, -2, 69, -2)).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.lblCelular).add((Component)this.edtCelular, -2, 116, -2)).add(0, 0, 0).add((Component)this.lblInfoCelular, -2, -1, -2).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.lblCpf).add((Component)this.edtCpf, -2, 148, -2)).add(30, 30, 30).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.lblDataNascimento).add((Component)this.edtDataNascimento, -2, 110, -2))).add((Component)this.pnlSaiuNaMesmaData, -2, -1, -2).add((Component)this.chkMoraComTitular).add((Component)this.lblTipoDependente).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.cmbTipoDependente, -2, 795, -2).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.edtNome, -2, 575, -2).add((Component)this.lblNome)).add(220, 220, 220)))).addContainerGap(-1, Short.MAX_VALUE)))));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.lblTipoDependente).addPreferredGap(0).add((Component)this.cmbTipoDependente, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.lblCpf).add((Component)this.lblDataNascimento)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.edtDataNascimento, -2, -1, -2).add((Component)this.edtCpf, -2, -1, -2)).addPreferredGap(1).add((Component)this.lblNome).addPreferredGap(0).add((Component)this.edtNome, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel17).addPreferredGap(0).add((Component)this.edtEmail, -2, -1, -2)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.lblDDD).add((Component)this.lblCelular)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (Component)this.edtCelular, -2, -1, -2).add(2, (Component)this.edtDDD, -2, -1, -2))).add((Component)this.lblInfoCelular, -2, 43, -2)).add(12, 12, 12).add((Component)this.chkMoraComTitular).add(10, 10, 10).add((Component)this.pnlSaiuNaMesmaData, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.cmbTipoDependente.getAccessibleContext().setAccessibleName("Tipo de dependente");
        this.edtNome.getAccessibleContext().setAccessibleName("Nome");
        this.edtCpf.getAccessibleContext().setAccessibleName("CPF");
        this.edtDataNascimento.getAccessibleContext().setAccessibleName("Data de nascimento");
        this.edtEmail.getAccessibleContext().setAccessibleName("email");
        this.edtDDD.getAccessibleContext().setAccessibleName("DDD");
        this.edtCelular.getAccessibleContext().setAccessibleName("Celular");
        this.lblTotalDeducao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTotalDeducao.setLabelFor((Component)this.edtTotalDeducao);
        this.lblTotalDeducao.setText("Total de dedu\u00e7\u00e3o com dependentes:");
        this.edtTotalDeducao.setInformacaoAssociada("dependentes.totalDeducaoDependentes");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lblTitulo).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblTotalDeducao).addPreferredGap(0).add((Component)this.edtTotalDeducao, -2, 139, -2))).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lblTitulo).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblTotalDeducao, -2, 24, -2).add((Component)this.edtTotalDeducao, -1, 30, Short.MAX_VALUE)).addContainerGap()));
        this.edtTotalDeducao.getAccessibleContext().setAccessibleName("Total de dedu\u00e7\u00e3o com dependentes");
    }

    private void rdbSimFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdbNao) {
            this.btnGrpSaiuMesmaData.chamaValidacao();
        }
    }

    private void rdbNaoFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdbSim) {
            this.btnGrpSaiuMesmaData.chamaValidacao();
        }
    }

    private void chkMoraComTitularActionPerformed(ActionEvent evt) {
        this.dependente.getIndMoraComTitular().setConteudo(this.chkMoraComTitular.isSelected() ? "1" : "0");
        this.configuraIndicadorTitularExterior();
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_depend.png");
    }

    public JComponent getDefaultFocus() {
        return this.cmbTipoDependente;
    }

    public String getTituloPainel() {
        boolean ehTransmitida = IRPFFacade.getInstancia().getDeclaracao().getCopiaIdentificador().isTransmitida();
        if (this.emEdicao) {
            if (ehTransmitida) {
                return "Detalhe Dependente";
            }
            return "Editar Dependente";
        }
        return "Novo Dependente";
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public void executaVoltar() {
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_DEPENDENTES);
    }

    public boolean isTelaComCancelar() {
        return true;
    }

    public void executaCancelar() {
        if (this.emEdicao) {
            int posicao = ControladorGui.getDemonstrativoAberto().getDependentes().itens().indexOf(this.dependente);
            ControladorGui.getDemonstrativoAberto().getDependentes().remove((ObjetoNegocio)this.dependente);
            ControladorGui.getDemonstrativoAberto().getDependentes().itens().add(posicao, this.itemInicial);
        } else {
            ControladorGui.getDemonstrativoAberto().getDependentes().remove((ObjetoNegocio)this.dependente);
        }
        ControladorGui.acionarPainel((PainelDemonstrativoIf)this.getPainelPai());
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public boolean isTelaComFavoritos() {
        return false;
    }

    public PainelDemonstrativoIf getPainelPai() {
        return this.painelPai;
    }

    public void preExibir() {
        this.chkMoraComTitular.setSelected(this.dependente.getIndMoraComTitular().naoFormatado().equals("1"));
        this.chkMoraComTitular.setVisible(IRPFFacade.getInstancia().getIdDeclaracaoAberto().isAjuste());
    }
}

