/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dependentes;

import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.dependentes.Dependentes;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.PainelListaAb;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.TableListaSumario;
import serpro.ppgd.irpf.gui.dependentes.PainelDependentesDetalhe;
import serpro.ppgd.irpf.gui.dependentes.TableModelDependentes;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelDependentesLista
extends PainelListaAb {
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "Dependentes";

    protected String getButtonHelpID() {
        return "Fichas da Declara\u00e7\u00e3o/Dependentes";
    }

    protected String getClassePainelNavegacao() {
        return PainelDependentesDetalhe.class.getName();
    }

    public String getTituloPainel() {
        return TITULO;
    }

    protected int getColunaOrdenacao() {
        return 1;
    }

    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1, 2};
    }

    protected TableListaModel getTableModel() {
        return new TableModelDependentes(IRPFFacade.getInstancia().getDependentes());
    }

    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableListaSumario tableListaSumario2 = new TableListaSumario(model, colunaOrdenacao, colunasOrdenaveis);
        tableListaSumario2.accessibleColumnHeader = new String[]{"Item", "C\u00f3digo", "Nome", "Data de Nascimento", "CPF"};
        return tableListaSumario2;
    }

    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(5);
        tcm.getColumn(1).setPreferredWidth(5);
        tcm.getColumn(2).setPreferredWidth(200);
        tcm.getColumn(3).setPreferredWidth(50);
        tcm.getColumn(4).setPreferredWidth(50);
    }

    public void onBtnNovoClick(ActionEvent e) {
        TableModelDependentes lModel = (TableModelDependentes)((Object)this.getTabela().getModel());
        Dependente lItem = new Dependente(IRPFFacade.getInstancia().getDeclaracao());
        IRPFFacade.getInstancia().getDependentes().itens().add(lItem);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelDependentesDetalhe((PainelDemonstrativoIf)this, lItem, false));
        lModel.refresh();
    }

    public void onBtnAbrirClick(ActionEvent e) {
        boolean temSumario = this.getTabela() instanceof TableListaSumario;
        if (!(this.getTabela().getSelectedRow() < 0 || temSumario && this.getTabela().getSelectedRow() >= this.getTabela().getRowCount() - 1)) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            IRPFTableModelAb model = (IRPFTableModelAb)this.getTabela().getModel();
            Dependentes colDependentes = (Dependentes)model.getObjetoNegocio();
            Dependente dependente = (Dependente)colDependentes.itens().get(indiceVetor);
            ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelDependentesDetalhe((PainelDemonstrativoIf)this, dependente, true));
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public boolean validarExclusao(ObjetoNegocio objetoNegocio) {
        Dependente dependente = (Dependente)objetoNegocio;
        return IRPFFacade.getInstancia().getDependentes().countCpf(dependente.getCpfDependente().naoFormatado()) > 1 || IRPFFacade.getInstancia().getDependentes().confirmaExclusaoImportacoesDependente(dependente.getNome().naoFormatado(), dependente.getCpfDependente().naoFormatado(), true);
    }

    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens1";
    }

    public String[] getParametrosMensagemExclusao() {
        return new String[]{"dependente(s)"};
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_depend.png");
    }

    public String getMensagemTela() {
        Object retorno = null;
        retorno = IRPFFacade.getInstancia().getDeclaracao().getIdentificadorDeclaracao().isAjuste() ? "<html>Ao preencher esta ficha, o contribuinte deve incluir na declara\u00e7\u00e3o todas as informa\u00e7\u00f5es dos dependentes relacionados, tais como rendimentos tribut\u00e1veis, isentos e n\u00e3o tribut\u00e1veis, bens, direitos, d\u00edvidas, pagamentos efetuados, independentemente da forma de tributa\u00e7\u00e3o, utilizando as dedu\u00e7\u00f5es legais cab\u00edveis ou o desconto simplificado de 20% dos rendimentos tribut\u00e1veis, limitado a R$" + TabelaAliquotasIRPF.ConstantesAliquotas.descontoLimiteDPadrao.getValor().formatado() + ".<br><br>Utilize o bot\u00e3o 'Excluir', caso pretenda excluir um dependente relacionado e todas as suas informa\u00e7\u00f5es constantes nas fichas Dependentes, Rendimentos Tribut\u00e1veis Recebidos de PJ pelos Dependentes, Rendimentos Tribut\u00e1veis Recebidos de Pessoa F\u00edsica e do Exterior pelos Dependentes, Pagamentos Efetuados, Bens e Direitos pertencentes aos Dependentes, Ganhos de Capital, Renda Vari\u00e1vel, Rendimentos Tribut\u00e1veis Recebidos de PJ pelos Dependentes com Exigibilidade Suspensa e Rendimentos Recebidos Acumuladamente pelos Dependentes.</html>" : "<html>Ao preencher esta ficha, o contribuinte deve incluir na declara\u00e7\u00e3o todas as informa\u00e7\u00f5es dos dependentes relacionados, tais como: rendimentos tribut\u00e1veis, isentos e n\u00e3o tribut\u00e1veis, bens, direitos, d\u00edvidas, pagamentos efetuados.<br><br>Utilize o bot\u00e3o 'Excluir', caso pretenda excluir um dependente relacionado e todas as suas informa\u00e7\u00f5es constantes nas fichas Dependentes, Rendimentos Tribut\u00e1veis Recebidos de PJ pelos Dependentes, Rendimentos Tribut\u00e1veis Recebidos de Pessoa F\u00edsica e do Exterior pelos Dependentes, Pagamentos Efetuados, Bens e Direitos pertencentes aos Dependentes, Ganhos de Capital, Renda Vari\u00e1vel, Rendimentos Tribut\u00e1veis Recebidos de PJ pelos Dependentes com Exigibilidade Suspensa e Rendimentos Recebidos Acumuladamente pelos Dependentes.</html>";
        return retorno;
    }

    public boolean isTelaComMensagem() {
        return true;
    }

    public String getHelpID() {
        return this.getButtonHelpID();
    }

    public boolean isTelaComFavoritos() {
        return true;
    }
}

