/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dividas;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import serpro.ppgd.gui.xbeans.JEditMemo;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCodigo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.dividas.Divida;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.TransferFocus;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelDividasDetalhe
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "D\u00edvidas e \u00d4nus Reais";
    private static final String HELP_ID = "Fichas da Declara\u00e7\u00e3o/D\u00edvidas e \u00d4nus Reais";
    private PainelDemonstrativoIf painelPai;
    private boolean emEdicao;
    private Divida divida = null;
    private Divida itemInicial = null;
    private JAutoCompleteEditCodigo cboCodigoDivida;
    private JEditMemo edtDiscriminacao;
    private JEditValor edtValorAnterior;
    private JEditValor edtValorAtual;
    private JEditValor edtValorPgtoAnual;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JLabel lbSituacaoAnoAnterior;
    private JLabel lbSituacaoAnoAtual;
    private JLabel lbValorPgtoAnual;

    public PainelDividasDetalhe() {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
        this.initComponents();
    }

    public PainelDividasDetalhe(PainelDemonstrativoIf painelPai, Divida divida, boolean emEdicao) {
        this();
        this.painelPai = painelPai;
        this.emEdicao = emEdicao;
        this.divida = divida;
        this.associarInformacao(divida);
        if (emEdicao) {
            this.itemInicial = divida.obterCopia();
        }
        TransferFocus.patch((Component)this.edtDiscriminacao.getComponenteFoco());
    }

    protected void associarInformacao(Divida divida) {
        this.cboCodigoDivida.setInformacao((Informacao)divida.getCodigo());
        this.edtDiscriminacao.setInformacao((Informacao)divida.getDiscriminacao());
        this.edtValorAnterior.setInformacao((Informacao)divida.getValorExercicioAnterior());
        this.edtValorAtual.setInformacao((Informacao)divida.getValorExercicioAtual());
        this.edtValorPgtoAnual.setInformacao((Informacao)divida.getValorPgtoAnual());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cboCodigoDivida = new JAutoCompleteEditCodigo();
        this.jLabel2 = new JLabel();
        this.edtDiscriminacao = new JEditMemo();
        this.jLabel3 = new JLabel();
        this.lbSituacaoAnoAnterior = new JLabel();
        this.edtValorAnterior = new JEditValor();
        this.lbSituacaoAnoAtual = new JLabel();
        this.edtValorAtual = new JEditValor();
        this.lbValorPgtoAnual = new JLabel();
        this.edtValorPgtoAnual = new JEditValor();
        this.jLabel1 = new JLabel();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.cboCodigoDivida.setToolTipText("C\u00f3digo");
        this.jLabel2.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel2.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel2.setLabelFor((Component)this.cboCodigoDivida);
        this.jLabel2.setText("C\u00f3digo");
        this.edtDiscriminacao.setMaxChars(512);
        this.jLabel3.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel3.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel3.setLabelFor((Component)this.edtDiscriminacao);
        this.jLabel3.setText("Discrimina\u00e7\u00e3o");
        this.lbSituacaoAnoAnterior.setFont(FontesUtil.FONTE_NORMAL);
        this.lbSituacaoAnoAnterior.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lbSituacaoAnoAnterior.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
        this.lbSituacaoAnoAtual.setFont(FontesUtil.FONTE_NORMAL);
        this.lbSituacaoAnoAtual.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lbSituacaoAnoAtual.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE + " (R$)");
        this.lbValorPgtoAnual.setFont(FontesUtil.FONTE_NORMAL);
        this.lbValorPgtoAnual.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lbValorPgtoAnual.setText("Valor Pago em " + ConstantesGlobais.ANO_BASE + " (R$)");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent((Component)this.cboCodigoDivida, -1, -1, Short.MAX_VALUE).addComponent((Component)this.edtDiscriminacao, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lbSituacaoAnoAnterior, -1, -1, Short.MAX_VALUE).addComponent((Component)this.edtValorAnterior, -1, 192, Short.MAX_VALUE)).addGap(34, 34, 34).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lbSituacaoAnoAtual, -1, -1, Short.MAX_VALUE).addComponent((Component)this.edtValorAtual, -1, 198, Short.MAX_VALUE)).addGap(34, 34, 34).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtValorPgtoAnual, -1, -1, Short.MAX_VALUE).addComponent(this.lbValorPgtoAnual, -1, -1, Short.MAX_VALUE)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, new Component[]{this.edtValorAnterior, this.edtValorAtual});
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cboCodigoDivida, -2, -1, -2).addGap(12, 12, 12).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtDiscriminacao, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbSituacaoAnoAnterior, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbSituacaoAnoAtual).addComponent(this.lbValorPgtoAnual))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.edtValorAnterior, -2, -1, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtValorAtual, -2, -1, -2).addComponent((Component)this.edtValorPgtoAnual, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.edtDiscriminacao.getAccessibleContext().setAccessibleName("Discrimina\u00e7\u00e3o");
        this.edtValorAnterior.getAccessibleContext().setAccessibleName("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
        this.edtValorAtual.getAccessibleContext().setAccessibleName("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE + " (R$)");
        this.edtValorPgtoAnual.getAccessibleContext().setAccessibleName("Valor Pago em " + ConstantesGlobais.ANO_BASE + "(R$)");
        this.jLabel1.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Dados da D\u00edvida");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_dividas.png");
    }

    public JComponent getDefaultFocus() {
        return this.cboCodigoDivida;
    }

    public String getTituloPainel() {
        boolean ehTransmitida = IRPFFacade.getInstancia().getDeclaracao().getCopiaIdentificador().isTransmitida();
        if (this.emEdicao) {
            if (ehTransmitida) {
                return "Detalhe D\u00edvida e \u00d4nus Reais";
            }
            return "Editar D\u00edvida e \u00d4nus Reais";
        }
        return "Novo D\u00edvida e \u00d4nus Reais";
    }

    public void executaVoltar() {
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_DIVIDAS_ONUS_REAIS);
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public boolean isTelaComCancelar() {
        return true;
    }

    public void executaCancelar() {
        if (this.emEdicao) {
            int posicao = ControladorGui.getDemonstrativoAberto().getDividas().itens().indexOf(this.divida);
            ControladorGui.getDemonstrativoAberto().getDividas().remove((ObjetoNegocio)this.divida);
            ControladorGui.getDemonstrativoAberto().getDividas().itens().add(posicao, this.itemInicial);
        } else {
            ControladorGui.getDemonstrativoAberto().getDividas().remove((ObjetoNegocio)this.divida);
        }
        ControladorGui.acionarPainel((PainelDemonstrativoIf)this.getPainelPai());
    }

    public PainelDemonstrativoIf getPainelPai() {
        return this.painelPai;
    }

    public void preExibir() {
        this.alterarLabel();
    }

    private void alterarLabel() {
        if (this.isEspolio()) {
            this.lbSituacaoAnoAtual.setText("Situa\u00e7\u00e3o na data da partilha (R$)");
        } else if (this.isSaida()) {
            if (ControladorGui.getDemonstrativoAberto().entrouSaiuNoMesmoAno()) {
                this.lbSituacaoAnoAnterior.setText("<HTML>Situa\u00e7\u00e3o na data da caracteriza\u00e7\u00e3o<BR>da condi\u00e7\u00e3o de residente (R$)</HTML>");
            } else {
                this.lbSituacaoAnoAnterior.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
            }
            this.lbSituacaoAnoAtual.setText("<HTML>Situa\u00e7\u00e3o na data da caracteriza\u00e7\u00e3o<BR>da condi\u00e7\u00e3o de n\u00e3o residente (R$)</HTML>");
        } else {
            this.lbSituacaoAnoAtual.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE + " (R$)");
        }
    }

    private boolean isEspolio() {
        return IRPFFacade.getInstancia().getIdDeclaracaoAberto().isEspolio();
    }

    private boolean isSaida() {
        return IRPFFacade.getInstancia().getIdDeclaracaoAberto().isSaida();
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public boolean isTelaComFavoritos() {
        return false;
    }
}

