/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.map.MapPrintElement;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class MapElementImageProvider {
    public static Integer MAX_URL_LENGTH = 2048;

    public static JRPrintImage getImage(JRGenericPrintElement element) throws JRException {
        return MapElementImageProvider.getImage(DefaultJasperReportsContext.getInstance(), element);
    }

    public static JRPrintImage getImage(JasperReportsContext jasperReportsContext, JRGenericPrintElement element) throws JRException {
        String color;
        Float latitude = (Float)element.getParameterValue("latitude");
        latitude = latitude == null ? MapPrintElement.DEFAULT_LATITUDE : latitude;
        Float longitude = (Float)element.getParameterValue("longitude");
        longitude = longitude == null ? MapPrintElement.DEFAULT_LONGITUDE : longitude;
        Integer zoom = (Integer)element.getParameterValue("zoom");
        zoom = zoom == null ? MapPrintElement.DEFAULT_ZOOM : zoom;
        String mapType = (String)element.getParameterValue("mapType");
        String mapScale = (String)element.getParameterValue("mapScale");
        String mapFormat = (String)element.getParameterValue("imageType");
        String reqParams = (String)element.getParameterValue("reqParams");
        String markers = "";
        List markerList = (List)element.getParameterValue("markers");
        if (markerList != null && !markerList.isEmpty()) {
            String currentMarkers = "";
            for (Map map : markerList) {
                String icon;
                if (map == null || map.isEmpty()) continue;
                currentMarkers = "&markers=";
                String size = (String)map.get("size");
                currentMarkers = String.valueOf(currentMarkers) + (size != null && size.length() > 0 ? "size:" + (String)size + "%7C" : "");
                color = (String)map.get("color");
                currentMarkers = String.valueOf(currentMarkers) + (color != null && color.length() > 0 ? "color:0x" + color + "%7C" : "");
                String label = (String)map.get("label");
                currentMarkers = String.valueOf(currentMarkers) + (label != null && label.length() > 0 ? "label:" + Character.toUpperCase(label.charAt(0)) + "%7C" : "");
                String string = icon = map.get("icon.url") != null ? (String)map.get("icon.url") : (String)map.get("icon");
                if (icon != null && icon.length() > 0) {
                    currentMarkers = String.valueOf(currentMarkers) + "icon:" + icon + "%7C";
                }
                currentMarkers = String.valueOf(currentMarkers) + map.get("latitude");
                currentMarkers = String.valueOf(currentMarkers) + ",";
                currentMarkers = String.valueOf(currentMarkers) + map.get("longitude");
                markers = String.valueOf(markers) + currentMarkers;
            }
        }
        List pathList = (List)element.getParameterValue("paths");
        String currentPaths = "";
        if (pathList != null && !pathList.isEmpty()) {
            for (Map pathMap : pathList) {
                if (pathMap == null || pathMap.isEmpty()) continue;
                currentPaths = String.valueOf(currentPaths) + "&path=";
                color = (String)pathMap.get("strokeColor");
                if (color != null && color.length() > 0) {
                    color = JRColorUtil.getColorHexa(JRColorUtil.getColor(color, Color.BLACK));
                    color = String.valueOf(color) + (pathMap.get("strokeOpacity") == null || pathMap.get("strokeOpacity").toString().length() == 0 ? "ff" : Integer.toHexString((int)(255.0 * Double.valueOf(pathMap.get("strokeOpacity").toString()))));
                }
                currentPaths = String.valueOf(currentPaths) + (color != null && color.length() > 0 ? "color:0x" + color.toLowerCase() + "%7C" : "");
                Boolean isPolygon = pathMap.get("isPolygon") == null ? false : Boolean.valueOf(pathMap.get("isPolygon").toString());
                if (isPolygon.booleanValue()) {
                    String fillColor = (String)pathMap.get("fillColor");
                    if (fillColor != null && fillColor.length() > 0) {
                        fillColor = JRColorUtil.getColorHexa(JRColorUtil.getColor(fillColor, Color.WHITE));
                        fillColor = String.valueOf(fillColor) + (pathMap.get("fillOpacity") == null || pathMap.get("fillOpacity").toString().length() == 0 ? "00" : Integer.toHexString((int)(256.0 * Double.valueOf(pathMap.get("fillOpacity").toString()))));
                    }
                    currentPaths = String.valueOf(currentPaths) + (fillColor != null && fillColor.length() > 0 ? "fillcolor:0x" + fillColor.toLowerCase() + "%7C" : "");
                }
                String weight = pathMap.get("strokeWeight") == null ? null : pathMap.get("strokeWeight").toString();
                currentPaths = String.valueOf(currentPaths) + (weight != null && weight.length() > 0 ? "weight:" + Integer.valueOf(weight) + "%7C" : "");
                List locations = (List)pathMap.get("locations");
                Map location = null;
                if (locations == null || locations.isEmpty()) continue;
                int i = 0;
                while (i < locations.size()) {
                    location = (Map)locations.get(i);
                    currentPaths = String.valueOf(currentPaths) + location.get("latitude");
                    currentPaths = String.valueOf(currentPaths) + ",";
                    currentPaths = String.valueOf(currentPaths) + location.get("longitude");
                    currentPaths = String.valueOf(currentPaths) + (i < locations.size() - 1 ? "%7C" : "");
                    ++i;
                }
                if (!isPolygon.booleanValue()) continue;
                currentPaths = String.valueOf(currentPaths) + "%7C";
                currentPaths = String.valueOf(currentPaths) + ((Map)locations.get(0)).get("latitude");
                currentPaths = String.valueOf(currentPaths) + ",";
                currentPaths = String.valueOf(currentPaths) + ((Map)locations.get(0)).get("longitude");
            }
        }
        String imageLocation = "http://maps.google.com/maps/api/staticmap?center=" + latitude + "," + longitude + "&size=" + element.getWidth() + "x" + element.getHeight() + "&zoom=" + zoom + (mapType == null ? "" : "&maptype=" + mapType) + (mapFormat == null ? "" : "&format=" + mapFormat) + (mapScale == null ? "" : "&scale=" + mapScale);
        String params = "&sensor=false" + (reqParams == null ? "" : reqParams);
        imageLocation = String.valueOf(imageLocation) + (imageLocation.length() + markers.length() + currentPaths.length() + params.length() < MAX_URL_LENGTH ? String.valueOf(markers) + currentPaths + params : (imageLocation.length() + markers.length() + params.length() < MAX_URL_LENGTH ? String.valueOf(markers) + params : params));
        JRBasePrintImage printImage = new JRBasePrintImage(element.getDefaultStyleProvider());
        printImage.setUUID(element.getUUID());
        printImage.setX(element.getX());
        printImage.setY(element.getY());
        printImage.setWidth(element.getWidth());
        printImage.setHeight(element.getHeight());
        printImage.setStyle(element.getStyle());
        printImage.setMode(element.getModeValue());
        printImage.setBackcolor(element.getBackcolor());
        printImage.setForecolor(element.getForecolor());
        printImage.setLazy(false);
        printImage.setScaleImage(ScaleImageEnum.RETAIN_SHAPE);
        printImage.setHorizontalAlignment(HorizontalAlignEnum.LEFT);
        printImage.setVerticalAlignment(VerticalAlignEnum.TOP);
        Renderable cacheRenderer = (Renderable)element.getParameterValue("cacheRenderer");
        OnErrorTypeEnum onErrorType = element.getParameterValue("onErrorType") == null ? MapPrintElement.DEFAULT_ON_ERROR_TYPE : OnErrorTypeEnum.getByName((String)element.getParameterValue("onErrorType"));
        printImage.setOnErrorType(onErrorType);
        if (cacheRenderer == null && (cacheRenderer = RenderableUtil.getInstance(jasperReportsContext).getRenderable(imageLocation, onErrorType, false)) != null) {
            cacheRenderer.getImageData(jasperReportsContext);
            element.setParameterValue("cacheRenderer", cacheRenderer);
        }
        printImage.setRenderable(cacheRenderer);
        return printImage;
    }
}

