/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JROriginProvider;

public class JRFillSection
implements JRSection,
JROriginProvider {
    protected JRBaseFiller filler;
    protected JRFillBand[] bands;
    protected JROrigin origin;
    private boolean isEmpty = true;
    private boolean areAllPrintWhenExprNull = true;

    protected JRFillSection(JRBaseFiller filler, JRSection section, JRFillObjectFactory factory) {
        if (section != null) {
            factory.put(section, this);
            this.isEmpty = true;
            this.areAllPrintWhenExprNull = true;
            JRBand[] jrBands = section.getBands();
            if (jrBands != null && jrBands.length > 0) {
                this.bands = new JRFillBand[jrBands.length];
                int i = 0;
                while (i < jrBands.length) {
                    this.bands[i] = factory.getBand(jrBands[i]);
                    this.isEmpty = this.isEmpty && this.bands[i].isEmpty();
                    this.areAllPrintWhenExprNull = this.areAllPrintWhenExprNull && this.bands[i].isPrintWhenExpressionNull();
                    ++i;
                }
            } else {
                this.bands = new JRFillBand[]{filler.missingFillBand};
            }
        } else {
            this.bands = new JRFillBand[]{filler.missingFillBand};
        }
        this.filler = filler;
    }

    @Override
    public JROrigin getOrigin() {
        return this.origin;
    }

    protected void setOrigin(JROrigin origin) {
        this.origin = origin;
        if (this.bands.length > 0) {
            int i = 0;
            while (i < this.bands.length) {
                this.bands[i].setOrigin(origin);
                ++i;
            }
        }
        this.filler.getJasperPrint().addOrigin(origin);
    }

    public JRFillBand[] getFillBands() {
        return this.bands;
    }

    @Override
    public JRBand[] getBands() {
        return this.bands;
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    protected boolean isEmpty() {
        return this.isEmpty;
    }

    protected boolean areAllPrintWhenExpressionsNull() {
        return this.areAllPrintWhenExprNull;
    }

    protected void setNewPageColumn(boolean isNew) {
        int i = 0;
        while (i < this.bands.length) {
            this.bands[i].setNewPageColumn(isNew);
            ++i;
        }
    }

    protected void setNewGroup(JRGroup group, boolean isNew) {
        int i = 0;
        while (i < this.bands.length) {
            this.bands[i].setNewGroup(group, isNew);
            ++i;
        }
    }

    protected void addNowEvaluationTime(JREvaluationTime evaluationTime) {
        int i = 0;
        while (i < this.bands.length) {
            this.bands[i].addNowEvaluationTime(evaluationTime);
            ++i;
        }
    }
}

