/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.parameters;

import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.export.parameters.ParameterResolver;

public class ParameterOverriddenResolver
implements ParameterResolver {
    private final JRPropertiesUtil propertiesUtil;
    private final JasperPrint jasperPrint;
    private final Map<JRExporterParameter, Object> parameters;

    public ParameterOverriddenResolver(JasperReportsContext jasperReportsContext, JasperPrint jasperPrint, Map<JRExporterParameter, Object> parameters) {
        this.propertiesUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
        this.jasperPrint = jasperPrint;
        this.parameters = parameters;
    }

    @Override
    public String getStringParameter(JRExporterParameter parameter, String property) {
        String value;
        JRPropertiesMap hintsMap = this.jasperPrint.getPropertiesMap();
        if (hintsMap != null && hintsMap.containsProperty(property)) {
            value = hintsMap.getProperty(property);
        } else {
            value = (String)this.parameters.get(parameter);
            if (value == null) {
                value = this.getPropertiesUtil().getProperty(property);
            }
        }
        return value;
    }

    @Override
    public String[] getStringArrayParameter(JRExporterParameter parameter, String propertyPrefix) {
        String[] values = null;
        JRPropertiesMap hintsMap = this.jasperPrint.getPropertiesMap();
        if (hintsMap != null) {
            List<JRPropertiesUtil.PropertySuffix> properties = JRPropertiesUtil.getProperties(hintsMap, propertyPrefix);
            if (properties != null && !properties.isEmpty()) {
                values = new String[properties.size()];
                int i = 0;
                while (i < values.length) {
                    values[i] = properties.get(i).getValue();
                    ++i;
                }
            }
        } else {
            values = (String[])this.parameters.get(parameter);
        }
        return values;
    }

    @Override
    public String getStringParameterOrDefault(JRExporterParameter parameter, String property) {
        JRPropertiesMap hintsMap = this.jasperPrint.getPropertiesMap();
        String value = hintsMap != null && hintsMap.containsProperty(property) ? hintsMap.getProperty(property) : (String)this.parameters.get(parameter);
        if (value == null) {
            value = this.getPropertiesUtil().getProperty(property);
        }
        return value;
    }

    @Override
    public boolean getBooleanParameter(JRExporterParameter parameter, String property, boolean defaultValue) {
        Boolean param;
        String prop;
        JRPropertiesMap hintsMap = this.jasperPrint.getPropertiesMap();
        boolean value = hintsMap != null && hintsMap.containsProperty(property) ? ((prop = hintsMap.getProperty(property)) == null ? this.getPropertiesUtil().getBooleanProperty(property) : JRPropertiesUtil.asBoolean(prop)) : ((param = (Boolean)this.parameters.get(parameter)) == null ? this.getPropertiesUtil().getBooleanProperty(property) : param.booleanValue());
        return value;
    }

    @Override
    public int getIntegerParameter(JRExporterParameter parameter, String property, int defaultValue) {
        Integer param;
        String prop;
        JRPropertiesMap hintsMap = this.jasperPrint.getPropertiesMap();
        int value = hintsMap != null && hintsMap.containsProperty(property) ? ((prop = hintsMap.getProperty(property)) == null ? this.getPropertiesUtil().getIntegerProperty(property) : JRPropertiesUtil.asInteger(prop)) : ((param = (Integer)this.parameters.get(parameter)) == null ? this.getPropertiesUtil().getIntegerProperty(property) : param.intValue());
        return value;
    }

    @Override
    public float getFloatParameter(JRExporterParameter parameter, String property, float defaultValue) {
        Float param;
        String prop;
        JRPropertiesMap hintsMap = this.jasperPrint.getPropertiesMap();
        float value = hintsMap != null && hintsMap.containsProperty(property) ? ((prop = hintsMap.getProperty(property)) == null ? this.getPropertiesUtil().getFloatProperty(property) : JRPropertiesUtil.asFloat(prop)) : ((param = (Float)this.parameters.get(parameter)) == null ? this.getPropertiesUtil().getFloatProperty(property) : param.floatValue());
        return value;
    }

    @Override
    public Character getCharacterParameter(JRExporterParameter parameter, String property) {
        Character value;
        JRPropertiesMap hintsMap = this.jasperPrint.getPropertiesMap();
        if (hintsMap != null && hintsMap.containsProperty(property)) {
            String prop = hintsMap.getProperty(property);
            value = JRPropertiesUtil.asCharacter(prop);
        } else {
            value = (Character)this.parameters.get(parameter);
            if (value == null) {
                value = this.getPropertiesUtil().getCharacterProperty(property);
            }
        }
        return value;
    }

    private JRPropertiesUtil getPropertiesUtil() {
        return this.propertiesUtil;
    }
}

