/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.web.WebReportContext;
import net.sf.jasperreports.web.servlets.AbstractServlet;
import net.sf.jasperreports.web.util.VelocityUtil;
import net.sf.jasperreports.web.util.WebUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ViewerServlet
extends AbstractServlet {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(ViewerServlet.class);
    public static final String PROPERTY_TEMPLATE_HEADER = "net.sf.jasperreports.web.servlets.viewer.header.template";
    public static final String PROPERTY_TEMPLATE_BODY = "net.sf.jasperreports.web.servlets.viewer.body.template";
    public static final String PROPERTY_TEMPLATE_FOOTER = "net.sf.jasperreports.web.servlets.viewer.footer.template";
    private String headerTemplate;
    private String bodyTemplate;
    private String footerTemplate;

    public void init() throws ServletException {
        super.init();
        this.headerTemplate = this.getInitParameter(PROPERTY_TEMPLATE_HEADER);
        this.bodyTemplate = this.getInitParameter(PROPERTY_TEMPLATE_BODY);
        this.footerTemplate = this.getInitParameter(PROPERTY_TEMPLATE_FOOTER);
    }

    public String getHeaderTemplate() {
        if (this.headerTemplate == null) {
            return JRPropertiesUtil.getInstance(this.getJasperReportsContext()).getProperty(PROPERTY_TEMPLATE_HEADER);
        }
        return this.headerTemplate;
    }

    public String getBodyTemplate() {
        if (this.bodyTemplate == null) {
            return JRPropertiesUtil.getInstance(this.getJasperReportsContext()).getProperty(PROPERTY_TEMPLATE_BODY);
        }
        return this.bodyTemplate;
    }

    public String getFooterTemplate() {
        if (this.footerTemplate == null) {
            return JRPropertiesUtil.getInstance(this.getJasperReportsContext()).getProperty(PROPERTY_TEMPLATE_FOOTER);
        }
        return this.footerTemplate;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html; charset=UTF-8");
        response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        PrintWriter out = response.getWriter();
        WebReportContext webReportContext = WebReportContext.getInstance(request);
        try {
            this.render(request, webReportContext, out);
        }
        catch (Exception e) {
            log.error((Object)"Error on report execution", (Throwable)e);
            out.println("<html>");
            out.println("<head>");
            out.println("<title>JasperReports - Web Application Sample</title>");
            out.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"../stylesheet.css\" title=\"Style\">");
            out.println("</head>");
            out.println("<body bgcolor=\"white\">");
            out.println("<span class=\"bnew\">JasperReports encountered this error :</span>");
            out.println("<pre>");
            e.printStackTrace(out);
            out.println("</pre>");
            out.println("</body>");
            out.println("</html>");
        }
    }

    public void render(HttpServletRequest request, WebReportContext webReportContext, PrintWriter writer) {
        writer.write(this.getHeader(request, webReportContext));
        writer.write(this.getBody(request, webReportContext));
        writer.write(this.getFooter());
    }

    protected String getHeader(HttpServletRequest request, WebReportContext webReportContext) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        WebUtil webUtil = WebUtil.getInstance(this.getJasperReportsContext());
        String webResourcesBasePath = webUtil.getResourcesBasePath();
        contextMap.put("contextPath", request.getContextPath());
        contextMap.put("resourcesPath", String.valueOf(request.getContextPath()) + webResourcesBasePath);
        contextMap.put("jasperreports_global_css", String.valueOf(request.getContextPath()) + webUtil.getResourcePath(webResourcesBasePath, "net/sf/jasperreports/web/servlets/resources/jasperreports-global.css"));
        return VelocityUtil.processTemplate(this.getHeaderTemplate(), contextMap);
    }

    protected String getBody(HttpServletRequest request, WebReportContext webReportContext) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        String reportUri = request.getParameter("jr_report_uri");
        contextMap.put("reportUri", reportUri);
        contextMap.put("async", Boolean.valueOf(request.getParameter("jr_async")));
        String reportPage = request.getParameter("jr_page");
        int pageIdx = reportPage == null ? 0 : Integer.parseInt(reportPage);
        contextMap.put("page", pageIdx);
        contextMap.put("contextPath", request.getContextPath());
        return VelocityUtil.processTemplate(this.getBodyTemplate(), contextMap);
    }

    protected String getFooter() {
        return VelocityUtil.processTemplate(this.getFooterTemplate(), new HashMap<String, Object>());
    }
}

