/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.gcap.bensmoveis;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.app.acoes.ImportarGCAPAction;
import serpro.ppgd.irpf.gcap.ObjetoGCAP;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBemMovel;
import serpro.ppgd.irpf.gcap.alienacao.ColecaoAlienacaoBemMovel;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableAb;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.PainelListaAb;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.gcap.bensmoveis.PainelDadosBensMoveis;
import serpro.ppgd.irpf.gui.gcap.bensmoveis.TableModelBensMoveis;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelListaBemMovel
extends PainelListaAb {
    private static final long serialVersionUID = 1L;
    public static final String TITULO_PAINEL = "Direitos/Bens M\u00f3veis";

    public PainelListaBemMovel() {
        this.ajustarToolBarImportar();
    }

    public PainelListaBemMovel(Colecao<? extends ObjetoNegocio> colecao) {
        super(colecao);
        this.ajustarToolBarImportar();
    }

    public String getTituloPainel() {
        return TITULO_PAINEL;
    }

    public void onBtnNovoClick(ActionEvent e) {
        new ImportarGCAPAction().executarAcao(null);
    }

    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            TableModelBensMoveis model = (TableModelBensMoveis)((Object)this.getTabela().getModel());
            ColecaoAlienacaoBemMovel colAlienacoes = (ColecaoAlienacaoBemMovel)model.getObjetoNegocio();
            AlienacaoBemMovel alienacao = (AlienacaoBemMovel)colAlienacoes.itens().get(indiceVetor);
            if (alienacao.isAlienacaoBrasil()) {
                alienacao.getNatureza().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarNaturezaGCAPBemMovelDireitos());
            } else {
                alienacao.getNatureza().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarNaturezaGCMEBemMovelDireitos());
            }
            ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelDadosBensMoveis(alienacao));
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public void onBtnExcluirClick(ActionEvent e) {
        IRPFTableAb tabela = this.getTabela();
        if (tabela.getSelectedRowCount() > 0 && tabela.getSelectedRow() <= tabela.getRowCount() - 1) {
            int[] linhasTabela = tabela.getSelectedRows();
            if (GuiUtil.mostrarConfirma((String)"gcap_excluir_cpf")) {
                ArrayList<AlienacaoBemMovel> listaRemocao = new ArrayList<AlienacaoBemMovel>(linhasTabela.length);
                ColecaoAlienacaoBemMovel colecao = null;
                for (int linhaTabela : linhasTabela) {
                    int indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela);
                    IRPFTableModelAb model = (IRPFTableModelAb)tabela.getModel();
                    colecao = (ColecaoAlienacaoBemMovel)model.getObjetoNegocio();
                    listaRemocao.add((AlienacaoBemMovel)colecao.itens().get(indiceVetor));
                }
                Object object = listaRemocao.iterator();
                while (object.hasNext()) {
                    AlienacaoBemMovel alienacao = (AlienacaoBemMovel)object.next();
                    ControladorGui.getDemonstrativoAberto().getGCAP().removerDemonstrativo((ObjetoGCAP)alienacao);
                }
                ControladorGui.getDemonstrativoAberto().getGCAP().recalcularConsolidacoes();
                ControladorGui.getDemonstrativoAberto().getGCAP().recalcularGCAPDeclaracaoIRPF();
                ControladorGui.getDemonstrativoAberto().getGCAP().atualizarCodigosOperacao();
            }
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(100);
        tcm.getColumn(1).setPreferredWidth(400);
        tcm.getColumn(2).setPreferredWidth(150);
        tcm.getColumn(3).setPreferredWidth(200);
        tcm.getColumn(4).setPreferredWidth(300);
    }

    protected TableListaModel getTableModel() {
        return new TableModelBensMoveis(ControladorGui.getDemonstrativoAberto().getGCAP().getBensMoveis());
    }

    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        tableLista.accessibleColumnHeader = new String[]{"Item", "Rela\u00e7\u00e3o de Bens M\u00f3veis Alienados"};
        return tableLista;
    }

    protected String getClassePainelNavegacao() {
        return PainelDadosBensMoveis.class.getName();
    }

    protected String getButtonHelpID() {
        return "Demonstrativo de Ganhos de Capital (GCAP 2022)";
    }

    protected int getColunaOrdenacao() {
        return 0;
    }

    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1};
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/GC_moveis.png");
    }

    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens1";
    }

    public String[] getParametrosMensagemExclusao() {
        return new String[]{"bens m\u00f3veis"};
    }

    public boolean isTelaComSubtitulo() {
        return false;
    }

    public String getSubtitulo() {
        return null;
    }

    public boolean isTelaComFavoritos() {
        return true;
    }
}

