/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.gcap.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.gcap.table.GCAPTableModelAb;
import serpro.ppgd.irpf.gui.table.JComponentCellEditor;
import serpro.ppgd.irpf.gui.table.JPPGDTable;
import serpro.ppgd.irpf.gui.table.editors.PPGDCellEditorIf;
import serpro.ppgd.irpf.gui.table.editors.PPGDDefaultEditor;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public abstract class GCAPTableAb
extends JPPGDTable {
    private static final long serialVersionUID = 1L;
    private char veioDoKeyListener = (char)32;
    private PPGDDefaultEditor editorDefault = null;
    protected String[] accessibleRowHeader;
    public String[] accessibleColumnHeader;
    private KeyAdapter defaultKeyAdapter;
    private FocusAdapter defaultFocusAdapter;

    protected abstract void iniciaModelVazio();

    public GCAPTableAb() {
        this(null);
    }

    public GCAPTableAb(TableModel model) {
        if (!PlataformaPPGD.isEmDesign()) {
            this.setSelectionMode(1);
            this.configurarToolTip();
            this.configuraLayoutHeader();
            if (model == null) {
                this.iniciaModelVazio();
            } else {
                this.setModel(model);
            }
            this.configuraLayout();
            this.setaDefaultRenderers();
            this.preparaEditores();
            this.configurarKeyListenerEditor();
            this.defaultKeyAdapter = new KeyAdapter(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void keyPressed(KeyEvent e) {
                    boolean eventosEhInclusao;
                    GCAPTableAb.this.setSurrendersFocusOnKeystroke(true);
                    int row = GCAPTableAb.this.getSelectedRow();
                    int col = GCAPTableAb.this.getSelectedColumn();
                    if (col == 0) {
                        return;
                    }
                    if (e.getKeyCode() == 123) {
                        Object coluna;
                        Object txtAviso = "";
                        if (GCAPTableAb.this.accessibleRowHeader != null) {
                            String linha = "".equals(GCAPTableAb.this.accessibleRowHeader[row]) ? String.valueOf(row + 1) : GCAPTableAb.this.accessibleRowHeader[row];
                            txtAviso = "Linha " + linha;
                        } else {
                            txtAviso = "Linha " + String.valueOf(row + 1);
                        }
                        if (GCAPTableAb.this.accessibleColumnHeader != null) {
                            coluna = "".equals(GCAPTableAb.this.accessibleColumnHeader[col]) ? "" : GCAPTableAb.this.accessibleColumnHeader[col];
                            txtAviso = (String)txtAviso + ". Coluna " + (String)coluna;
                        }
                        if (!"".equals(txtAviso)) {
                            coluna = new Aviso((String)txtAviso);
                        }
                    }
                    if (e.getKeyCode() == 10) {
                        GCAPTableAb.this.setSurrendersFocusOnKeystroke(true);
                        if (row != -1 && col != -1) {
                            if (!GCAPTableAb.this.isCellEditable(row, col)) {
                                GCAPTableAb.this.proximaCelula(row, col);
                                return;
                            }
                            GCAPTableAb.this.editarCelula(row, col);
                        }
                    }
                    if (e.getKeyCode() == 127) return;
                    if (e.getKeyCode() == 112) {
                        return;
                    }
                    int ch = e.getKeyCode();
                    boolean bl = eventosEhInclusao = ch != 9 && ch != 10 && ch != 8 && ch != 127 && ch != 37 && ch != 39 && ch != 38 && ch != 40 && ch != 16 && ch != 18 && !e.isAltDown() && !e.isShiftDown() && !e.isAltGraphDown() && !e.isControlDown();
                    if (!eventosEhInclusao) {
                        GCAPTableAb.this.setSurrendersFocusOnKeystroke(false);
                        return;
                    }
                    if (row != -1 && col != -1) {
                        PPGDCellEditorIf cellEditor = (PPGDCellEditorIf)GCAPTableAb.this.getCellEditor(row, col);
                        if (cellEditor.getEditCampo() instanceof JEditValor) {
                            boolean ehCaracterValido;
                            boolean bl2 = ehCaracterValido = Character.isDigit(e.getKeyChar()) || e.getKeyChar() == '-' || e.getKeyChar() == ',' || e.getKeyCode() == 10;
                            if (!ehCaracterValido) {
                                this.cancelaKeyTyped(e, cellEditor);
                                return;
                            }
                        }
                        GCAPTableAb.this.setValueAt("", row, col);
                        GCAPTableAb.this.veioDoKeyListener = e.getKeyChar();
                        return;
                    }
                    if (!(GCAPTableAb.this.getCellEditor(0, 0) instanceof PPGDCellEditorIf)) return;
                    PPGDCellEditorIf cellEditor = (PPGDCellEditorIf)GCAPTableAb.this.getCellEditor(0, 0);
                    this.cancelaKeyTyped(e, cellEditor);
                }

                private void cancelaKeyTyped(KeyEvent e, PPGDCellEditorIf cellEditor) {
                    GCAPTableAb.this.setSurrendersFocusOnKeystroke(false);
                    e.setKeyChar('\uffff');
                    e.consume();
                    UIManager.getLookAndFeel().provideErrorFeedback(cellEditor.getEditCampo().getComponenteFoco());
                    cellEditor.getEditCampo().getInformacao().disparaObservadores();
                }
            };
            this.addKeyListener(this.defaultKeyAdapter);
        }
    }

    public FocusAdapter getDefaultFocusAdapter() {
        return this.defaultFocusAdapter;
    }

    protected void configurarKeyListenerEditor() {
        this.addKeyListener(new KeyAdapter(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void keyPressed(KeyEvent e) {
                boolean ehCaracterValido;
                boolean eventosEhInclusao;
                GCAPTableAb.this.setSurrendersFocusOnKeystroke(true);
                int row = GCAPTableAb.this.getSelectedRow();
                int col = GCAPTableAb.this.getSelectedColumn();
                if (col == 0) {
                    return;
                }
                if (e.getKeyCode() == 10) {
                    GCAPTableAb.this.setSurrendersFocusOnKeystroke(true);
                    if (row != -1 && col != -1) {
                        if (!GCAPTableAb.this.isCellEditable(row, col)) {
                            GCAPTableAb.this.proximaCelula(row, col);
                            return;
                        }
                        GCAPTableAb.this.editarCelula(row, col);
                    } else {
                        GCAPTableAb.this.proximaCelula(0, 0);
                        return;
                    }
                }
                if (e.getKeyCode() == 127) return;
                if (e.getKeyCode() == 112) {
                    return;
                }
                int ch = e.getKeyCode();
                boolean bl = eventosEhInclusao = ch != 9 && ch != 10 && ch != 127 && ch != 37 && ch != 39 && ch != 38 && ch != 40 && ch != 16 && ch != 18 && ch != 8 && !e.isAltDown() && !e.isShiftDown() && !e.isAltGraphDown() && !e.isControlDown();
                if (!eventosEhInclusao) {
                    GCAPTableAb.this.setSurrendersFocusOnKeystroke(false);
                    return;
                }
                if (row == -1) return;
                if (col == -1) return;
                if (!GCAPTableAb.this.isCellEditable(row, col)) return;
                PPGDCellEditorIf cellEditor = (PPGDCellEditorIf)GCAPTableAb.this.getCellEditor(row, col);
                boolean bl2 = ehCaracterValido = Character.isDigit(e.getKeyChar()) || e.getKeyChar() == '-' || e.getKeyChar() == ',' || e.getKeyCode() == 10;
                if (!ehCaracterValido) {
                    this.cancelaKeyTyped(e, cellEditor);
                    return;
                }
                GCAPTableAb.this.setValueAt("", row, col);
                GCAPTableAb.this.veioDoKeyListener = e.getKeyChar();
            }

            private void cancelaKeyTyped(KeyEvent e, PPGDCellEditorIf cellEditor) {
                GCAPTableAb.this.setSurrendersFocusOnKeystroke(false);
                e.setKeyChar('\uffff');
                e.consume();
                UIManager.getLookAndFeel().provideErrorFeedback(cellEditor.getEditCampo().getComponenteFoco());
                cellEditor.getEditCampo().getInformacao().disparaObservadores();
            }
        });
    }

    protected boolean hasToolTip() {
        return true;
    }

    protected void configurarToolTip() {
        if (this.hasToolTip()) {
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent me) {
                    GCAPTableAb.this.setToolTipText("");
                    int lin = GCAPTableAb.this.rowAtPoint(new Point(me.getX(), me.getY()));
                    int col = GCAPTableAb.this.columnAtPoint(new Point(me.getX(), me.getY()));
                    String msg = null;
                    if (col != -1 && lin != -1 && col != 0) {
                        String info = "";
                        if (GCAPTableAb.this.getModel() instanceof GCAPTableModelAb) {
                            info = ((GCAPTableModelAb)GCAPTableAb.this.getModel()).getValorExibir(lin, col);
                        } else if (GCAPTableAb.this.getModel() instanceof IRPFTableModelAb) {
                            info = ((IRPFTableModelAb)GCAPTableAb.this.getModel()).getValorExibir(lin, col);
                        }
                        if (info != null) {
                            msg = "<HTML>" + info + "</HTML>";
                        }
                    }
                    GCAPTableAb.this.setToolTipText(msg);
                }
            });
        }
    }

    protected void setaDefaultRenderers() {
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void preparaEditores() {
        TableColumnModel cm = this.getColumnModel();
        this.setEditorDefault(new PPGDDefaultEditor((JEditCampo)new JEditValor((Informacao)new Valor())));
        this.getEditorDefault().setClickCountToStart(1);
        Font fonteDefault = new JLabel().getFont();
        this.getEditorDefault().getEditCampo().getComponenteEditor().setFont(fonteDefault);
        ((JTextField)this.getEditorDefault().getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GCAPTableAb.this.isEditing()) {
                    int row = GCAPTableAb.this.getEditingRow();
                    int col = GCAPTableAb.this.getEditingColumn();
                    GCAPTableAb.this.getColumnModel().getColumn(col).getCellEditor().stopCellEditing();
                    GCAPTableAb.this.proximaCelula(row, col);
                }
            }
        });
        this.defaultFocusAdapter = new FocusAdapter(){
            boolean keyListener = false;
            private int linhaEditada = -1;
            private int colunaEditada = -1;

            @Override
            public void focusGained(FocusEvent e) {
                String textoAjustado;
                this.linhaEditada = GCAPTableAb.this.getEditingRow();
                this.colunaEditada = GCAPTableAb.this.getEditingColumn();
                if (GCAPTableAb.this.veioDoKeyListener != ' ') {
                    ((JTextField)GCAPTableAb.this.getEditorDefault().getComponent()).setText(String.valueOf(GCAPTableAb.this.veioDoKeyListener));
                    GCAPTableAb.this.veioDoKeyListener = (char)32;
                    this.keyListener = true;
                }
                final String texto = textoAjustado = ((JTextField)GCAPTableAb.this.getEditorDefault().getComponent()).getText().trim();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int pos = texto.length();
                        if (keyListener) {
                            ((JTextField)GCAPTableAb.this.getEditorDefault().getComponent()).setSelectionStart(1);
                            ((JTextField)GCAPTableAb.this.getEditorDefault().getComponent()).setSelectionEnd(1);
                            keyListener = false;
                        } else {
                            ((JTextField)GCAPTableAb.this.getEditorDefault().getComponent()).setSelectionStart(0);
                            ((JTextField)GCAPTableAb.this.getEditorDefault().getComponent()).setSelectionEnd(pos);
                        }
                        GCAPTableAb.this.executaValidacaopreEdicao(colunaEditada, linhaEditada);
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (this.colunaEditada >= 0) {
                    GCAPTableAb.this.getColumnModel().getColumn(this.colunaEditada).getCellEditor().stopCellEditing();
                    GCAPTableAb.this.executaValidacaoAposEdicao(this.colunaEditada, this.linhaEditada);
                }
            }
        };
        this.getEditorDefault().getComponent().addFocusListener(this.defaultFocusAdapter);
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setCellEditor(this.instanciaCellEditor(i));
        }
    }

    protected TableCellEditor instanciaCellEditor(int col) {
        if (col == 0) {
            return new JComponentCellEditor();
        }
        return this.getEditorDefault();
    }

    public void selecionaCelula(int col, int lin) {
        this.setRowSelectionInterval(lin, lin);
        this.setColumnSelectionInterval(col, col);
    }

    public void editarCelula(int pRow, int pCol) {
        this.editCellAt(pRow, pCol);
        ((PPGDCellEditorIf)this.getColumnModel().getColumn(pCol).getCellEditor()).getEditCampo().getComponenteEditor().requestFocusInWindow();
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (ks.getKeyCode() == 10) {
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void setObjetoNegocio(ObjetoNegocio obj) {
        ((GCAPTableModelAb)this.getModel()).setObjetoNegocio(obj);
    }

    public void editingStopped(ChangeEvent e) {
        super.editingStopped(e);
        this.repaint();
    }

    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        JTextComponent component = (JTextComponent)super.prepareEditor(editor, row, column);
        Informacao inf = ((GCAPTableModelAb)this.getModel()).getInformacaoAt(row, column);
        component.setText(inf.getConteudoFormatado());
        return component;
    }

    public void setEditorDefault(PPGDDefaultEditor editorDefault) {
        this.editorDefault = editorDefault;
    }

    public PPGDDefaultEditor getEditorDefault() {
        return this.editorDefault;
    }

    protected void executaValidacaoAposEdicao(int col, int row) {
    }

    protected void executaValidacaopreEdicao(int col, int row) {
    }

    protected void configuraLayoutHeader() {
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setForeground(new Color(0, 76, 119));
        this.getTableHeader().setBackground(new Color(231, 245, 249));
        this.getTableHeader().setFont(this.getTableHeader().getFont().deriveFont(1));
    }

    protected void configuraLayout() {
        this.setShowGrid(true);
        this.setRowHeight(20);
    }

    public void proximaCelula(int row, int col) {
    }

    public KeyAdapter getDefaultKeyAdapter() {
        return this.defaultKeyAdapter;
    }

    public KeyAdapter setDefaultKeyAdapter(KeyAdapter defaultKeyAdapter) {
        this.defaultKeyAdapter = defaultKeyAdapter;
        return this.defaultKeyAdapter;
    }

    class Aviso
    extends JFrame
    implements Accessible {
        private String texto;

        Aviso(String texto) {
            this.texto = texto;
            JPanel p = new JPanel();
            p.setBackground(Color.WHITE);
            p.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            p.add((Component)new JLabel(texto), "Center");
            this.getContentPane().add(p);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    Aviso.this.close();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Aviso.this.close();
                }
            });
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    Aviso.this.close();
                }
            });
            this.setUndecorated(true);
            this.setLocationRelativeTo(null);
            this.pack();
            this.setVisible(true);
            this.requestFocusInWindow();
        }

        private void close() {
            this.setVisible(false);
            this.dispose();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleAviso();
            }
            return this.accessibleContext;
        }

        protected class AccessibleAviso
        extends JComponent.AccessibleJComponent {
            protected AccessibleAviso() {
                super((JComponent)((Object)GCAPTableAb.this));
            }

            @Override
            public String getAccessibleName() {
                return Aviso.this.texto;
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LABEL;
            }
        }
    }
}

