/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.DatatypeID;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.IntegerValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;

public class UnsignedIntegerDatatype
extends AbstractDatatype {
    protected IntegerValue lastUnsignedInteger;

    public UnsignedIntegerDatatype(QNameContext schemaType) {
        super(BuiltInType.UNSIGNED_INTEGER, schemaType);
    }

    public DatatypeID getDatatypeID() {
        return DatatypeID.exi_integer;
    }

    protected boolean isValidString(String value) {
        this.lastUnsignedInteger = IntegerValue.parse(value);
        if (this.lastUnsignedInteger != null) {
            return this.lastUnsignedInteger.isPositive();
        }
        return false;
    }

    public boolean isValid(Value value) {
        if (value instanceof IntegerValue) {
            this.lastUnsignedInteger = (IntegerValue)value;
            return this.lastUnsignedInteger.isPositive();
        }
        return this.isValidString(value.toString());
    }

    public void writeValue(QNameContext qnContext, EncoderChannel valueChannel, StringEncoder stringEncoder) throws IOException {
        valueChannel.encodeUnsignedIntegerValue(this.lastUnsignedInteger);
    }

    public Value readValue(QNameContext qnContext, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        return valueChannel.decodeUnsignedIntegerValue();
    }
}

