/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.xmlada;

import br.gov.serpro.midas.xmlada.DescricaoCampoAdabas;
import br.gov.serpro.midas.xmlada.DimCampoAdabas;
import br.gov.serpro.midas.xmlada.DocAmbiente;
import br.gov.serpro.midas.xmlada.DocConfig;
import br.gov.serpro.midas.xmlada.DocConsulta;
import br.gov.serpro.midas.xmlada.DocFileEstrutura;
import br.gov.serpro.midas.xmlada.DocTipos;
import br.gov.serpro.midas.xmlada.DomDocument;
import br.gov.serpro.midas.xmlada.SaxHandlerInsert;
import br.gov.serpro.midas.xmlada.TextBuffer;
import br.gov.serpro.midas.xmlada.Util;
import br.gov.serpro.sqladaj.SQLAdaJ;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class XMLAdaJ
extends SQLAdaJ {
    private boolean DEBUG = false;
    private final String versao = "1.0";
    private final String cXMLAdaIConfig = "XMLAdaI_Config.xml";
    private final String cAmbienteDefault = "DESENVOLVIMENTO";
    private final short cTAM_BUFFER = (short)32765;
    private final byte cMAX_ROWS = (byte)100;
    private String mCaminhoNomeXMLAdaIConfig;
    private String mUsuario;
    private String mSenha;
    private String mPerfil;
    private String mIP;
    private int mConexao;
    private String mParameter;
    private String mAmbiente;
    private String mNomeAmbiente;
    private static int mCodigoErro;
    private static String mDescricaoErro;
    private static String appPath;
    private int mCodigoRetornoSQLAda;
    private String mAreaRetornoSQLAda;
    private long mRows;
    private int mCountCmt;
    private int mCmtAtual;
    private int mCmtTotal;
    private String fileInsert;
    private boolean mInicializada;
    private boolean mConectada;
    private Vector descricaoCampos = new Vector();
    private String[] strcampos;
    private DocFileEstrutura docEstrutura;
    private DocTipos docTipos;
    private DocConfig docConfig;
    private DomDocument docxml;

    public XMLAdaJ() {
        appPath = System.getProperty("user.dir");
        System.setProperty("line.separator", "\n");
        XMLAdaJ.setErro(0, "");
        this.mConexao = -1;
        this.mRows = 0L;
        this.mParameter = "";
        this.mInicializada = false;
        this.mConectada = false;
    }

    public static void main(String[] args) {
        XMLAdaJ xmladaj = new XMLAdaJ();
        try {
            String dec = new String(Files.readAllBytes(FileSystems.getDefault().getPath("", args[0])));
            String xsl = new String(Files.readAllBytes(FileSystems.getDefault().getPath("", args[1])));
            PrintWriter pw = new PrintWriter(args[2]);
            pw.print(xmladaj.textoXml(dec, xsl, false));
            pw.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    public boolean connect() {
        block5: {
            block6: {
                int conexao;
                block7: {
                    XMLAdaJ.setErro(0, "");
                    if (!this.mInicializada) {
                        XMLAdaJ.setErro(-99, "(connect) Classe n\u00e3o foi inicializada.");
                        return false;
                    }
                    try {
                        if (this.mConectada) break block5;
                        if (this.mUsuario.length() <= 0 || this.mSenha.length() <= 0 || this.mPerfil.length() <= 0 || this.mIP.length() <= 0) break block6;
                        conexao = this.DEBUG ? 0 : this.SAConnect(this.mUsuario, this.mSenha, this.mPerfil, this.mIP);
                        if (conexao < 0) break block7;
                        this.mConexao = conexao;
                        this.mConectada = true;
                        return true;
                    }
                    catch (Exception e) {
                        XMLAdaJ.setErro(e.hashCode(), "(connect) " + e.getMessage());
                        return false;
                    }
                }
                XMLAdaJ.setErro(conexao, "(connect) " + this.strArea);
                return false;
            }
            XMLAdaJ.setErro(-90, "(connect) USU\u00c1RIO, SENHA, PERFIL OU IP n\u00e3o informados.");
            return false;
        }
        return true;
    }

    public boolean disconnect() {
        if (!this.mInicializada) {
            XMLAdaJ.setErro(-99, "(disconnect) Classe n\u00e3o foi inicializada.");
            return false;
        }
        if (this.mConectada) {
            int ret;
            block5: {
                try {
                    ret = this.DEBUG ? 0 : this.SADisconnect(this.mConexao);
                    this.mCodigoRetornoSQLAda = ret;
                    this.mAreaRetornoSQLAda = this.strArea;
                    this.mConectada = false;
                    if (ret < 0) break block5;
                    this.mConexao = -1;
                    return true;
                }
                catch (Exception e) {
                    XMLAdaJ.setErro(e.hashCode(), "(disconnect) " + e.getMessage());
                    return false;
                }
            }
            XMLAdaJ.setErro(ret, "(disconnect) " + this.strErro());
            return false;
        }
        return false;
    }

    public boolean setParameter(String strParameter, boolean efetiva) {
        this.mParameter = strParameter;
        if (!this.mParameter.equals("") && efetiva && !this.DEBUG) {
            this.comando("SET PARAMETER " + this.mParameter);
            if (this.mCodigoRetornoSQLAda < 0) {
                XMLAdaJ.setErro(this.mCodigoRetornoSQLAda, "(setParameter) " + this.mAreaRetornoSQLAda);
                return false;
            }
        }
        return true;
    }

    public boolean setParameter(String strParameter) {
        return this.setParameter(strParameter, true);
    }

    public boolean inicializa(String usuario, String senha, String ambiente, String fileAmbiente, String fileConfig) {
        boolean bInit;
        block15: {
            bInit = false;
            try {
                try {
                    XMLAdaJ.setErro(0, "");
                    String CaminhoNomeXMLAdaIConfig = fileConfig != null ? fileConfig : String.valueOf(appPath) + "\\" + "XMLAdaI_Config.xml";
                    this.mCaminhoNomeXMLAdaIConfig = CaminhoNomeXMLAdaIConfig;
                    this.docConfig = new DocConfig(this.mCaminhoNomeXMLAdaIConfig, appPath);
                    if (!this.docConfig.getOk()) {
                        XMLAdaJ.setErro(-98, "(inicializa) Arquivo de configura\u00e7\u00e3o " + this.mCaminhoNomeXMLAdaIConfig + " n\u00e3o pode ser carregado. Verifique se Existe ou est\u00e1 bem formado.");
                        break block15;
                    }
                    this.docConfig.setMaxRows(100L);
                    this.mUsuario = usuario;
                    this.mSenha = senha;
                    if (ambiente.length() == 0) {
                        ambiente = "DESENVOLVIMENTO";
                    }
                    if (fileAmbiente != null) {
                        if (fileAmbiente.length() == 0) {
                            fileAmbiente = this.docConfig.getAmbienteDefault();
                        }
                    } else {
                        fileAmbiente = this.docConfig.getAmbienteDefault();
                    }
                    if (Util.isFullPath(fileAmbiente)) {
                        this.docConfig.setCaminhoAmbientes(fileAmbiente);
                    } else {
                        this.docConfig.setCaminhoAmbientes(String.valueOf(this.docConfig.getCaminhoAmbientes()) + "\\" + fileAmbiente);
                    }
                    DocAmbiente docAmbiente = new DocAmbiente(this.docConfig.getCaminhoAmbientes(), ambiente);
                    if (docAmbiente.getOk()) {
                        if (docAmbiente.getAmbiente().length() > 0) {
                            this.mNomeAmbiente = ambiente;
                            this.mIP = docAmbiente.getNumeroIP();
                            this.mPerfil = docAmbiente.getPerfil();
                            this.mAmbiente = ambiente;
                            this.mInicializada = true;
                            bInit = true;
                        } else {
                            XMLAdaJ.setErro(-97, "(inicializa) Nome de Ambiente " + ambiente + " N\u00e3o encontrado.");
                        }
                        docAmbiente = null;
                    } else {
                        XMLAdaJ.setErro(-98, "(inicializa) Arquivo de ambiente " + this.docConfig.getCaminhoAmbientes() + " n\u00e3o pode ser carregado.  Verifique se existe ou est\u00e1 bem formado.");
                    }
                    this.mInicializada = true;
                }
                catch (Exception e) {
                    XMLAdaJ.setErro(e.hashCode(), "(inicializa) " + e.getMessage());
                    this.disconnect();
                }
            }
            catch (Throwable throwable) {}
        }
        return bInit;
    }

    public boolean inicializa(String usuario, String senha, String ambiente) {
        return this.inicializa(usuario, senha, ambiente, null, null);
    }

    public String comando(String comando) {
        if (!this.mInicializada) {
            XMLAdaJ.setErro(-99, "(command) Classe n\u00e3o foi inicializada.");
            return "";
        }
        if (!this.mConectada) {
            this.connect();
        }
        try {
            if (this.DEBUG) {
                this.mCodigoRetornoSQLAda = 10;
                this.mAreaRetornoSQLAda = this.docEstrutura.GeraRetornoDebug(this);
            } else {
                this.mCodigoRetornoSQLAda = this.SACommand(this.mConexao, comando);
                this.mAreaRetornoSQLAda = this.strArea;
            }
            if (this.mCodigoRetornoSQLAda >= 0) {
                XMLAdaJ.setErro(0, "");
                return this.mAreaRetornoSQLAda;
            }
            XMLAdaJ.setErro(this.mCodigoRetornoSQLAda, this.mAreaRetornoSQLAda);
            return "";
        }
        catch (Exception e) {
            XMLAdaJ.setErro(e.hashCode(), "(command) " + e.getMessage());
            this.disconnect();
            return "";
        }
    }

    public String select(String comando, String fileEstrutura, String fileXsl, String fileTipos, boolean bTransform, long maxRows, long mQtdRows, String arqsai, long rowini) {
        String retorno;
        block24: {
            XMLAdaJ.setErro(0, "");
            this.mRows = 0L;
            long qtdregs = 0L;
            long qtdRows = 0L;
            String parametros = "";
            retorno = "";
            try {
                try {
                    if (fileEstrutura == null) {
                        fileEstrutura = "";
                    }
                    if (fileXsl == null) {
                        fileXsl = "";
                    }
                    if (fileTipos == null) {
                        fileTipos = "";
                    }
                    qtdRows = mQtdRows;
                    if (fileEstrutura.length() > 0 && !Util.isFullPath(fileEstrutura)) {
                        fileEstrutura = String.valueOf(this.docConfig.getCaminhoEstruturas()) + "\\" + fileEstrutura;
                    }
                    if (fileTipos.length() > 0 && !Util.isFullPath(fileTipos)) {
                        fileTipos = String.valueOf(this.docConfig.getCaminhoTipos()) + "\\" + fileTipos;
                    }
                    if (rowini == 0L) {
                        rowini = 1L;
                    }
                    if (maxRows > 0L) {
                        this.docConfig.setMaxRows(maxRows);
                    }
                    arqsai = arqsai != null ? arqsai : "";
                    DomDocument domDocument = this.docxml = arqsai.length() <= 0 ? new DomDocument("", true) : new DomDocument(String.valueOf(this.getPrefixoArqSai()) + arqsai + ".xml", true);
                    if (fileXsl.length() > 0 && !bTransform) {
                        this.docxml.getDomDoc().appendChild(this.docxml.getDomDoc().createProcessingInstruction("xml-stylesheet", "type='text/xsl' href='" + this.docConfig.getCaminhoVirtualXSL() + "/" + fileXsl + "'"));
                    }
                    if (fileXsl.length() > 0 && !Util.isFullPath(fileXsl)) {
                        fileXsl = String.valueOf(this.docConfig.getCaminhoXSL()) + "\\" + fileXsl;
                    }
                    this.docxml.setRaiz(this.docxml.criaElemento("result"));
                    if (!this.mInicializada) {
                        XMLAdaJ.setErro(-99, "(select) Classe n\u00e3o foi inicializada.");
                        break block24;
                    }
                    if (comando.length() <= 0 || !this.mInicializada || !this.connect()) break block24;
                    int posParam = comando.indexOf("PARAM");
                    if (posParam > 0) {
                        parametros = comando.substring(posParam + 6);
                        comando = comando.substring(0, posParam - 1);
                    }
                    this.docEstrutura = new DocFileEstrutura(fileEstrutura);
                    if (comando.substring(0, 8).equals("SELECT *")) {
                        comando = this.docEstrutura.getOk() ? this.docEstrutura.GeraSelect(comando) : this.geraSelectAll(comando);
                    }
                    this.comando(comando);
                    this.mRows = qtdregs = (long)this.mCodigoRetornoSQLAda;
                    if (qtdregs < 0L) {
                        XMLAdaJ.setErro(this.mCodigoRetornoSQLAda, "(select) " + this.mAreaRetornoSQLAda);
                        break block24;
                    }
                    if (qtdregs <= this.docConfig.getMaxRows()) {
                        if (rowini > qtdregs) {
                            rowini = 1L;
                        }
                        if (qtdRows > 0L) {
                            qtdregs = qtdRows < qtdregs - rowini ? qtdRows : qtdregs - rowini + 1L;
                        }
                        this.preencheDescricaoCamposSelect(comando);
                        comando = new String(Util.TrocaCaracteresEspeciais(new StringBuffer(comando)));
                        String arqXMLTipos = "";
                        arqXMLTipos = fileTipos.length() <= 0 ? (this.docConfig.getTipoDefault().length() <= 0 ? arqXMLTipos : String.valueOf(this.docConfig.getCaminhoTipos()) + "\\" + this.docConfig.getTipoDefault()) : fileTipos;
                        this.docTipos = new DocTipos(arqXMLTipos);
                        if (rowini == 0L) {
                            rowini = 1L;
                        }
                        this.insereAtributosParam(this.docxml.getRaiz(), parametros);
                        this.docxml.getRaiz().setAttribute("coderro", "" + mCodigoErro);
                        this.docxml.getRaiz().setAttribute("strerro", Util.TrocaCaracteresEspeciais(new StringBuffer(mDescricaoErro)));
                        this.docxml.getRaiz().setAttribute("rows", "" + qtdregs);
                        this.docxml.getRaiz().setAttribute("rowini", "" + rowini);
                        this.docxml.getRaiz().setAttribute("qtdrows", "" + qtdRows);
                        this.docxml.getRaiz().setAttribute("totrows", "" + this.mRows);
                        this.docxml.getRaiz().setAttribute("tamreg", this.mAreaRetornoSQLAda.length() <= 4 ? "" : this.mAreaRetornoSQLAda.substring(0, 4));
                        this.docxml.getRaiz().setAttribute("sacommand", comando);
                        if (this.DEBUG) {
                            this.docxml.getRaiz().setAttribute("area_retorno_select", this.mAreaRetornoSQLAda);
                        }
                        this.formataRegSelect(qtdregs, rowini, arqsai);
                        if (!this.docxml.getOk()) {
                            XMLAdaJ.setErro(-96, "(select) documento XML resultante est\u00e1 mal formado.");
                        } else {
                            retorno = bTransform ? new DomDocument(this.docxml.getXml()).transform(fileXsl, ".html") : this.docxml.getXml();
                        }
                        break block24;
                    }
                    XMLAdaJ.setErro(-91, "(select) Quantidade de registros encontrados al\u00e9m do permitido:" + qtdregs + " (maxrows=" + this.docConfig.getMaxRows() + ")");
                }
                catch (Exception e) {
                    XMLAdaJ.setErro(e.hashCode(), "(select) " + e.getMessage());
                }
            }
            catch (Throwable throwable) {}
        }
        return retorno;
    }

    public String select(String fileConsulta, String nomeConsulta, String where, long rowini) {
        String comando;
        block9: {
            comando = "";
            try {
                if (fileConsulta.length() != 0 && nomeConsulta.length() != 0) break block9;
                XMLAdaJ.setErro(-94, "(select) Arquivo ou nome de consulta em branco.");
                return "";
            }
            catch (Exception e) {
                XMLAdaJ.setErro(e.hashCode(), "(select) " + e.getMessage());
                return "";
            }
        }
        if (!Util.isFullPath(fileConsulta)) {
            fileConsulta = String.valueOf(this.docConfig.getCaminhoConsultas()) + "\\" + fileConsulta;
            DocConsulta docConsulta = new DocConsulta(fileConsulta, nomeConsulta);
            if (docConsulta.getOk()) {
                comando = "SELECT " + docConsulta.getSelect() + " FROM " + docConsulta.getBanco(this.getNomeAmbiente()) + " WHERE " + where;
                if (docConsulta.getMaxrows() > 0L) {
                    this.docConfig.setMaxRows(docConsulta.getMaxrows());
                }
                if (docConsulta.getSelect().length() > 0 && docConsulta.getBanco(this.getNomeAmbiente()).length() > 0 && where.length() > 0) {
                    return this.select(comando, docConsulta.getFileEstrutura(), docConsulta.getFileXsl(), docConsulta.getFileTipos(), docConsulta.isTransform(), this.docConfig.getMaxRows(), docConsulta.getQtdRows(), docConsulta.getFileSaida(), rowini <= 0L ? docConsulta.getRowIni() : rowini);
                }
                XMLAdaJ.setErro(-93, "(select) Comando SELECT inv\u00e1lido: " + comando);
            } else {
                XMLAdaJ.setErro(-92, "(select) Nome de Consulta " + nomeConsulta + " n\u00e3o foi encontrado.");
            }
        } else {
            XMLAdaJ.setErro(-95, "(select) Arquivo de consulta " + fileConsulta + " n\u00e3o pode ser carregado.  Verifique se existe ou est\u00e1 bem formado.");
        }
        return "";
    }

    public String select(String comando) {
        return this.select(comando, null, null, null, false, 0L, 0L, null, 0L);
    }

    public void insereAtributosParam(Element elemento, String atributos) {
        if (atributos.length() > 0) {
            String[] atributoValor = new String[]{"", ""};
            StringTokenizer tokensAtributos = new StringTokenizer(atributos.trim(), "=", true);
            String atributo = tokensAtributos.nextToken();
            while (tokensAtributos.hasMoreTokens()) {
                atributoValor[0] = atributo.trim().indexOf(" ") <= 0 ? atributo : atributo.substring(atributo.trim().lastIndexOf(" ") + 1);
                atributo = tokensAtributos.nextToken();
                atributo = tokensAtributos.nextToken();
                atributoValor[1] = atributo.trim().lastIndexOf(" ") <= atributo.trim().lastIndexOf("'") ? atributo : atributo.substring(0, atributo.trim().lastIndexOf(" "));
                elemento.setAttribute(atributoValor[0].trim(), atributoValor[1].trim().replaceAll("'|\"", ""));
            }
        }
    }

    public String getPrefixoArqSai() {
        return String.valueOf(Util.nomePasta(this.mCaminhoNomeXMLAdaIConfig)) + "\\" + this.mUsuario + this.mConexao;
    }

    public void insert(String strDoc, Integer countCmt, String numFileInsert) {
        try {
            boolean isFile;
            if (!this.mInicializada) {
                XMLAdaJ.setErro(-99, "(insert) Classe n\u00e3o foi inicializada.");
                return;
            }
            if (!this.mConectada) {
                this.connect();
            }
            if (countCmt == null) {
                countCmt = new Integer(0);
            }
            if (numFileInsert == null) {
                numFileInsert = "";
            }
            this.mCountCmt = 1;
            this.fileInsert = "";
            this.mRows = 0L;
            if (countCmt != 0) {
                this.mCountCmt = countCmt;
            }
            if (numFileInsert.length() > 0) {
                this.fileInsert = numFileInsert;
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SaxHandlerInsert saxHandler = new SaxHandlerInsert();
            SAXParser reader = factory.newSAXParser();
            boolean bl = isFile = !strDoc.substring(0, 1).equals("<");
            if (isFile) {
                if (!Util.isFullPath(strDoc)) {
                    strDoc = String.valueOf(appPath) + "\\" + strDoc;
                }
                reader.parse(new File(strDoc), (DefaultHandler)saxHandler);
            } else {
                reader.parse(new InputSource(new StringReader(strDoc)), (DefaultHandler)saxHandler);
            }
        }
        catch (Exception e) {
            XMLAdaJ.setErro(e.hashCode(), "(insert) " + e.getMessage());
        }
    }

    public void commit() {
        this.comando("COMMIT");
        if (this.mCodigoRetornoSQLAda != 0) {
            XMLAdaJ.setErro(this.mCodigoRetornoSQLAda, "(commit) Erro no COMMIT: " + this.mAreaRetornoSQLAda);
        }
    }

    private void formataRegSelect(long qtdregs, long RowIni, String outFile) throws IOException {
        String str = "";
        TextBuffer filetemp = null;
        BufferedReader ftr = null;
        if (this.DEBUG) {
            filetemp = new TextBuffer(String.valueOf(this.getPrefixoArqSai()) + "tmpxml.txt", true, true);
        } else {
            long i = 1L;
            while (i < RowIni - 1L) {
                int n = this.SAGetNext(this.mConexao);
                ++i;
            }
            filetemp = outFile == null ? new TextBuffer("", false) : new TextBuffer(String.valueOf(this.getPrefixoArqSai()) + "tmpxml.txt", true);
            i = 1L;
            while (i <= qtdregs) {
                int ret = this.SAGetNext(this.mConexao);
                if (ret < 0) {
                    this.mCodigoRetornoSQLAda = ret;
                    this.mAreaRetornoSQLAda = this.strArea;
                    XMLAdaJ.setErro(this.mCodigoRetornoSQLAda, "(formataRegSelect) Erro do SAGetNext: " + this.mAreaRetornoSQLAda);
                    if (i == 1L) {
                        return;
                    }
                    i = qtdregs + 1L;
                } else {
                    filetemp.putLine(this.strArea);
                }
                ++i;
            }
        }
        filetemp.CloseFile();
        ftr = filetemp.getInFile();
        this.docEstrutura.insereAtributos(this.docEstrutura.getRaiz(), this.docxml.getRaiz(), this.docTipos, "");
        while ((str = ftr.readLine()) != null) {
            this.docEstrutura.FormataRegistroSelect(str, this.docxml, this.docTipos, this.descricaoCampos);
        }
        filetemp.CloseFile();
        this.docxml.gravaDoc();
    }

    private void preencheDescricaoCamposSelect(String comando) {
        int posIniCampos = comando.indexOf(" ") + 1;
        int posFimCampos = comando.indexOf("FROM") - 1;
        String strCampos = comando.substring(posIniCampos, posFimCampos);
        this.strcampos = strCampos.split(" ");
        String strAreaCampos = this.mAreaRetornoSQLAda.substring(0, this.mAreaRetornoSQLAda.indexOf("."));
        this.descricaoCampos.clear();
        int posAtualRetornoAdabas = 6;
        int i = 0;
        while (i < this.strcampos.length) {
            String strAposCampo = this.strcampos[i].substring(2);
            if (strAposCampo.indexOf("/X") > 0) {
                strAposCampo = strAposCampo.substring(0, strAposCampo.indexOf("/X"));
            }
            DimCampoAdabas dimensaoCampo = this.strcampos[i].length() <= 4 ? new DimCampoAdabas() : new DimCampoAdabas(strAposCampo);
            int numeroValores = dimensaoCampo.getArea();
            int k = 0;
            while (k < numeroValores) {
                this.descricaoCampos.addElement(new DescricaoCampoAdabas(this.strcampos[i], strAreaCampos, dimensaoCampo, posAtualRetornoAdabas));
                posAtualRetornoAdabas += 6;
                ++k;
            }
            ++i;
        }
    }

    private String geraSelectAll(String cmd) {
        String arquivoAdabas = cmd.substring(14, 21);
        int j = this.preencheDescricaoCamposAll(arquivoAdabas);
        if (j > 0) {
            int periodico = -1;
            String comando = "SELECT ";
            int i = 0;
            while (i < j) {
                DescricaoCampoAdabas descricaoCampo = (DescricaoCampoAdabas)this.descricaoCampos.get(i);
                if (descricaoCampo.getNivel() == 1) {
                    if (descricaoCampo.getTamanho() > 0) {
                        periodico = -1;
                        if (!descricaoCampo.isIssuperdescritor()) {
                            comando = String.valueOf(comando) + descricaoCampo.getNome();
                            if (descricaoCampo.getTipoOcorrencia().equals("M") || descricaoCampo.getTipoOcorrencia().equals("P")) {
                                comando = String.valueOf(comando) + "001-010";
                            }
                            comando = String.valueOf(comando) + " ";
                        }
                    } else if (descricaoCampo.getTipoOcorrencia().equals("P")) {
                        periodico = i;
                    }
                } else if (descricaoCampo.getNivel() == 2 && descricaoCampo.getTamanho() > 0) {
                    comando = String.valueOf(comando) + descricaoCampo.getNome();
                    if (descricaoCampo.getTipoOcorrencia().equals("M")) {
                        comando = String.valueOf(comando) + (periodico < 0 ? "001-010" : "001-010(001-010)");
                    } else if (descricaoCampo.getTipoOcorrencia().equals("P") && periodico >= 0) {
                        comando = String.valueOf(comando) + "001-010";
                    }
                    comando = String.valueOf(comando) + " ";
                }
                ++i;
            }
            return String.valueOf(comando) + cmd.substring(9, cmd.length());
        }
        return cmd;
    }

    public int preencheDescricaoCamposAll(String file) {
        boolean j = false;
        String comando = this.comando("GETSET LAYOUT " + file + " ALL");
        try {
            try {
                if (comando.length() > 0) {
                    comando = comando.substring(0, comando.indexOf("."));
                    int i = 0;
                    while (i < comando.length()) {
                        DescricaoCampoAdabas campo = new DescricaoCampoAdabas(comando.substring(i, i + 9));
                        this.descricaoCampos.addElement(campo);
                        i += 9;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return this.descricaoCampos.size();
    }

    public String textoXml(String strTexto, String fileEstrutura, boolean isFile) {
        String result = "";
        try {
            try {
                DocFileEstrutura docEstrutura;
                if (isFile) {
                    strTexto = new TextBuffer(strTexto, true, true).getTexto();
                }
                if (strTexto.length() != 0 && (docEstrutura = new DocFileEstrutura(fileEstrutura)).getOk()) {
                    result = docEstrutura.FormataTexto2Xml(strTexto, this.docConfig);
                }
            }
            catch (Exception e) {
                XMLAdaJ.setErro(e.hashCode(), "(TextoXml) " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {}
        return result;
    }

    public void delete(String numFile, String where, int countCmt) {
        try {
            DomDocument docIsns = new DomDocument(this.select("SELECT ISN FROM " + numFile + " WHERE " + where));
            if (docIsns.getOk()) {
                String isns = "";
                long delCount = 0L;
                Element root = docIsns.getDomDoc().getDocumentElement();
                NodeList rowList = root.getChildNodes();
                String comando = "DELETE FROM " + numFile;
                int i = 0;
                while (i < rowList.getLength()) {
                    Element linha = (Element)rowList.item(i);
                    NodeList fieldList = linha.getChildNodes();
                    int j = 0;
                    while (j < fieldList.getLength()) {
                        Element campo = (Element)fieldList.item(j);
                        if (campo.getNodeName().equals("ISN")) {
                            isns = String.valueOf(isns) + " " + campo.getNodeValue();
                            if (++delCount == (long)countCmt) {
                                this.comando(String.valueOf(comando) + isns);
                                if (mCodigoErro != 0) {
                                    return;
                                }
                                this.commit();
                                if (mCodigoErro != 0) {
                                    return;
                                }
                                delCount = 0L;
                                isns = "";
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                if (delCount > 0L) {
                    this.comando(String.valueOf(comando) + isns);
                    if (mCodigoErro != 0) {
                        return;
                    }
                    this.commit();
                    if (mCodigoErro != 0) {
                        return;
                    }
                    delCount = 0L;
                    isns = "";
                }
            } else {
                XMLAdaJ.setErro(-96, "(delete) documento XML resultante do SELECT est\u00e1 mal formado.");
            }
        }
        catch (Exception e) {
            XMLAdaJ.setErro(e.hashCode(), "(delete) " + e.getLocalizedMessage());
        }
    }

    private String strErro() {
        return String.valueOf(this.strMetodoErro) + ": " + this.strArea + " - " + this.strException + ": " + this.strMsgErro;
    }

    public static void setAppPath(String mappPath) {
        appPath = mappPath;
    }

    public static String getAppPath() {
        return appPath;
    }

    public static String getDescricaoErro() {
        return mDescricaoErro;
    }

    public static void setDescricaoErro(String d) {
        mDescricaoErro = d;
    }

    public static int getCodigoErro() {
        return mCodigoErro;
    }

    public static void setCodigoErro(int e) {
        mCodigoErro = e;
    }

    public static void setErro(int e, String d) {
        mCodigoErro = e;
        mDescricaoErro = d;
    }

    public String getNomeAmbiente() {
        return this.mNomeAmbiente;
    }

    public int getCodigoRetornoSQLAda() {
        return this.mCodigoRetornoSQLAda;
    }

    public String getAreaRetornoSQLAda() {
        return this.mAreaRetornoSQLAda;
    }

    public String getParameter() {
        return this.mParameter;
    }

    public long getRows() {
        return this.mRows;
    }

    public int getCmtTotal() {
        return this.mCmtTotal;
    }

    public void setCmtTotal(int cmtTotal) {
        this.mCmtTotal = cmtTotal;
    }

    public int getCountCmt() {
        return this.mCountCmt;
    }

    public void setCountCmt(int countCmt) {
        this.mCountCmt = countCmt;
    }

    public String getFileInsert() {
        return this.fileInsert;
    }

    public void setFileInsert(String fileInsert) {
        this.fileInsert = fileInsert;
    }

    public void setRows(long rows) {
        this.mRows = rows;
    }

    public Vector getDescricaoCampos() {
        return this.descricaoCampos;
    }

    public String getCaminhoConfig() {
        return this.mCaminhoNomeXMLAdaIConfig;
    }

    public String getUsuario() {
        return this.mUsuario;
    }

    public int getConexao() {
        return this.mConexao;
    }

    public String getVersao() {
        return "1.0";
    }
}

