/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import java.util.HashMap;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.alimentandos.Alimentandos;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.dependentes.Dependentes;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.pagamentos.Pagamentos;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosPagamentos
extends Observador {
    private DeclaracaoIRPF declaracaoIRPF = null;

    public CalculosPagamentos(DeclaracaoIRPF dec) {
        this.declaracaoIRPF = dec;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                ((Pagamento)valorNovo).getCodigo().addObservador((Observador)this);
                ((Pagamento)valorNovo).getTipo().addObservador((Observador)this);
                ((Pagamento)valorNovo).getDependenteOuAlimentando().addObservador((Observador)this);
                ((Pagamento)valorNovo).getValorPago().addObservador((Observador)this);
                ((Pagamento)valorNovo).getContribuicaoEntePatrocinador().addObservador((Observador)this);
                ((Pagamento)valorNovo).getParcelaNaoDedutivel().addObservador((Observador)this);
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                ((Pagamento)valorNovo).getCodigo().removeObservador((Observador)this);
                ((Pagamento)valorNovo).getTipo().addObservador((Observador)this);
                ((Pagamento)valorNovo).getDependenteOuAlimentando().addObservador((Observador)this);
                ((Pagamento)valorNovo).getValorPago().removeObservador((Observador)this);
                ((Pagamento)valorNovo).getContribuicaoEntePatrocinador().removeObservador((Observador)this);
                ((Pagamento)valorNovo).getParcelaNaoDedutivel().removeObservador((Observador)this);
            }
        }
        this.calculaTotalDeducoesInstrucao();
        this.calculaTotalContribuicao();
        this.calculaTotalContribuicaoFunpresp();
        this.calculaTotalDespesasMedicas();
        this.calculaTotalPensao();
        this.calculaTotalPensaoCartoral();
        this.calculaTotalContribEmpregadoDomestico();
    }

    private void calculaTotalContribEmpregadoDomestico() {
        Valor total = new Valor();
        for (Pagamento pag : this.declaracaoIRPF.getPagamentos().itens()) {
            if (!pag.getCodigo().naoFormatado().equals("50") || pag.getTipo().naoFormatado().equals("A")) continue;
            total.append('+', pag.getValorPago());
            total.append('-', pag.getParcelaNaoDedutivel());
        }
        if (total.comparacao("<", "0,00")) {
            total.clear();
        }
        this.declaracaoIRPF.getPagamentos().getTotalContribEmpregadoDomestico().setConteudo(total);
    }

    private void calculaTotalPensao() {
        this.declaracaoIRPF.getPagamentos().getTotalPensao().setConteudo(CalculosPagamentos.totalizarPagamentos(this.declaracaoIRPF.getPagamentos(), new String[]{"30", "31"}, true, true));
    }

    private void calculaTotalPensaoCartoral() {
        this.declaracaoIRPF.getPagamentos().getTotalPensaoCartoral().setConteudo(CalculosPagamentos.totalizarPagamentos(this.declaracaoIRPF.getPagamentos(), new String[]{"33", "34"}, true, true));
    }

    private void calculaTotalDeducoesInstrucao() {
        Valor valTotalDespesasInstrucao = new Valor();
        Valor despesasInstrucaoPropria = new Valor();
        despesasInstrucaoPropria.setConteudo(CalculosPagamentos.totalizarPagamentos(this.declaracaoIRPF.getPagamentos(), new String[]{"T", "T"}, new String[]{"01", "02"}, true));
        if (despesasInstrucaoPropria.comparacao(">", TabelaAliquotasIRPF.ConstantesAliquotas.deducaoDespesaInstrucao.getValor())) {
            despesasInstrucaoPropria.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.deducaoDespesaInstrucao.getValor());
        }
        Valor despesasInstrucaoDep = new Valor();
        despesasInstrucaoDep.setConteudo(this.totalizarPagamentosPorBeneficiarioComLimite(this.declaracaoIRPF.getPagamentos(), new String[]{"D", "D", "A", "A"}, new String[]{"01", "02", "01", "02"}));
        valTotalDespesasInstrucao.append('+', despesasInstrucaoPropria);
        valTotalDespesasInstrucao.append('+', despesasInstrucaoDep);
        this.declaracaoIRPF.getPagamentos().getTotalDeducoesInstrucao().setConteudo(valTotalDespesasInstrucao);
    }

    private void calculaTotalContribuicao() {
        CalculosPagamentos.calculaTotalContribuicaoEstatico(this.declaracaoIRPF);
    }

    private void calculaTotalContribuicaoFunpresp() {
        this.declaracaoIRPF.getPagamentos().getTotalContribuicaoFunpresp().setConteudo(CalculosPagamentos.totalizarPagamentos(this.declaracaoIRPF.getPagamentos(), new String[]{"37"}, true, true));
    }

    public static void calculaTotalContribuicaoEstatico(DeclaracaoIRPF declaracaoIRPF) {
        declaracaoIRPF.getPagamentos().getTotalContribuicaoPreviPrivada().setConteudo(CalculosPagamentos.calculaTotalContribuicaoPreviPrivada(declaracaoIRPF, declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos()));
    }

    public static Valor calculaTotalContribuicaoPreviPrivada(DeclaracaoIRPF declaracaoIRPF, Valor totalRendTributaveis) {
        Valor contribPrevPrivada = new Valor();
        contribPrevPrivada.setConteudo(CalculosPagamentos.totalizarPagamentos(declaracaoIRPF.getPagamentos(), new String[]{"36"}, true, true));
        contribPrevPrivada.append('+', CalculosPagamentos.totalizarValorPagoAtravesFunpresp(declaracaoIRPF.getPagamentos()));
        Valor percentualPrevidencia = new Valor();
        percentualPrevidencia.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.deducaoPrevidenciaPrivada.getValor());
        percentualPrevidencia.append('/', "100,00");
        if (contribPrevPrivada.comparacao(">", totalRendTributaveis.operacao('*', percentualPrevidencia))) {
            contribPrevPrivada.setConteudo(totalRendTributaveis.operacao('*', percentualPrevidencia));
        }
        return contribPrevPrivada;
    }

    private void calculaTotalDespesasMedicas() {
        Valor totalDespMedicas = CalculosPagamentos.totalizarPagamentos(this.declaracaoIRPF.getPagamentos(), new String[]{"09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "26"}, true, false);
        this.declaracaoIRPF.getPagamentos().getTotalDespesasMedicas().setConteudo(totalDespMedicas);
    }

    public static Valor totalizarPagamentosGlosado(Pagamentos pagamentos, String[] codigo, boolean abateParcelaNaoDedutivel) {
        Valor result = CalculosPagamentos.totalizarPagamentos(pagamentos, codigo, abateParcelaNaoDedutivel, true);
        if (result.comparacao("<", "0,00")) {
            result.clear();
        }
        return result;
    }

    public static Valor totalizarPagamentos(Pagamentos pagamentos, String[] tipo, String[] codigo, boolean abateParcelaNaoDedutivel) {
        Valor total = new Valor();
        List objColecao = pagamentos.itens();
        for (int i = 0; i <= pagamentos.itens().size() - 1; ++i) {
            Pagamento obj = (Pagamento)objColecao.get(i);
            for (int j = 0; j < codigo.length; ++j) {
                if (!obj.getTipo().toString().equals(tipo[j]) || !obj.getCodigo().toString().equals(codigo[j]) || !obj.getValorPago().comparacao(">=", obj.getParcelaNaoDedutivel())) continue;
                total.append('+', obj.getValorPago());
                if (!abateParcelaNaoDedutivel) continue;
                total.append('-', obj.getParcelaNaoDedutivel());
            }
        }
        return total;
    }

    public static Valor totalizarPagamentos(Pagamentos pagamentos, String[] codigo, boolean abateParcelaNaoDedutivel, boolean semAlimentandos) {
        Valor total = new Valor();
        List objColecao = pagamentos.itens();
        for (int i = 0; i <= pagamentos.itens().size() - 1; ++i) {
            Pagamento obj = (Pagamento)objColecao.get(i);
            for (int j = 0; j < codigo.length; ++j) {
                if (!obj.getCodigo().toString().equals(codigo[j]) || !obj.getValorPago().comparacao(">=", obj.getParcelaNaoDedutivel()) || !obj.isPensao() && obj.getTipo().naoFormatado().equals("A") && semAlimentandos) continue;
                if (obj.isFunpresp()) {
                    total.append('+', obj.getValorPagoFunprespCalculado());
                } else {
                    total.append('+', obj.getValorPago());
                }
                if (!abateParcelaNaoDedutivel) continue;
                total.append('-', obj.getParcelaNaoDedutivel());
            }
        }
        return total;
    }

    public static Valor totalizarValorPagoAtravesFunpresp(Pagamentos pagamentos) {
        Valor total = new Valor();
        List objColecao = pagamentos.itens();
        for (int i = 0; i <= pagamentos.itens().size() - 1; ++i) {
            Pagamento obj = (Pagamento)objColecao.get(i);
            if (!obj.isFunpresp()) continue;
            total.append('+', obj.getValorPagoAtravesFunpresp());
        }
        return total;
    }

    public static Valor totalizarPagamentosPorBeneficiarioComLimite(Pagamentos pagamentos, String[] codigo) {
        Valor retorno = new Valor();
        class Beneficiario {
            private String cpf = null;
            private Valor total = new Valor();

            public Beneficiario(String pCpf) {
                this.cpf = pCpf;
            }
        }
        HashMap<String, Beneficiario> mapBeneficiarios = new HashMap<String, Beneficiario>();
        List objColecao = pagamentos.itens();
        for (int i = 0; i <= pagamentos.itens().size() - 1; ++i) {
            Pagamento obj = (Pagamento)objColecao.get(i);
            for (int j = 0; j < codigo.length; ++j) {
                if (!obj.getCodigo().toString().equals(codigo[j])) continue;
                Beneficiario beneficiario = null;
                if (!mapBeneficiarios.containsKey(obj.getDependenteOuAlimentando().naoFormatado())) {
                    beneficiario = new Beneficiario(obj.getDependenteOuAlimentando().naoFormatado());
                    mapBeneficiarios.put(beneficiario.cpf, beneficiario);
                } else {
                    beneficiario = (Beneficiario)mapBeneficiarios.get(obj.getDependenteOuAlimentando().naoFormatado());
                }
                if (!obj.getValorPago().comparacao(">=", obj.getParcelaNaoDedutivel())) continue;
                beneficiario.total.append('+', obj.getValorPago());
                beneficiario.total.append('-', obj.getParcelaNaoDedutivel());
            }
        }
        for (Beneficiario b : mapBeneficiarios.values()) {
            if (b.total.comparacao(">", TabelaAliquotasIRPF.ConstantesAliquotas.deducaoDespesaInstrucao.getValor())) {
                b.total.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.deducaoDespesaInstrucao.getValor());
            }
            retorno.append('+', b.total);
        }
        return retorno;
    }

    private String obtemCpfAlimentandoOuDependente(String nome, String tipo) {
        String cpf;
        block3: {
            Dependentes dependentes;
            block2: {
                cpf = "";
                Alimentandos alimentandos = this.declaracaoIRPF.getAlimentandos();
                dependentes = this.declaracaoIRPF.getDependentes();
                if (!tipo.equals("A")) break block2;
                for (ObjetoNegocio alimentando : alimentandos.itens()) {
                    if (!((Alimentando)alimentando).getNome().naoFormatado().equals(nome)) continue;
                    cpf = ((Alimentando)alimentando).getCpf().naoFormatado();
                }
                break block3;
            }
            if (!tipo.equals("D")) break block3;
            for (ObjetoNegocio dependente : dependentes.itens()) {
                if (!((Dependente)dependente).getNome().naoFormatado().equals(nome)) continue;
                cpf = ((Dependente)dependente).getCpfDependente().naoFormatado();
            }
        }
        return cpf;
    }

    public Valor totalizarPagamentosPorBeneficiarioComLimite(Pagamentos pagamentos, String[] tipo, String[] codigo) {
        Valor retorno = new Valor();
        class Beneficiario {
            private String cpf = null;
            private Valor total = new Valor();

            public Beneficiario(String pCpf) {
                this.cpf = pCpf;
            }
        }
        HashMap<String, Beneficiario> mapBeneficiarios = new HashMap<String, Beneficiario>();
        List objColecao = pagamentos.itens();
        for (int i = 0; i <= pagamentos.itens().size() - 1; ++i) {
            Pagamento obj = (Pagamento)objColecao.get(i);
            for (int j = 0; j < codigo.length; ++j) {
                String tp;
                if (!obj.getTipo().toString().equals(tipo[j]) || !obj.getCodigo().toString().equals(codigo[j])) continue;
                Beneficiario beneficiario = null;
                String nome = obj.getDependenteOuAlimentando().naoFormatado();
                String cpf = this.obtemCpfAlimentandoOuDependente(nome, tp = tipo[j]);
                if (cpf.equals("")) {
                    cpf = nome;
                }
                if (cpf.equals("")) continue;
                if (!mapBeneficiarios.containsKey(cpf)) {
                    beneficiario = new Beneficiario(cpf);
                    mapBeneficiarios.put(beneficiario.cpf, beneficiario);
                } else {
                    beneficiario = (Beneficiario)mapBeneficiarios.get(cpf);
                }
                if (!obj.getValorPago().comparacao(">=", obj.getParcelaNaoDedutivel())) continue;
                beneficiario.total.append('+', obj.getValorPago());
                beneficiario.total.append('-', obj.getParcelaNaoDedutivel());
            }
        }
        for (Beneficiario b : mapBeneficiarios.values()) {
            if (b.total.comparacao(">", TabelaAliquotasIRPF.ConstantesAliquotas.deducaoDespesaInstrucao.getValor())) {
                b.total.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.deducaoDespesaInstrucao.getValor());
            }
            retorno.append('+', b.total);
        }
        return retorno;
    }
}

